/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.privilege.base;

import com.fr.base.FRContext;
import com.fr.file.filetree.FileNode;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.base.entity.User;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.EntryControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.web.platform.entry.Entry;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.web.core.IdGenerator;
import com.fr.web.core.ReportWebUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class FSPrivilegeTools {
    public static final int FILTERLEVELPAGE = 1;
    public static final int FILTERLEVELWRITE = 2;
    public static final int FILTERLEVELDESIGN = 3;
    public static final int FILTERLEVELNONE = 0;
    private static FSPrivilegeTools FSPT = new FSPrivilegeTools();

    private FSPrivilegeTools() {
    }

    public static FSPrivilegeTools getInstance() {
        return FSPT;
    }

    public boolean hasFolderEditPrivilege(Set set, EntryTypeAndID entryTypeAndID) {
        if (set.contains(EntryTypeAndID.getInstance(0, -1L))) {
            return true;
        }
        for (Object e : set) {
            EntryTypeAndID entryTypeAndID2 = (EntryTypeAndID)e;
            if (ComparatorUtils.equals((Object)entryTypeAndID2, (Object)entryTypeAndID) && entryTypeAndID2.getEdit() == 1L) {
                return true;
            }
            if (entryTypeAndID2.getType() != 0 || entryTypeAndID2.getEdit() != 1L) continue;
            Entry entry = EntryControl.getInstance().getEntry(entryTypeAndID.getType(), entryTypeAndID.getId());
            while (entry.getParentId() > 0L) {
                if (entry.getParentId() == entryTypeAndID2.getId()) {
                    return true;
                }
                entry = EntryControl.getInstance().getEntry(0, entry.getParentId());
            }
        }
        return false;
    }

    public EntryTypeAndID getEntryPrivilege(Set set, EntryTypeAndID entryTypeAndID) {
        EntryTypeAndID entryTypeAndID2 = this.getEntryPrivilegeNoFolder(set, entryTypeAndID);
        if (entryTypeAndID2.getView() != 0L) {
            return entryTypeAndID2;
        }
        Entry entry = EntryControl.getInstance().getEntry(entryTypeAndID.getType(), entryTypeAndID.getId());
        while (entry.getParentId() > 0L) {
            EntryTypeAndID entryTypeAndID3 = this.getEntryPrivilegeNoFolder(set, EntryTypeAndID.getInstance(0, entry.getParentId()));
            if (entryTypeAndID3.getView() != 0L) {
                if (entryTypeAndID3.getView() != 1L) {
                    return entryTypeAndID;
                }
                entryTypeAndID.setView(1L);
                if (entryTypeAndID3.getAuthorized() != 1L) {
                    return entryTypeAndID;
                }
                entryTypeAndID.setAuthorized(1L);
                if (entryTypeAndID3.getEdit() != 1L) {
                    return entryTypeAndID;
                }
                entryTypeAndID.setEdit(1L);
                return entryTypeAndID;
            }
            entry = EntryControl.getInstance().getEntry(0, entry.getParentId());
        }
        if (set.contains(EntryTypeAndID.getInstance(0, -1L))) {
            entryTypeAndID.setView(1L);
            entryTypeAndID.setAuthorized(1L);
            entryTypeAndID.setEdit(1L);
        }
        return entryTypeAndID;
    }

    public boolean hasDesignPrivilege(String string, Set set) throws Exception {
        string = StringUtils.perfectStart((String)string, (String)"/");
        for (Object e : set) {
            RoleTemplatePrivilege roleTemplatePrivilege = (RoleTemplatePrivilege)((Object)e);
            String string2 = StringUtils.perfectStart((String)roleTemplatePrivilege.getPath(), (String)"/");
            if (roleTemplatePrivilege.getDesign() != 1L || !string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPageOrWritePrivilege(String string, Set set) throws Exception {
        string = StringUtils.perfectStart((String)string, (String)"/");
        for (Object e : set) {
            RoleTemplatePrivilege roleTemplatePrivilege = (RoleTemplatePrivilege)((Object)e);
            String string2 = StringUtils.perfectStart((String)roleTemplatePrivilege.getPath(), (String)"/");
            if (roleTemplatePrivilege.getPage() != 1L && roleTemplatePrivilege.getWrite() != 1L || !ComparatorUtils.equals((Object)string2, (Object)string)) continue;
            return true;
        }
        return false;
    }

    public void filterFile(FileNode[] fileNodeArray, Set set, ArrayList arrayList, int n) throws Exception {
        block0: for (int i = 0; i < fileNodeArray.length; ++i) {
            int n2;
            String string = fileNodeArray[i].getEnvPath();
            String string2 = string.substring(n2 = string.indexOf("/"));
            if (StringUtils.isBlank((String)string2)) continue;
            for (Object e : set) {
                RoleTemplatePrivilege roleTemplatePrivilege = (RoleTemplatePrivilege)((Object)e);
                if (!this.hasPrivilege(roleTemplatePrivilege, n) || !this.examineTemplatePath(fileNodeArray[i], roleTemplatePrivilege)) continue;
                fileNodeArray[i].setPage(roleTemplatePrivilege.getPage());
                fileNodeArray[i].setWrite(roleTemplatePrivilege.getWrite());
                fileNodeArray[i].setDesign(roleTemplatePrivilege.getDesign());
                arrayList.add(fileNodeArray[i]);
                continue block0;
            }
        }
    }

    private boolean examineTemplatePath(FileNode fileNode, RoleTemplatePrivilege roleTemplatePrivilege) {
        String[] stringArray;
        int n;
        String string = fileNode.getEnvPath();
        String string2 = string.substring(n = string.indexOf("/"));
        if (ComparatorUtils.equals((Object)string2, (Object)("/" + roleTemplatePrivilege.getPath()))) {
            return true;
        }
        String[] stringArray2 = StringUtils.perfectStart((String)string2, (String)"/").split("/");
        if (stringArray2.length > (stringArray = StringUtils.perfectStart((String)roleTemplatePrivilege.getPath(), (String)"/").split("/")).length) {
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                if (ComparatorUtils.equals((Object)stringArray2[i], (Object)stringArray[i])) continue;
                return false;
            }
            return true;
        }
        if (fileNode.isDirectory() && stringArray.length > stringArray2.length) {
            int n3 = stringArray2.length;
            for (int i = 0; i < n3; ++i) {
                if (ComparatorUtils.equals((Object)stringArray2[i], (Object)stringArray[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static JSONArray getReportletsOfCurrentEnv(FileNode[] fileNodeArray, Set set, IdGenerator idGenerator, String string, int n) throws Exception {
        JSONArray jSONArray = new JSONArray();
        fileNodeArray = ReportWebUtils.filterAndSortFile((FileNode[])fileNodeArray, (String)string);
        for (int i = 0; i < fileNodeArray.length; ++i) {
            FileNode fileNode = fileNodeArray[i];
            String string2 = fileNode.getEnvPath().substring("reportlets".length() + 1);
            JSONObject jSONObject = new JSONObject();
            jSONArray.put((Object)jSONObject);
            try {
                jSONObject.put("id", idGenerator.generateId());
                jSONObject.put("text", (Object)fileNode.getName());
                jSONObject.put("value", (Object)fileNode.getName());
                jSONObject.put("path", (Object)string2);
                jSONObject.put("complete", true);
                jSONObject.put("isexpand", false);
                jSONObject.put("page", fileNode.getPage());
                jSONObject.put("write", fileNode.getWrite());
                jSONObject.put("design", fileNode.getDesign());
                if (!fileNode.isDirectory()) continue;
                jSONObject.put("hasChildren", true);
                FileNode[] fileNodeArray2 = FRContext.getCurrentEnv().listFile(fileNode.getEnvPath());
                ArrayList arrayList = new ArrayList();
                FSPrivilegeTools.getInstance().filterFile(fileNodeArray2, set, arrayList, n);
                FileNode[] fileNodeArray3 = new FileNode[arrayList.size()];
                int n2 = arrayList.size();
                for (int j = 0; j < n2; ++j) {
                    fileNodeArray3[j] = (FileNode)arrayList.get(j);
                }
                jSONObject.put("ChildNodes", (Object)FSPrivilegeTools.getReportletsOfCurrentEnv(fileNodeArray3, set, idGenerator, string, n));
                continue;
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().error(jSONException.getMessage(), (Throwable)jSONException);
            }
        }
        return jSONArray;
    }

    public JSONArray getEntryUsers(String string) throws Exception {
        JSONArray jSONArray = new JSONArray();
        if (!StringUtils.isBlank((String)string)) {
            this.addUserFromCompanyRole(jSONArray, string);
            this.addUserFromCustomRole(jSONArray, string);
        }
        return jSONArray;
    }

    private void addUserFromCompanyRole(JSONArray jSONArray, String string) throws Exception {
        int n = Integer.parseInt(string.substring(0, 1));
        long l = Long.parseLong(string.substring(1));
        EntryTypeAndID entryTypeAndID = EntryTypeAndID.getInstance(n, l);
        List list = CompanyRoleControl.getInstance().getAllCompanyRole();
        for (CompanyRole companyRole : list) {
            List<EntryTypeAndID> list2 = CompanyRoleControl.getInstance().getAllEntryPrivileges(companyRole.getId());
            HashSet<EntryTypeAndID> hashSet = new HashSet<EntryTypeAndID>();
            hashSet.addAll(list2);
            EntryTypeAndID entryTypeAndID2 = FSPrivilegeTools.getInstance().getEntryPrivilege(hashSet, entryTypeAndID);
            if (entryTypeAndID2.getView() == 0L) continue;
            this.addCompanyUser(companyRole, entryTypeAndID2, jSONArray);
            entryTypeAndID = EntryTypeAndID.getInstance(n, l);
        }
    }

    private void addUserFromCustomRole(JSONArray jSONArray, String string) throws Exception {
        int n = Integer.parseInt(string.substring(0, 1));
        long l = Long.parseLong(string.substring(1));
        EntryTypeAndID entryTypeAndID = EntryTypeAndID.getInstance(n, l);
        List<CustomRole> list = CustomRoleControl.getInstance().getAllCustomRole();
        for (CustomRole customRole : list) {
            List<EntryTypeAndID> list2 = CustomRoleControl.getInstance().getAllEntryPrivileges(customRole.getId());
            HashSet<EntryTypeAndID> hashSet = new HashSet<EntryTypeAndID>();
            hashSet.addAll(list2);
            EntryTypeAndID entryTypeAndID2 = FSPrivilegeTools.getInstance().getEntryPrivilege(hashSet, entryTypeAndID);
            if (entryTypeAndID2.getView() == 0L) continue;
            this.addCustomUser(customRole, entryTypeAndID2, jSONArray);
            entryTypeAndID = EntryTypeAndID.getInstance(n, l);
        }
    }

    private void addCompanyUser(CompanyRole companyRole, EntryTypeAndID entryTypeAndID, JSONArray jSONArray) throws Exception {
        Set set = CompanyRoleControl.getInstance().getUsersID(companyRole.getId());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            User user = UserControl.getInstance().getUser(l);
            this.addUser(user, jSONArray, entryTypeAndID);
        }
    }

    private void addCustomUser(CustomRole customRole, EntryTypeAndID entryTypeAndID, JSONArray jSONArray) throws Exception {
        Set set = CustomRoleControl.getInstance().getUsersID(customRole.getId());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            User user = UserControl.getInstance().getUser(l);
            this.addUser(user, jSONArray, entryTypeAndID);
        }
    }

    private void addUser(User user, JSONArray jSONArray, EntryTypeAndID entryTypeAndID) throws Exception {
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            if (jSONObject.getLong("id") != user.getId()) continue;
            long l = jSONObject.getLong("view");
            long l2 = this.getView(entryTypeAndID.getView());
            if (l == 0L && l2 == 1L) {
                jSONObject.put("view", 1);
            }
            long l3 = jSONObject.getLong("design");
            long l4 = this.getDesignAndEdit(entryTypeAndID.getAuthorized());
            if (l3 == 0L && l4 == 1L) {
                jSONObject.put("design", 1);
            }
            long l5 = jSONObject.getLong("edit");
            long l6 = this.getDesignAndEdit(entryTypeAndID.getEdit());
            if (l5 == 0L && l6 == 1L) {
                jSONObject.put("edit", 1);
            }
            return;
        }
        JSONObject jSONObject = user.createUnEditInfoJSONConfig();
        jSONObject.put("view", this.getView(entryTypeAndID.getView()));
        jSONObject.put("design", this.getDesignAndEdit(entryTypeAndID.getAuthorized()));
        jSONObject.put("edit", this.getDesignAndEdit(entryTypeAndID.getEdit()));
        jSONObject.put("id", user.getId());
        jSONArray.put((Object)jSONObject);
    }

    private long getView(long l) {
        if (l == 2L) {
            l = 1L;
        }
        return l;
    }

    private long getDesignAndEdit(long l) {
        if (l == 2L) {
            l = 0L;
        }
        return l;
    }

    private boolean isCptOrFrm(RoleTemplatePrivilege roleTemplatePrivilege) {
        String string = roleTemplatePrivilege.getPath();
        return string.endsWith(".cpt") || string.endsWith(".frm");
    }

    private boolean hasPrivilege(RoleTemplatePrivilege roleTemplatePrivilege, int n) {
        if (n == 1) {
            return roleTemplatePrivilege.getPage() == 1L;
        }
        if (n == 2) {
            return roleTemplatePrivilege.getWrite() == 1L;
        }
        if (n == 3) {
            return roleTemplatePrivilege.getDesign() == 1L;
        }
        return true;
    }

    private long getEditFromParent(Set set, Entry entry) {
        while (entry != null && entry.getParentId() > 0L) {
            EntryTypeAndID entryTypeAndID = EntryTypeAndID.getInstance(0, entry.getParentId());
            for (Object e : set) {
                EntryTypeAndID entryTypeAndID2 = (EntryTypeAndID)e;
                if (!ComparatorUtils.equals((Object)entryTypeAndID2, (Object)entryTypeAndID)) continue;
                return entryTypeAndID2.getEdit();
            }
            entry = EntryControl.getInstance().getEntry(0, entry.getParentId());
        }
        return 0L;
    }

    private EntryTypeAndID getEntryPrivilegeNoFolder(Set set, EntryTypeAndID entryTypeAndID) {
        for (Object e : set) {
            EntryTypeAndID entryTypeAndID2 = (EntryTypeAndID)e;
            if (!ComparatorUtils.equals((Object)entryTypeAndID2, (Object)entryTypeAndID)) continue;
            return entryTypeAndID2;
        }
        return entryTypeAndID;
    }
}

