/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.privilege.auth;

import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.User;
import com.fr.fs.cache.UserCache;
import com.fr.fs.control.LoginUserControl;
import com.fr.fs.control.UserControl;
import com.fr.privilege.Authentication;
import com.fr.privilege.Authority;
import com.fr.privilege.providers.AbstractAuthenticationProvider;
import com.fr.stable.privilege.AuthorityBridge;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.Iterator;
import java.util.Set;

public class UserNamePassWordFSAuthenticationProvider
extends AbstractAuthenticationProvider {
    private boolean needPassword = true;
    private boolean isMobile = false;
    private static final UserNamePassWordFSAuthenticationProvider SC = new UserNamePassWordFSAuthenticationProvider();

    private UserNamePassWordFSAuthenticationProvider() {
    }

    public static UserNamePassWordFSAuthenticationProvider getInstance() {
        return SC;
    }

    public UserNamePassWordFSAuthenticationProvider(boolean bl) {
        this.needPassword = bl;
    }

    public UserNamePassWordFSAuthenticationProvider(boolean bl, boolean bl2) {
        this.needPassword = bl;
        this.isMobile = bl2;
    }

    public boolean authenticate(Authentication authentication) throws Exception {
        String string = authentication.getPrincipal() != null ? authentication.getPrincipal().toString() : null;
        String string2 = authentication.getCredentials() != null ? authentication.getCredentials().toString() : null;
        User user = this.needPassword ? UserControl.getInstance().getUser(string, string2) : UserControl.getInstance().getByUserName(string);
        if (user == null) {
            return false;
        }
        if (user.getId() == UserControl.getInstance().getSuperManagerID()) {
            authentication.setRoot(true);
        } else if (!this.isAllowedLogin(user)) {
            return false;
        }
        authentication.setAuthenticated(true);
        Authority[] authorityArray = this.addAuthorities(user);
        authentication.setAuthorities((AuthorityBridge[])authorityArray);
        return true;
    }

    private boolean isAllowedLogin(User user) {
        return !(this.isMobileAuth() ? FSConfig.getInstance().getMobileUserAuthLimit() > 0 && !LoginUserControl.hasMobileLoginUser(user.getUsername()) : FSConfig.getInstance().getUserLimit() > 0 && !LoginUserControl.hasFSLoginUser(user.getUsername()));
    }

    private Authority[] addAuthorities(User user) throws Exception {
        Object object;
        long l = user.getId();
        Set<CustomRole> set = UserCache.getSRoles(l);
        Set<String> set2 = UserCache.getAllCompanyRoleNames(l);
        Authority[] authorityArray = new Authority[set.size() + set2.size()];
        int n = 0;
        Iterator<CustomRole> iterator = set.iterator();
        while (iterator.hasNext()) {
            object = iterator.next().getRolename();
            authorityArray[n] = new Authority((String)object);
            ++n;
        }
        object = set2.iterator();
        while (object.hasNext()) {
            String string = object.next().toString();
            authorityArray[n] = new Authority(string);
            ++n;
        }
        return authorityArray;
    }

    public int uType() {
        return 3;
    }

    public void readXML(XMLableReader xMLableReader) {
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
    }

    public boolean isNeedPassword() {
        return this.needPassword;
    }

    public void setNeedPassword(boolean bl) {
        this.needPassword = bl;
    }

    public boolean isMobileAuth() {
        return this.isMobile;
    }

    public void setIsMobileAuth(boolean bl) {
        this.isMobile = bl;
    }
}

