/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.plugin;

import com.fr.file.XMLFileManager;
import com.fr.fs.fun.LoginUIProcessor;
import com.fr.fs.fun.PlateProvider;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.GeneralUtils;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.StringUtils;
import com.fr.stable.plugin.ExtraPlatformClassManagerProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.HashSet;
import java.util.Set;

public class ExtraPlatformClassManager
extends XMLFileManager
implements ExtraPlatformClassManagerProvider {
    private static ExtraPlatformClassManager classManager;
    private Set<PlateProvider> plateProviders = null;
    private LoginUIProcessor loginUIProcessor = null;

    public static synchronized ExtraPlatformClassManager getInstance() {
        if (classManager == null) {
            classManager = new ExtraPlatformClassManager();
            classManager.readXMLFile();
        }
        return classManager;
    }

    private static synchronized void envChanged() {
        classManager = null;
    }

    public String fileName() {
        return "platform.xml";
    }

    public PlateProvider[] getPlateProviders() {
        if (this.plateProviders == null) {
            return new PlateProvider[0];
        }
        return this.plateProviders.toArray(new PlateProvider[this.plateProviders.size()]);
    }

    public void addPlateProvider(String string) {
        if (StringUtils.isNotEmpty((String)string)) {
            if (this.plateProviders == null) {
                this.plateProviders = new HashSet<PlateProvider>();
            }
            try {
                Class clazz = GeneralUtils.classForName((String)string);
                PlateProvider plateProvider = (PlateProvider)clazz.newInstance();
                this.plateProviders.add(plateProvider);
            }
            catch (Exception exception) {
                FRLogger.getLogger().info("error to load:" + string);
            }
        }
    }

    public LoginUIProcessor getLoginUIProcessor() {
        return this.loginUIProcessor;
    }

    public void setLoginUIProcessor(String string) {
        if (StringUtils.isNotEmpty((String)string)) {
            try {
                Class clazz = GeneralUtils.classForName((String)string);
                this.loginUIProcessor = (LoginUIProcessor)clazz.newInstance();
            }
            catch (Exception exception) {
                FRLogger.getLogger().info("error to load:" + string);
            }
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("PlateProvider")) {
                this.addPlateProvider(xMLableReader.getAttrAsString("class", ""));
            } else if (string.equals("LoginUIProcessor")) {
                this.setLoginUIProcessor(xMLableReader.getAttrAsString("class", ""));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
    }

    static {
        GeneralContext.addEnvChangedListener((EnvChangedListener)new EnvChangedListener(){

            public void envChanged() {
                ExtraPlatformClassManager.envChanged();
            }
        });
    }
}

