/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.device;

import com.fr.fs.device.DeviceInfo;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.List;

public class UserDevice
implements XMLable {
    public static final String XML_TAG = "UserDevice";
    private String username;
    private List<DeviceInfo> deviceInfoList = new ArrayList<DeviceInfo>();

    public UserDevice() {
    }

    public UserDevice(String string, DeviceInfo deviceInfo) {
        this.username = string;
        this.deviceInfoList.add(deviceInfo);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public boolean isEmpty() {
        return this.deviceInfoList.isEmpty();
    }

    public void addDeviceInfo(DeviceInfo deviceInfo) {
        this.deviceInfoList.add(deviceInfo);
    }

    public boolean matchMacAddress(String string) {
        for (DeviceInfo deviceInfo : this.deviceInfoList) {
            if (!ComparatorUtils.equals((Object)deviceInfo.getMacAddress(), (Object)string) || !deviceInfo.isPassed()) continue;
            return true;
        }
        return false;
    }

    public DeviceInfo findDeviceInfoByMacAddress(String string) {
        for (DeviceInfo deviceInfo : this.deviceInfoList) {
            if (!ComparatorUtils.equals((Object)deviceInfo.getMacAddress(), (Object)string)) continue;
            return deviceInfo;
        }
        return null;
    }

    public void unbind(String string, String string2) {
        if (StringUtils.isBlank((String)string)) {
            for (DeviceInfo deviceInfo : this.deviceInfoList) {
                if (!deviceInfo.isPassed() && "false".equals(string2)) {
                    this.deviceInfoList.remove(deviceInfo);
                }
                if (!deviceInfo.isPassed() || !"true".equals(string2)) continue;
                this.deviceInfoList.remove(deviceInfo);
            }
        } else {
            for (DeviceInfo deviceInfo : this.deviceInfoList) {
                if (!ComparatorUtils.equals((Object)deviceInfo.getMacAddress(), (Object)string)) continue;
                this.deviceInfoList.remove(deviceInfo);
                break;
            }
        }
    }

    public void bind(String string, String string2) {
        if (StringUtils.isBlank((String)string) || StringUtils.isBlank((String)string2)) {
            for (DeviceInfo deviceInfo : this.deviceInfoList) {
                deviceInfo.setPassed(true);
            }
        } else {
            DeviceInfo deviceInfo = this.findDeviceInfoByMacAddress(string);
            if (deviceInfo != null) {
                deviceInfo.setPassed(true);
            } else {
                this.addDeviceInfo(new DeviceInfo(string, string2, true));
            }
        }
    }

    public JSONArray toJSONArray() throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (DeviceInfo deviceInfo : this.deviceInfoList) {
            jSONArray.put((Object)deviceInfo.toJSONObject());
        }
        return jSONArray;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isAttr()) {
            this.deviceInfoList.clear();
        }
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals(XML_TAG)) {
            this.username = xMLableReader.getAttrAsString("username", null);
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    String string;
                    if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("DeviceInfo")) {
                        DeviceInfo deviceInfo = new DeviceInfo();
                        deviceInfo.readXML(xMLableReader);
                        UserDevice.this.deviceInfoList.add(deviceInfo);
                    }
                }
            });
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.attr("username", this.username);
        for (DeviceInfo deviceInfo : this.deviceInfoList) {
            deviceInfo.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        return object instanceof UserDevice && ComparatorUtils.equals((Object)((UserDevice)object).username, (Object)this.username);
    }

    public int hashCode() {
        return this.username.hashCode();
    }
}

