/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.dao;

import com.fr.data.dao.DAOException;
import com.fr.data.dao.DataAccessObjectSession;
import com.fr.fs.dao.EntryDAO;
import com.fr.fs.schedule.entry.ReportletEntry;
import com.fr.general.FRLogger;
import java.util.List;

public class ReportletEntryDAO
extends EntryDAO {
    private static final String FIELD_REPORTLETPATH = "webletPath";
    private static final ReportletEntryDAO SC = new ReportletEntryDAO();

    public static ReportletEntryDAO getInstance() {
        return SC;
    }

    private ReportletEntryDAO() {
    }

    public void save(ReportletEntry reportletEntry) throws Exception {
        this.createSession().save((Object)reportletEntry);
    }

    public List getReports() throws Exception {
        DataAccessObjectSession dataAccessObjectSession = this.createSession();
        try {
            dataAccessObjectSession.beginTransaction();
            List list = this.createSession().list(ReportletEntry.class);
            return list;
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
            throw exception;
        }
        finally {
            this.closeSession(dataAccessObjectSession);
        }
    }

    public boolean saveOrUpdate(ReportletEntry reportletEntry) throws Exception {
        return this.createSession().saveOrUpdate((Object)reportletEntry);
    }

    public boolean delete(ReportletEntry reportletEntry) throws Exception {
        long l = reportletEntry.getId();
        if (l < 0L) {
            throw new DAOException("The object is not a persistent Object. Can not find a right id.");
        }
        return this.deleteByID(l);
    }

    public ReportletEntry findByID(long l) throws Exception {
        return (ReportletEntry)this.createSession().load(ReportletEntry.class, l);
    }

    public List findByPath(String string) throws Exception {
        return this.createSession().listByFieldValue(ReportletEntry.class, FIELD_REPORTLETPATH, (Object)string);
    }

    public List findByReportletPath(String string) throws Exception {
        return this.createSession().listByFieldValue(ReportletEntry.class, FIELD_REPORTLETPATH, (Object)string);
    }

    protected Class getEntryClass() {
        return ReportletEntry.class;
    }

    protected int getEntryType() {
        return 2;
    }
}

