/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control.dao.tabledata;

import com.fr.base.FRContext;
import com.fr.data.dao.RelationObject;
import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.RoleDataConnectionPrivilege;
import com.fr.fs.base.entity.RoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.RoleESPrivilege;
import com.fr.fs.base.entity.RoleEntryPrivilege;
import com.fr.fs.base.entity.RoleHomePagePrivilege;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.base.entity.RoleTemplatePrivilege;
import com.fr.fs.base.entity.User;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.cache.tabledata.TableDataSyncDB;
import com.fr.fs.control.dao.CustomRoleDAO;
import com.fr.stable.file.XMLFileManagerProvider;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableDataCustomRoleDAO
implements CustomRoleDAO {
    private static TableDataCustomRoleDAO tsd;

    public static TableDataCustomRoleDAO getInstance() {
        if (tsd == null) {
            tsd = new TableDataCustomRoleDAO();
        }
        return tsd;
    }

    @Override
    public void save(CustomRole customRole) throws Exception {
        TableDataSyncDB.getInstance().addSRole(customRole);
        FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)FSConfig.getInstance());
    }

    @Override
    public boolean delete(CustomRole customRole) throws Exception {
        if (customRole == null) {
            return false;
        }
        TableDataSyncDB.getInstance().removeSRole(customRole);
        FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)FSConfig.getInstance());
        return true;
    }

    @Override
    public boolean deleteByID(long l) throws Exception {
        return this.delete(this.findByID(l));
    }

    @Override
    public CustomRole findByID(long l) throws Exception {
        return TableDataSyncDB.getInstance().findSRoleBySRoleID(l);
    }

    @Override
    public boolean updateRoleName(long l, String string) throws Exception {
        if (TableDataSyncDB.getInstance().updateSRoleName(l, string)) {
            FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)FSConfig.getInstance());
            return true;
        }
        return false;
    }

    @Override
    public List findAll() throws Exception {
        return TableDataSyncDB.getInstance().findAllSRole();
    }

    @Override
    public CustomRole findByRoleName(String string) throws Exception {
        return TableDataSyncDB.getInstance().findSRoleBySRoleName(string);
    }

    @Override
    public Set getUserSet(long l, boolean bl) throws Exception {
        return TableDataSyncDB.getInstance().findUserSetBySRoleId(l, bl);
    }

    @Override
    public void addUsers(long l, Set<User> set) throws Exception {
        CustomRole customRole = this.findByID(l);
        if (customRole == null) {
            throw new RuntimeException("The role don't exist!");
        }
        TableDataSyncDB.getInstance().addUsersToSRole(customRole, set);
        FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)FSConfig.getInstance());
    }

    @Override
    public void removeUsers(long l, Set<User> set) throws Exception {
        CustomRole customRole = this.findByID(l);
        if (customRole == null) {
            throw new RuntimeException("The role don't exist!");
        }
        TableDataSyncDB.getInstance().removeUsersFromSRole(set);
        FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)FSConfig.getInstance());
    }

    @Override
    public Set<RoleEntryPrivilege> getEntryPrivileges(long l) throws Exception {
        return TableDataSyncDB.getInstance().findEntryPrivilegesBySRoleId(l);
    }

    public Set<RoleEntryPrivilege> getEntryPrivileges(String string) throws Exception {
        return TableDataSyncDB.getInstance().findEntryPrivilegesBySRoleName(string);
    }

    @Override
    public Set<RoleESPrivilege> getESPrivileges(long l) throws Exception {
        return TableDataSyncDB.getInstance().findESPrivilegesBySRoleId(l);
    }

    @Override
    public Set<RoleModulePrivilege> getModulePrivileges(long l) throws Exception {
        return TableDataSyncDB.getInstance().findModulePrivilegesBySRoleId(l);
    }

    public Set<RoleModulePrivilege> getModulePrivileges(String string) throws Exception {
        return TableDataSyncDB.getInstance().findModulePrivilegeBySRoleName(string);
    }

    @Override
    public Set<RoleHomePagePrivilege> getHomePagePrivileges(long l) throws Exception {
        return TableDataSyncDB.getInstance().findHomePagePrivilegesBySRoleId(l);
    }

    public Set<RoleHomePagePrivilege> getHomePagePrivileges(String string) throws Exception {
        return TableDataSyncDB.getInstance().findHomePagePrivilegeBySRoleName(string);
    }

    @Override
    public Set<RelationObject> getPrivilegesWithPlateName(long l, String string) throws Exception {
        return TableDataSyncDB.getInstance().findPrivilegesByCustomRoleIDWithPlateName(l, string);
    }

    public void updateEntryPrivileges(long l, List list, List list2) throws Exception {
        if (TableDataSyncDB.getInstance().updateSRoleEntryPrivileges(l, (List<EntryTypeAndID>)list, (List<EntryTypeAndID>)list2)) {
            FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)FSConfig.getInstance());
        }
    }

    public void updateEntryPrivileges(String string, List list, List list2) throws Exception {
        if (TableDataSyncDB.getInstance().updateSRoleEntryPrivileges(string, (List<EntryTypeAndID>)list, (List<EntryTypeAndID>)list2)) {
            FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)FSConfig.getInstance());
        }
    }

    public void updateESPrivileges(long l, List list, List list2) throws Exception {
        if (TableDataSyncDB.getInstance().updateSRoleESPrivileges(l, list, list2)) {
            FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)FSConfig.getInstance());
        }
    }

    @Override
    public void updateModulePrivileges(long l, List<RoleModulePrivilege> list, List<RoleModulePrivilege> list2) throws Exception {
        if (TableDataSyncDB.getInstance().updateSRoleModulePrivileges(l, list, list2)) {
            FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)FSConfig.getInstance());
        }
    }

    public void updateModulePrivileges(String string, List list, List list2) throws Exception {
        if (TableDataSyncDB.getInstance().updateSRoleModulePrivileges(string, (List<RoleModulePrivilege>)list, (List<RoleModulePrivilege>)list2)) {
            FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)FSConfig.getInstance());
        }
    }

    @Override
    public void updateHomePagePrivileges(long l, List<RoleHomePagePrivilege> list, List<RoleHomePagePrivilege> list2) throws Exception {
        if (TableDataSyncDB.getInstance().updateSRoleHomePagePrivileges(l, list, list2)) {
            FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)FSConfig.getInstance());
        }
    }

    public void updateHomePagePrivileges(String string, List list, List list2) throws Exception {
        if (TableDataSyncDB.getInstance().updateSRoleHomePagePrivileges(string, (List<RoleHomePagePrivilege>)list, (List<RoleHomePagePrivilege>)list2)) {
            FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)FSConfig.getInstance());
        }
    }

    @Override
    public void updateTemplatePrivileges(long l, List<RoleTemplatePrivilege> list, List<RoleTemplatePrivilege> list2) throws Exception {
        if (TableDataSyncDB.getInstance().updateSRoleTemplatePrivileges(l, list, list2)) {
            FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)FSConfig.getInstance());
        }
    }

    @Override
    public void updateDataConnectionPrivileges(long l, List<String> list, List<String> list2) throws Exception {
        if (TableDataSyncDB.getInstance().updateSRoleDataConnectionPrivileges(l, list, list2)) {
            FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)FSConfig.getInstance());
        }
    }

    public void updateDataConnectionPrivileges(String string, List<String> list, List<String> list2) throws Exception {
        if (TableDataSyncDB.getInstance().updateSRoleDataConnectionPrivileges(string, list, list2)) {
            FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)FSConfig.getInstance());
        }
    }

    public void updateTemplatePrivileges(String string, List<RoleTemplatePrivilege> list, List<RoleTemplatePrivilege> list2) throws Exception {
        if (TableDataSyncDB.getInstance().updateSRoleTemplatePrivileges(string, list, list2)) {
            FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)FSConfig.getInstance());
        }
    }

    @Override
    public void updatePlatePrivileges(long l, List<RoleEntryPrivilege> list, List<RoleEntryPrivilege> list2, String string) throws Exception {
        if (TableDataSyncDB.getInstance().updateCustomRolePlatePrivileges(l, list, list2, string)) {
            FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)FSConfig.getInstance());
        }
    }

    @Override
    public Set<RoleDepAndCRolePrivilege> getDepAndCrolePrivileges(long l) throws Exception {
        return TableDataSyncDB.getInstance().findDepAndCRolePrivilegeByCustomRoleId(l);
    }

    public Set<RoleDepAndCRolePrivilege> getDepAndCrolePrivileges(String string) {
        return TableDataSyncDB.getInstance().findDepAndCRolePrivilegeByCustomRoleName(string);
    }

    @Override
    public Set<RoleTemplatePrivilege> getTemplatePrivileges(long l) throws Exception {
        return TableDataSyncDB.getInstance().findTemplatePrivilegeByCustomRoleId(l);
    }

    public Set<RoleTemplatePrivilege> getTemplatePrivileges(String string) throws Exception {
        return TableDataSyncDB.getInstance().findTemplatePrivilegeByCustomRoleName(string);
    }

    @Override
    public Set<RoleDataConnectionPrivilege> getDataConnectionPrivileges(long l) throws Exception {
        return TableDataSyncDB.getInstance().findDataConnectionPrivilegesByCustomRoleId(l);
    }

    public Set<RoleDataConnectionPrivilege> getDataConnectionPrivileges(String string) {
        return TableDataSyncDB.getInstance().findDataConnectionPrivilegesByCustomRoleName(string);
    }

    @Override
    public void updateDepAndCrolePrivilege(long l, List<String> list, List<String> list2) throws Exception {
        if (TableDataSyncDB.getInstance().updateCustomRoleDepAndCRolePrivileges(l, list, list2)) {
            FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)FSConfig.getInstance());
        }
    }

    public void updateDepAndCrolePrivilege(String string, List<String> list, List<String> list2) throws Exception {
        if (TableDataSyncDB.getInstance().updateCustomRoleDepAndCRolePrivileges(string, list, list2)) {
            FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)FSConfig.getInstance());
        }
    }
}

