/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control.dao.hsqldb;

import com.fr.data.dao.DAOHashSet;
import com.fr.data.dao.DataAccessObjectSession;
import com.fr.data.dao.RelationFCMapper;
import com.fr.data.dao.RelationObject;
import com.fr.data.dao.SortInfo;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.EntityDAOConstants;
import com.fr.fs.base.entity.Post;
import com.fr.fs.base.entity.User;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.dao.UserDAO;
import com.fr.fs.control.dao.hsqldb.HSQLDBDAOControl;
import com.fr.fs.dao.PlatformDataAccessObject;
import com.fr.privilege.providers.dao.PasswordValidator;
import com.fr.stable.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HSQLUserDAO
extends PlatformDataAccessObject
implements UserDAO {
    private static final String FIELD_USERNAME = "username";
    private static final String FIELD_PASSWORD = "password";
    private static final String FIELD_REALNAME = "realname";
    private static final String FIELD_MALE = "male";
    private static final String FIELD_BIRTHDAY = "birthday";
    private static final String FIELD_MOBILE = "mobile";
    private static final String FIELD_EMAIL = "email";
    private static final HSQLUserDAO SC = new HSQLUserDAO();

    public static HSQLUserDAO getInstance() {
        return SC;
    }

    private HSQLUserDAO() {
    }

    public void save(User user) throws Exception {
        this.createSession().save((Object)user);
    }

    public boolean delete(User user) throws Exception {
        if (user == null) {
            return false;
        }
        return this.deleteByID(user.getId());
    }

    public boolean deleteByID(long l) throws Exception {
        if (l < 0L) {
            return false;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            dataAccessObjectSession = this.createSession();
            dataAccessObjectSession.beginTransaction();
            boolean bl = dataAccessObjectSession.deleteByPrimaryKey(User.class, l);
            dataAccessObjectSession.commit();
            boolean bl2 = bl;
            return bl2;
        }
        catch (Exception exception) {
            this.rollbackSession(dataAccessObjectSession);
            throw exception;
        }
        finally {
            this.closeSession(dataAccessObjectSession);
        }
    }

    public User findByID(long l) throws Exception {
        return (User)((Object)this.createSession().load(User.class, l));
    }

    public List findAll() throws Exception {
        return this.createSession().list(User.class);
    }

    public List findAllSortByUserName() throws Exception {
        SortInfo sortInfo = new SortInfo();
        sortInfo.addSortInfo(FIELD_USERNAME, true);
        return this.createSession().list(User.class, sortInfo);
    }

    public boolean update(long l, String string, String string2, String string3) throws Exception {
        if (l < 0L) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(FIELD_USERNAME, string);
        if (StringUtils.isNotBlank((String)string2)) {
            hashMap.put(FIELD_PASSWORD, string2);
        }
        hashMap.put(FIELD_REALNAME, string3);
        return this.createSession().update(User.class, l, hashMap);
    }

    public boolean update(long l, boolean bl, Date date, String string, String string2) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(FIELD_MALE, bl ? Boolean.TRUE : Boolean.FALSE);
        hashMap.put(FIELD_BIRTHDAY, date);
        hashMap.put(FIELD_MOBILE, string);
        hashMap.put(FIELD_EMAIL, string2);
        return this.createSession().update(User.class, l, hashMap);
    }

    public boolean update(long l, String string, String string2, String string3, String string4, String string5) throws Exception {
        if (l < 0L) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(FIELD_USERNAME, string);
        if (StringUtils.isNotBlank((String)string2)) {
            hashMap.put(FIELD_PASSWORD, string2);
        }
        hashMap.put(FIELD_REALNAME, string3);
        hashMap.put(FIELD_MOBILE, string4);
        hashMap.put(FIELD_EMAIL, string5);
        return this.createSession().update(User.class, l, hashMap);
    }

    public boolean updatePassword(long l, String string) throws Exception {
        if (l < 0L) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(FIELD_PASSWORD, string);
        return this.createSession().update(User.class, l, hashMap);
    }

    public User findByUserName(String string) throws Exception {
        List list = this.createSession().listByFieldValue(User.class, FIELD_USERNAME, (Object)string);
        if (!list.isEmpty()) {
            return (User)((Object)list.get(0));
        }
        return null;
    }

    public User findByUserNameAndPassWord(String string, String string2) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(FIELD_USERNAME, string);
        List list = this.createSession().listByFieldValues(User.class, hashMap);
        if (!list.isEmpty()) {
            User user = (User)((Object)list.get(0));
            PasswordValidator passwordValidator = HSQLDBDAOControl.getInstance().getPv();
            String string3 = string;
            if (passwordValidator.shouldIgnoreUsername()) {
                string3 = "";
            }
            if (passwordValidator.validatePassword(user.getPassword(), string2, string3)) {
                return user;
            }
        }
        return null;
    }

    public Set getSRoleSet(long l) throws Exception {
        return this.getSet(l, EntityDAOConstants.USER.RELATION_ROLE);
    }

    public Set getJobSet(long l) throws Exception {
        return this.getSet(l, EntityDAOConstants.USER.RELATION_JOB);
    }

    public Set getUserSet(long l, long l2) throws Exception {
        if (l < 0L || l2 < 0L) {
            return null;
        }
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        if (l != CompanyRoleControl.getInstance().getDepartmentAllID()) {
            hashMap.put("Department", new Long(l));
        }
        if (l2 != CompanyRoleControl.getInstance().getPostAllID()) {
            hashMap.put("Post", new Long(l2));
        }
        List list = this.createSession().getRelationByMap(User.class, EntityDAOConstants.USER.RELATION_JOB, hashMap);
        HashSet<Object> hashSet = new HashSet<Object>();
        for (RelationObject relationObject : list) {
            hashSet.add(relationObject.getValue(User.class));
        }
        return hashSet;
    }

    private Set getSet(long l, RelationFCMapper relationFCMapper) throws Exception {
        if (l < 0L) {
            return null;
        }
        DAOHashSet dAOHashSet = new DAOHashSet(this.createSession(), relationFCMapper, User.class, (Object)new Long(l));
        return dAOHashSet.toSet();
    }

    public boolean addJob(long l, RelationObject relationObject) throws Exception {
        return this.addOrRemove(l, EntityDAOConstants.USER.RELATION_JOB, relationObject, true);
    }

    public boolean removeJob(long l, RelationObject relationObject) throws Exception {
        return this.addOrRemove(l, EntityDAOConstants.USER.RELATION_JOB, relationObject, false);
    }

    public long removeJob(long l) throws Exception {
        if (l < 0L) {
            return -1L;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            dataAccessObjectSession = this.createSession();
            dataAccessObjectSession.beginTransaction();
            RelationObject relationObject = dataAccessObjectSession.getRelation(User.class, EntityDAOConstants.USER.RELATION_JOB, l);
            boolean bl = false;
            if (relationObject != null) {
                bl = dataAccessObjectSession.removeRelation(User.class, EntityDAOConstants.USER.RELATION_JOB, l);
            }
            dataAccessObjectSession.commit();
            if (bl) {
                long l2 = (Long)relationObject.getValue(User.class);
                return l2;
            }
            long l3 = -1L;
            return l3;
        }
        catch (Exception exception) {
            this.rollbackSession(dataAccessObjectSession);
            throw exception;
        }
        finally {
            this.closeSession(dataAccessObjectSession);
        }
    }

    public RelationObject updateJob(long l, long l2, long l3) throws Exception {
        if (l < 0L) {
            return null;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            RelationObject relationObject;
            dataAccessObjectSession = this.createSession();
            dataAccessObjectSession.beginTransaction();
            RelationObject relationObject2 = dataAccessObjectSession.getRelation(User.class, EntityDAOConstants.USER.RELATION_JOB, l);
            boolean bl = false;
            if (relationObject2 != null) {
                relationObject = new HashMap();
                relationObject.put(User.class, new Long(l2));
                relationObject.put(Post.class, new Long(l3));
                bl = dataAccessObjectSession.updateRelation(User.class, EntityDAOConstants.USER.RELATION_JOB, l, (Map)relationObject);
            }
            dataAccessObjectSession.commit();
            if (bl) {
                relationObject = relationObject2;
                return relationObject;
            }
            relationObject = null;
            return relationObject;
        }
        catch (Exception exception) {
            this.rollbackSession(dataAccessObjectSession);
            throw exception;
        }
        finally {
            this.closeSession(dataAccessObjectSession);
        }
    }

    public boolean addSRole(long l, CustomRole customRole) throws Exception {
        return this.addOrRemove(l, EntityDAOConstants.USER.RELATION_ROLE, (Object)customRole, true);
    }

    public boolean removeSRole(long l, CustomRole customRole) throws Exception {
        return this.addOrRemove(l, EntityDAOConstants.USER.RELATION_ROLE, (Object)customRole, false);
    }

    private boolean addOrRemove(long l, RelationFCMapper relationFCMapper, Object object, boolean bl) throws Exception {
        if (l < 0L) {
            return false;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            dataAccessObjectSession = this.createSession();
            dataAccessObjectSession.beginTransaction();
            User user = (User)((Object)dataAccessObjectSession.load(User.class, l));
            if (user == null) {
                throw new RuntimeException("The user don't exist!");
            }
            DAOHashSet dAOHashSet = new DAOHashSet(this.createSession(), relationFCMapper, User.class, (Object)new Long(l));
            boolean bl2 = bl ? dAOHashSet.add(object) : dAOHashSet.remove(object);
            dataAccessObjectSession.commit();
            boolean bl3 = bl2;
            return bl3;
        }
        catch (Exception exception) {
            this.rollbackSession(dataAccessObjectSession);
            throw exception;
        }
        finally {
            this.closeSession(dataAccessObjectSession);
        }
    }
}

