/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control.dao.hsqldb;

import com.fr.data.dao.DataAccessObjectSession;
import com.fr.fs.base.entity.FavoriteNode;
import com.fr.fs.control.dao.FavoriteNodeDAO;
import com.fr.fs.dao.PlatformDataAccessObject;
import java.util.HashMap;
import java.util.List;

public class HSQLFavoriteNodeDAO
extends PlatformDataAccessObject
implements FavoriteNodeDAO {
    private static final HSQLFavoriteNodeDAO SC = new HSQLFavoriteNodeDAO();

    public static HSQLFavoriteNodeDAO getInstance() {
        return SC;
    }

    private HSQLFavoriteNodeDAO() {
    }

    public void save(FavoriteNode favoriteNode) throws Exception {
        this.createSession().save((Object)favoriteNode);
    }

    public boolean delete(FavoriteNode favoriteNode) throws Exception {
        if (favoriteNode == null) {
            return false;
        }
        return this.deleteByID(favoriteNode.getId());
    }

    public boolean deleteByID(long l) throws Exception {
        if (l < 0L) {
            return false;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            dataAccessObjectSession = this.createSession();
            dataAccessObjectSession.beginTransaction();
            boolean bl = dataAccessObjectSession.deleteByPrimaryKey(FavoriteNode.class, l);
            dataAccessObjectSession.commit();
            boolean bl2 = bl;
            return bl2;
        }
        catch (Exception exception) {
            this.rollbackSession(dataAccessObjectSession);
            throw exception;
        }
        finally {
            this.closeSession(dataAccessObjectSession);
        }
    }

    public boolean deleteByUserAndEntry(long l, int n, long l2) throws Exception {
        if (l < 0L || n < 0 || l2 < 0L) {
            return false;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            dataAccessObjectSession = this.createSession();
            dataAccessObjectSession.beginTransaction();
            HashMap<String, Number> hashMap = new HashMap<String, Number>(4);
            hashMap.put("userId", new Long(l));
            hashMap.put("type", new Integer(n));
            hashMap.put("entryid", new Long(l2));
            boolean bl = dataAccessObjectSession.deleteByFields(FavoriteNode.class, hashMap);
            dataAccessObjectSession.commit();
            boolean bl2 = bl;
            return bl2;
        }
        catch (Exception exception) {
            this.rollbackSession(dataAccessObjectSession);
            throw exception;
        }
        finally {
            this.closeSession(dataAccessObjectSession);
        }
    }

    public List findByUserID(long l) throws Exception {
        if (l < 0L) {
            return null;
        }
        return this.createSession().listByFieldValue(FavoriteNode.class, "userId", (Object)new Long(l));
    }
}

