/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control.dao.hsqldb;

import com.fr.data.dao.DAOHashSet;
import com.fr.data.dao.DataAccessObjectSession;
import com.fr.data.dao.RelationFCMapper;
import com.fr.fs.base.entity.Department;
import com.fr.fs.base.entity.EntityDAOConstants;
import com.fr.fs.control.dao.DepartmentDAO;
import com.fr.fs.dao.PlatformDataAccessObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class HSQLDepartmentDAO
extends PlatformDataAccessObject
implements DepartmentDAO {
    private static HSQLDepartmentDAO SC;

    public static HSQLDepartmentDAO getInstance() {
        if (SC == null) {
            SC = new HSQLDepartmentDAO();
        }
        return SC;
    }

    private HSQLDepartmentDAO() {
    }

    public void save(Department department) throws Exception {
        this.createSession().save((Object)department);
    }

    public boolean delete(Department department) throws Exception {
        if (department == null) {
            return false;
        }
        return this.deleteByID(department.getId());
    }

    public boolean deleteByID(long l) throws Exception {
        if (l < 0L) {
            return false;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            dataAccessObjectSession = this.createSession();
            dataAccessObjectSession.beginTransaction();
            boolean bl = dataAccessObjectSession.deleteByPrimaryKey(Department.class, l);
            dataAccessObjectSession.commit();
            boolean bl2 = bl;
            return bl2;
        }
        catch (Exception exception) {
            this.rollbackSession(dataAccessObjectSession);
            throw exception;
        }
        finally {
            this.closeSession(dataAccessObjectSession);
        }
    }

    public Department findByID(long l) throws Exception {
        return (Department)((Object)this.createSession().load(Department.class, l));
    }

    public List findAll() throws Exception {
        return this.createSession().list(Department.class);
    }

    public boolean updateDepartmentName(long l, String string) throws Exception {
        if (l < 0L) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("name", string);
        return this.createSession().update(Department.class, l, hashMap);
    }

    public Department findByNameAndPid(String string, long l) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("name", string);
        hashMap.put("pid", l);
        List list = this.createSession().listByFieldValues(Department.class, hashMap);
        if (!list.isEmpty()) {
            return (Department)((Object)list.get(0));
        }
        return null;
    }

    public Iterator getUserAndPostIterator(long l, boolean bl) throws Exception {
        if (l < 0L) {
            return null;
        }
        DAOHashSet dAOHashSet = new DAOHashSet(this.createSession(), (RelationFCMapper)EntityDAOConstants.DEPARTMENT.USER_POST_RELATION_MAPPER, Department.class, (Object)new Long(l));
        return dAOHashSet.iterator(bl);
    }
}

