/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control.dao.hsqldb;

import com.fr.fs.FSConfig;
import com.fr.fs.cache.tabledata.TableDataSyncDB;
import com.fr.fs.control.UserDataControl;
import com.fr.fs.control.dao.CompanyRoleDAO;
import com.fr.fs.control.dao.CustomRoleDAO;
import com.fr.fs.control.dao.DepartmentDAO;
import com.fr.fs.control.dao.FavoriteNodeDAO;
import com.fr.fs.control.dao.PostDAO;
import com.fr.fs.control.dao.UserDAO;
import com.fr.fs.control.dao.hsqldb.HSQLCompanyRoleDAO;
import com.fr.fs.control.dao.hsqldb.HSQLCustomRoleDAO;
import com.fr.fs.control.dao.hsqldb.HSQLDepartmentDAO;
import com.fr.fs.control.dao.hsqldb.HSQLFavoriteNodeDAO;
import com.fr.fs.control.dao.hsqldb.HSQLPostDAO;
import com.fr.fs.control.dao.hsqldb.HSQLUserDAO;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONObject;
import com.fr.privilege.providers.dao.ClassPasswordValidator;
import com.fr.privilege.providers.dao.MessageDigestPasswordValidator;
import com.fr.privilege.providers.dao.PasswordValidator;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HSQLDBDAOControl
implements UserDataControl {
    private static final long serialVersionUID = 3789717489139819038L;
    private static HSQLDBDAOControl hc;
    private PasswordValidator pv;

    public static HSQLDBDAOControl getInstance() {
        if (hc == null) {
            hc = new HSQLDBDAOControl();
        }
        return hc;
    }

    @Override
    public PasswordValidator getPv() {
        if (this.pv == null) {
            this.pv = PasswordValidator.EMPTY_PASSWORD_VALIDATOR;
        }
        return this.pv;
    }

    public void setPv(PasswordValidator passwordValidator) {
        this.pv = passwordValidator;
    }

    @Override
    public int getControlType() {
        return 0;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        if (jSONObject.has("encrypt")) {
            int n = jSONObject.getInt("encrypt");
            if (n == 0) {
                this.setPv(PasswordValidator.EMPTY_PASSWORD_VALIDATOR);
            } else if (n == 1) {
                ClassPasswordValidator classPasswordValidator = new ClassPasswordValidator();
                classPasswordValidator.setClassName(jSONObject.getString("myencrypt"));
                this.setPv((PasswordValidator)classPasswordValidator);
            } else {
                this.setPv(MessageDigestPasswordValidator.MD5_PASSWORD_VALIDATOR);
            }
        } else {
            this.setPv(PasswordValidator.EMPTY_PASSWORD_VALIDATOR);
        }
    }

    public JSONObject createJSON() throws Exception {
        PasswordValidator passwordValidator = this.getPv();
        return passwordValidator.toJSONObject();
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("PasswordValidator")) {
            this.pv = (PasswordValidator)GeneralXMLTools.readXMLable((XMLableReader)xMLableReader);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.pv == null) {
            GeneralXMLTools.writeXMLable((XMLPrintWriter)xMLPrintWriter, (XMLable)this.pv, (String)"PasswordValidator");
        }
    }

    @Override
    public CompanyRoleDAO getCompanyRoleDAO() {
        return HSQLCompanyRoleDAO.getInstance();
    }

    @Override
    public CustomRoleDAO getCustomRoleDAO() {
        return HSQLCustomRoleDAO.getInstance();
    }

    @Override
    public UserDAO getUserDAO() {
        return HSQLUserDAO.getInstance();
    }

    @Override
    public boolean init() {
        TableDataSyncDB.release();
        FSConfig.getInstance().clearCache();
        return true;
    }

    @Override
    public FavoriteNodeDAO getFavoriteNodeDAO() {
        return HSQLFavoriteNodeDAO.getInstance();
    }

    @Override
    public DepartmentDAO getDepartmentDAO() {
        return HSQLDepartmentDAO.getInstance();
    }

    @Override
    public PostDAO getPostDAO() {
        return HSQLPostDAO.getInstance();
    }

    @Override
    public <T> T getOpenDAO(Class<? extends T> clazz) {
        return (T)StableFactory.getMarkedObject((String)HSQLDBDAOControl.class.getName(), clazz);
    }
}

