/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control.dao.hsqldb;

import com.fr.data.dao.DAOHashSet;
import com.fr.data.dao.DataAccessObjectSession;
import com.fr.data.dao.OToMRelationFCMapper;
import com.fr.data.dao.RelationFCMapper;
import com.fr.fs.PlateFactory;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.CustomRoleDataConnectionPrivilege;
import com.fr.fs.base.entity.CustomRoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.CustomRoleESPrivilege;
import com.fr.fs.base.entity.CustomRoleEntryPrivilege;
import com.fr.fs.base.entity.CustomRoleHomePagePrivilege;
import com.fr.fs.base.entity.CustomRoleModulePrivilege;
import com.fr.fs.base.entity.CustomRoleTemplatePrivilege;
import com.fr.fs.base.entity.EntityDAOConstants;
import com.fr.fs.cache.CustomRoleCache;
import com.fr.fs.control.dao.CustomRoleDAO;
import com.fr.fs.control.dao.hsqldb.HSQLRoleDAO;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class HSQLCustomRoleDAO
extends HSQLRoleDAO
implements CustomRoleDAO {
    public static final String FIELD_ROLENAME = "rolename";
    private static HSQLCustomRoleDAO SC;

    public static HSQLCustomRoleDAO getInstance() {
        if (SC == null) {
            SC = new HSQLCustomRoleDAO();
        }
        return SC;
    }

    private HSQLCustomRoleDAO() {
    }

    public void save(CustomRole customRole) throws Exception {
        this.createSession().save((Object)customRole);
    }

    public boolean delete(CustomRole customRole) throws Exception {
        if (customRole == null) {
            return false;
        }
        return this.deleteByID(customRole.getId());
    }

    public boolean deleteByID(long l) throws Exception {
        if (l < 0L) {
            return false;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            dataAccessObjectSession = this.createSession();
            dataAccessObjectSession.beginTransaction();
            boolean bl = dataAccessObjectSession.deleteByPrimaryKey(CustomRole.class, l);
            dataAccessObjectSession.commit();
            boolean bl2 = bl;
            return bl2;
        }
        catch (Exception exception) {
            this.rollbackSession(dataAccessObjectSession);
            throw exception;
        }
        finally {
            this.closeSession(dataAccessObjectSession);
        }
    }

    public CustomRole findByID(long l) throws Exception {
        return (CustomRole)((Object)this.createSession().load(CustomRole.class, l));
    }

    public boolean updateRoleName(long l, String string) throws Exception {
        if (l < 0L) {
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(FIELD_ROLENAME, string);
        return this.createSession().update(CustomRole.class, l, hashMap);
    }

    public List findAll() throws Exception {
        return this.createSession().list(CustomRole.class);
    }

    public CustomRole findByRoleName(String string) throws Exception {
        List list = this.createSession().listByFieldValue(CustomRole.class, FIELD_ROLENAME, (Object)string);
        if (!list.isEmpty()) {
            return (CustomRole)((Object)list.get(0));
        }
        return null;
    }

    public Set getUserSet(long l, boolean bl) throws Exception {
        if (l < 0L) {
            return null;
        }
        DAOHashSet dAOHashSet = new DAOHashSet(this.createSession(), EntityDAOConstants.CUSTOMROLECONSTANTS.RELATION_USER, CustomRole.class, (Object)new Long(l));
        return dAOHashSet.toSet(bl);
    }

    public void addUsers(long l, Set set) throws Exception {
        this.addOrRemoveUsers(l, set, true);
    }

    public void removeUsers(long l, Set set) throws Exception {
        this.addOrRemoveUsers(l, set, false);
    }

    private void addOrRemoveUsers(long l, Set set, boolean bl) throws Exception {
        if (l < 0L || set == null) {
            return;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            dataAccessObjectSession = this.createSession();
            dataAccessObjectSession.beginTransaction();
            CustomRole customRole = (CustomRole)((Object)dataAccessObjectSession.load(CustomRole.class, l));
            if (customRole == null) {
                throw new RuntimeException("The role don't exist!");
            }
            DAOHashSet dAOHashSet = new DAOHashSet(dataAccessObjectSession, EntityDAOConstants.CUSTOMROLECONSTANTS.RELATION_USER, CustomRole.class, (Object)new Long(l));
            if (bl) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    dAOHashSet.add(iterator.next());
                }
            } else {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    dAOHashSet.remove(iterator.next());
                }
            }
            dataAccessObjectSession.commit();
        }
        catch (Exception exception) {
            this.rollbackSession(dataAccessObjectSession);
            throw exception;
        }
        finally {
            this.closeSession(dataAccessObjectSession);
        }
    }

    protected RelationFCMapper getEntryRelation() {
        return EntityDAOConstants.CUSTOMROLECONSTANTS.RELATION_ENTRY;
    }

    protected RelationFCMapper getESRelation() {
        return new OToMRelationFCMapper("ESPrivileges", CustomRoleESPrivilege.class, "roleid");
    }

    protected RelationFCMapper getDepAndCroleRelation() {
        return new OToMRelationFCMapper("depandcrolePrivileges", CustomRoleDepAndCRolePrivilege.class, "roleid");
    }

    protected RelationFCMapper getModuleRelation() {
        return new OToMRelationFCMapper("modulePrivileges", CustomRoleModulePrivilege.class, "roleid");
    }

    protected RelationFCMapper getHomePageRelation() {
        return new OToMRelationFCMapper("homePagePrivileges", CustomRoleHomePagePrivilege.class, "roleid");
    }

    protected RelationFCMapper getTemplateRelation() {
        return new OToMRelationFCMapper("templatePrivileges", CustomRoleTemplatePrivilege.class, "roleId");
    }

    protected RelationFCMapper getDataConnectionRelation() {
        return new OToMRelationFCMapper("dataConnectionPrivileges", CustomRoleDataConnectionPrivilege.class, "roleId");
    }

    protected RelationFCMapper getRelationFCMapperWithPlateName(String string) {
        return PlateFactory.getRelationFCMapper4Custom(string);
    }

    protected Class getRoleClass() {
        return CustomRole.class;
    }

    protected Class getRoleEntryPrivilegeClass() {
        return CustomRoleEntryPrivilege.class;
    }

    protected Class getRoleESPrivilegeClass() {
        return CustomRoleESPrivilege.class;
    }

    protected Class getRoleDepAndCrolePrivilegeClass() {
        return CustomRoleDepAndCRolePrivilege.class;
    }

    protected Class getRoleModulePrivilegeClass() {
        return CustomRoleModulePrivilege.class;
    }

    protected Class getRoleHomePagePrivilegeClass() {
        return CustomRoleHomePagePrivilege.class;
    }

    protected Class getRoleTemplatePrivilegeClass() {
        return CustomRoleTemplatePrivilege.class;
    }

    protected Class getRoleDataConnectionPrivilegeClass() {
        return CustomRoleDataConnectionPrivilege.class;
    }

    protected void cache4Sort(long l, int n, long l2, long l3) {
        CustomRoleCache.refreshEntryPrivileges(l, n, l2, l3);
    }
}

