/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control.dao.hsqldb;

import com.fr.data.dao.DataAccessObjectSession;
import com.fr.data.dao.OToMRelationFCMapper;
import com.fr.data.dao.RelationFCMapper;
import com.fr.fs.PlateFactory;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CompanyRoleDataConnectionPrivilege;
import com.fr.fs.base.entity.CompanyRoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.CompanyRoleESPrivilege;
import com.fr.fs.base.entity.CompanyRoleEntryPrivilege;
import com.fr.fs.base.entity.CompanyRoleHomePagePrivilege;
import com.fr.fs.base.entity.CompanyRoleModulePrivilege;
import com.fr.fs.base.entity.CompanyRoleTemplatePrivilege;
import com.fr.fs.base.entity.Department;
import com.fr.fs.base.entity.Post;
import com.fr.fs.cache.CompanyRoleCache;
import com.fr.fs.control.dao.CompanyRoleDAO;
import com.fr.fs.control.dao.hsqldb.HSQLRoleDAO;
import java.util.HashMap;
import java.util.List;

public class HSQLCompanyRoleDAO
extends HSQLRoleDAO
implements CompanyRoleDAO {
    private static HSQLCompanyRoleDAO SC;

    public static HSQLCompanyRoleDAO getInstance() {
        if (SC == null) {
            SC = new HSQLCompanyRoleDAO();
        }
        return SC;
    }

    private HSQLCompanyRoleDAO() {
    }

    public void save(CompanyRole companyRole) throws Exception {
        this.createSession().save((Object)companyRole);
    }

    public boolean delete(CompanyRole companyRole) throws Exception {
        if (companyRole == null) {
            return false;
        }
        return this.deleteByID(companyRole.getId());
    }

    public boolean deleteByID(long l) throws Exception {
        if (l < 0L) {
            return false;
        }
        DataAccessObjectSession dataAccessObjectSession = null;
        try {
            dataAccessObjectSession = this.createSession();
            dataAccessObjectSession.beginTransaction();
            boolean bl = dataAccessObjectSession.deleteByPrimaryKey(CompanyRole.class, l);
            dataAccessObjectSession.commit();
            boolean bl2 = bl;
            return bl2;
        }
        catch (Exception exception) {
            this.rollbackSession(dataAccessObjectSession);
            throw exception;
        }
        finally {
            this.closeSession(dataAccessObjectSession);
        }
    }

    public boolean update(long l, Department department, Post post) throws Exception {
        if (l < 0L || department == null || post == null) {
            return false;
        }
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put("departmentId", department.getId());
        hashMap.put("postId", post.getId());
        return this.createSession().update(CompanyRole.class, l, hashMap);
    }

    public CompanyRole findByID(long l) throws Exception {
        return (CompanyRole)((Object)this.createSession().load(CompanyRole.class, l));
    }

    public List findAll() throws Exception {
        return this.createSession().list(CompanyRole.class);
    }

    public List findByPost(Post post) throws Exception {
        if (post == null) {
            return null;
        }
        return this.createSession().listByFieldValue(CompanyRole.class, "postId", (Object)post);
    }

    public List findByDepartment(Long l) throws Exception {
        if (l == null) {
            return null;
        }
        return this.createSession().listByFieldValue(CompanyRole.class, "departmentId", (Object)l);
    }

    public List findByPostAndDepartment(Long l, Long[] longArray) throws Exception {
        if (l == null || longArray == null) {
            return null;
        }
        Long[] longArray2 = new Long[]{l};
        HashMap<String, Long[]> hashMap = new HashMap<String, Long[]>();
        hashMap.put("postId", longArray2);
        hashMap.put("departmentId", longArray);
        return this.createSession().listByFieldValues4MVFilter(CompanyRole.class, hashMap);
    }

    protected RelationFCMapper getEntryRelation() {
        return new OToMRelationFCMapper("entryPrivileges", CompanyRoleEntryPrivilege.class, "roleid");
    }

    protected RelationFCMapper getESRelation() {
        return new OToMRelationFCMapper("ESPrivileges", CompanyRoleESPrivilege.class, "roleid");
    }

    protected RelationFCMapper getDepAndCroleRelation() {
        return new OToMRelationFCMapper("depandcrolePrivileges", CompanyRoleDepAndCRolePrivilege.class, "roleid");
    }

    protected RelationFCMapper getModuleRelation() {
        return new OToMRelationFCMapper("modulePrivileges", CompanyRoleModulePrivilege.class, "roleid");
    }

    protected RelationFCMapper getHomePageRelation() {
        return new OToMRelationFCMapper("homePagePrivileges", CompanyRoleHomePagePrivilege.class, "roleid");
    }

    protected RelationFCMapper getTemplateRelation() {
        return new OToMRelationFCMapper("templatePrivileges", CompanyRoleTemplatePrivilege.class, "roleId");
    }

    protected RelationFCMapper getDataConnectionRelation() {
        return new OToMRelationFCMapper("dataConnectionPrivileges", CompanyRoleDataConnectionPrivilege.class, "roleId");
    }

    protected RelationFCMapper getRelationFCMapperWithPlateName(String string) {
        return PlateFactory.getRelationFCMapper4Company(string);
    }

    protected Class getRoleClass() {
        return CompanyRole.class;
    }

    protected Class getRoleEntryPrivilegeClass() {
        return CompanyRoleEntryPrivilege.class;
    }

    protected Class getRoleESPrivilegeClass() {
        return CompanyRoleESPrivilege.class;
    }

    protected Class getRoleDepAndCrolePrivilegeClass() {
        return CompanyRoleDepAndCRolePrivilege.class;
    }

    protected Class getRoleModulePrivilegeClass() {
        return CompanyRoleModulePrivilege.class;
    }

    protected Class getRoleHomePagePrivilegeClass() {
        return CompanyRoleHomePagePrivilege.class;
    }

    protected Class getRoleTemplatePrivilegeClass() {
        return CompanyRoleTemplatePrivilege.class;
    }

    protected Class getRoleDataConnectionPrivilegeClass() {
        return CompanyRoleDataConnectionPrivilege.class;
    }

    protected void cache4Sort(long l, int n, long l2, long l3) {
        CompanyRoleCache.refreshEntryPrivileges(l, n, l2, l3);
    }
}

