/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control;

import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.PlatformManageModule;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.cache.ModuleCache;
import com.fr.fs.control.UserControl;
import com.fr.json.JSONArray;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleControl {
    private static ModuleControl mc;

    public static ModuleControl getInstance() {
        if (mc == null) {
            mc = new ModuleControl();
        }
        return mc;
    }

    public List<RoleModulePrivilege> getAllRoleModulePrivilege() {
        List<PlatformManageModule> list = ModuleCache.getAllModules();
        ArrayList<RoleModulePrivilege> arrayList = new ArrayList<RoleModulePrivilege>();
        if (list != null) {
            for (PlatformManageModule platformManageModule : list) {
                if (platformManageModule.getId() <= 1L) continue;
                RoleModulePrivilege roleModulePrivilege = new RoleModulePrivilege(platformManageModule.getId(), 1L, 1L);
                arrayList.add(roleModulePrivilege);
            }
        }
        return arrayList;
    }

    public JSONArray getModuleRootShowInfo(long l) throws Exception {
        return ModuleCache.getModuleRootShowInfo(l);
    }

    public JSONArray getAuthorizedModuleItems(long l) throws Exception {
        Set set = UserControl.getInstance().getAllModulePrivileges(l);
        HashSet<RoleModulePrivilege> hashSet = new HashSet<RoleModulePrivilege>();
        for (RoleModulePrivilege roleModulePrivilege : set) {
            if (!this.hasNoAuthority(roleModulePrivilege)) continue;
            hashSet.add(roleModulePrivilege);
        }
        set.removeAll(hashSet);
        return ModuleCache.getAuthorizedModuleItemsFromPrivilegeSet(set);
    }

    private boolean hasNoAuthority(RoleModulePrivilege roleModulePrivilege) {
        return FSConfig.getInstance().getAuthorizeAttr().isGradeAuthority() && (roleModulePrivilege.getAuthorized() == 0L || roleModulePrivilege.getModuleid() <= 1L);
    }
}

