/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.control;

import com.fr.base.FRContext;
import com.fr.data.dao.RelationObject;
import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.Department;
import com.fr.fs.base.entity.Post;
import com.fr.fs.base.entity.RoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.User;
import com.fr.fs.cache.CompanyRoleCache;
import com.fr.fs.cache.DepartmentCache;
import com.fr.fs.cache.DepartmentTreeNode;
import com.fr.fs.cache.UserCache;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.CustomRoleControl;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DepartmentControl {
    private static DepartmentControl dc;

    public static DepartmentControl getInstance() {
        if (dc == null) {
            dc = new DepartmentControl();
        }
        return dc;
    }

    public Department getDepartment(long l) {
        return DepartmentCache.getDepartment(l);
    }

    public Department getDepartmentByNameAndPid(String string, long l) throws Exception {
        return DepartmentCache.getDepartmentByNameAndPid(string, l);
    }

    public Long[] getDpidsByPid(long l) throws Exception {
        return DepartmentCache.getDpidsByPid(l);
    }

    public Set<User> getUsers(long l) throws Exception {
        HashSet<User> hashSet = new HashSet<User>();
        List list = this.getUserAndPosts(l);
        for (Object[] objectArray : list) {
            User user = (User)((Object)objectArray[1]);
            hashSet.add(user);
        }
        return hashSet;
    }

    public List getUserAndPosts(long l) throws Exception {
        if (l < 0L) {
            return null;
        }
        Iterator iterator = FSConfig.getInstance().getControl().getDepartmentDAO().getUserAndPostIterator(l, true);
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        while (iterator.hasNext()) {
            RelationObject relationObject = (RelationObject)iterator.next();
            arrayList.add(new Object[]{relationObject.getId(), relationObject.getValue(User.class), relationObject.getValue(Post.class)});
        }
        return arrayList;
    }

    public JSONArray getUserAndPostsInfo(long l) throws Exception {
        JSONArray jSONArray = new JSONArray();
        List list = this.getUserAndPosts(l);
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Object[] objectArray = (Object[])list.get(i);
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("id", ((Long)objectArray[0]).longValue());
                User user = (User)((Object)objectArray[1]);
                jSONObject.put("userid", user.getId());
                jSONObject.put("username", (Object)user.getUsername());
                Post post = (Post)((Object)objectArray[2]);
                jSONObject.put("postid", post.getId());
                jSONObject.put("postname", (Object)post.getPostname());
                jSONArray.put((Object)jSONObject);
            }
        }
        return jSONArray;
    }

    public JSONArray getUserInfoByDepartAndPost(long l, long l2) throws Exception {
        JSONArray jSONArray = new JSONArray();
        List list = this.getUserAndPosts(l);
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Object[] objectArray = (Object[])list.get(i);
                Post post = (Post)((Object)objectArray[2]);
                if (post.getId() != l2) continue;
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("id", ((Long)objectArray[0]).longValue());
                User user = (User)((Object)objectArray[1]);
                jSONObject.put("userid", user.getId());
                jSONObject.put("username", (Object)user.getUsername());
                jSONObject.put("realname", (Object)user.getRealname());
                jSONArray.put((Object)jSONObject);
            }
        }
        return jSONArray;
    }

    public boolean updateDepartmentName(long l, String string) throws Exception {
        if (l < 0L || StringUtils.isBlank((String)string)) {
            return false;
        }
        Department department = this.getDepartment(l);
        Department department2 = this.getDepartmentByNameAndPid(string, department.getPid());
        if (department2 != null && department2.getId() != department.getId()) {
            return false;
        }
        if (FSConfig.getInstance().getControl().getDepartmentDAO().updateDepartmentName(l, string)) {
            try {
                DepartmentCache.cacheNewName(l, string);
            }
            catch (Exception exception) {
                DepartmentCache.reInit();
            }
            return true;
        }
        return false;
    }

    public boolean addDepartment(Department department) throws Exception {
        if (department == null) {
            return false;
        }
        Department department2 = this.getDepartmentByNameAndPid(department.getName(), department.getPid());
        if (department2 != null) {
            department.setId(department2.getId());
            return false;
        }
        FSConfig.getInstance().getControl().getDepartmentDAO().save(department);
        if (department.getId() < 0L) {
            return false;
        }
        try {
            DepartmentCache.cache(department);
        }
        catch (Exception exception) {
            DepartmentCache.reInit();
        }
        long l = CompanyRoleControl.getInstance().getPostAllID();
        CompanyRole companyRole = new CompanyRole(l, department.getId(), "");
        CompanyRoleControl.getInstance().addCompanyRole(companyRole);
        return true;
    }

    public String getDepartmentShowName(long l) {
        return this.getDepartmentShowName(l, null);
    }

    public String getDepartmentShowName(long l, String string) {
        if (l < 0L) {
            return null;
        }
        return DepartmentCache.getShowDepartmentName(l, string);
    }

    public Long[] getDepartmentIDPath(long l) {
        if (l < 0L) {
            return null;
        }
        return DepartmentCache.getDepartmentPath(l);
    }

    public boolean deleteDepartment(long l) throws Exception {
        boolean bl = true;
        try {
            List<CompanyRole> list = CompanyRoleControl.getInstance().getJRole(l, CompanyRoleControl.getInstance().getPostAllID());
            if (list.size() > 0) {
                bl = CompanyRoleControl.getInstance().deleteCompanyRole(list.get(0).getId());
            }
        }
        catch (Exception exception) {
            CompanyRoleCache.reInitCache();
        }
        try {
            bl = DepartmentCache.removeCache(l) && bl;
        }
        catch (Exception exception) {
            DepartmentCache.reInit();
        }
        try {
            UserCache.refreshAfterDelDepartment(l);
        }
        catch (Exception exception) {
            UserCache.removeAllCache();
        }
        return bl;
    }

    public JSONArray getDepartmentInfoPrivilege(long l, boolean bl) throws Exception {
        Department department;
        if (l == CustomRoleControl.getInstance().getSuperCustomRoleID()) {
            return this.getAllDepartmentInfo(bl);
        }
        JSONArray jSONArray = FSConfig.getInstance().getControl().getControlType() == 0 ? this.createPrivilegeJSONConfigFromRoot(l) : this.createPrivilegeJSONConfigWithNoRoot(l);
        if (bl && (department = DepartmentCache.getDepartment(CompanyRoleControl.getInstance().getDepartmentAllID())) != null) {
            jSONArray.put((Object)department.createJSONConfig());
        }
        return jSONArray;
    }

    private JSONArray createPrivilegeJSONConfigFromRoot(long l) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        DepartmentTreeNode departmentTreeNode = DepartmentCache.getRootNode();
        JSONArray jSONArray2 = this.createPrivilegeJSONConfigWithNoRoot(l);
        if (FSConfig.getInstance().getAuthorizeAttr().isGradeAuthority() && !this.hasAllDepartmentPrivilege(l)) {
            return jSONArray2;
        }
        JSONObject jSONObject = departmentTreeNode.getDepartment().createJSONConfig();
        jSONObject.put("ChildNodes", (Object)jSONArray2);
        jSONArray.put((Object)jSONObject);
        return jSONArray;
    }

    private JSONArray createPrivilegeJSONConfigWithNoRoot(long l) throws JSONException {
        DepartmentTreeNode departmentTreeNode = DepartmentCache.getRootNode();
        Object[] objectArray = departmentTreeNode.getNodes(l, null);
        JSONArray jSONArray = new JSONArray();
        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
            for (Object object : objectArray) {
                jSONArray.put((Object)((DepartmentTreeNode)object).createJSONConfig());
            }
        }
        return jSONArray;
    }

    private boolean hasAllDepartmentPrivilege(long l) {
        Set<Object> set = new HashSet();
        try {
            set = UserCache.getAllDepAndCRolePrivileges(l);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        for (RoleDepAndCRolePrivilege roleDepAndCRolePrivilege : set) {
            if (roleDepAndCRolePrivilege.getType() != 0 || roleDepAndCRolePrivilege.getDeporcroleid() != -1L) continue;
            return true;
        }
        return false;
    }

    public JSONArray getAllDepartmentInfo(boolean bl) throws Exception {
        Object object;
        JSONArray jSONArray = new JSONArray();
        if (FSConfig.getInstance().getControl().getControlType() == 0) {
            jSONArray.put((Object)DepartmentCache.getRootNode().createJSONConfig());
        } else {
            object = DepartmentCache.getRootNode();
            Object[] objectArray = ((DepartmentTreeNode)object).getNodes();
            if (!ArrayUtils.isEmpty((Object[])objectArray)) {
                for (int i = 0; i < objectArray.length; ++i) {
                    jSONArray.put((Object)((DepartmentTreeNode)objectArray[i]).createJSONConfig());
                }
            }
        }
        if (bl && (object = DepartmentCache.getDepartment(CompanyRoleControl.getInstance().getDepartmentAllID())) != null) {
            jSONArray.put((Object)((Department)((Object)object)).createJSONConfig());
        }
        return jSONArray;
    }
}

