/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.cache;

import com.fr.base.FRContext;
import com.fr.data.dao.DAOBean;
import com.fr.data.dao.DAOException;
import com.fr.data.dao.RelationObject;
import com.fr.fs.FSConfig;
import com.fr.fs.base.entity.CompanyRole;
import com.fr.fs.base.entity.CustomRole;
import com.fr.fs.base.entity.Department;
import com.fr.fs.base.entity.Post;
import com.fr.fs.base.entity.RoleDataConnectionPrivilege;
import com.fr.fs.base.entity.RoleDepAndCRolePrivilege;
import com.fr.fs.base.entity.RoleEntryPrivilege;
import com.fr.fs.base.entity.RoleHomePagePrivilege;
import com.fr.fs.base.entity.RoleModulePrivilege;
import com.fr.fs.base.entity.User;
import com.fr.fs.cache.CompanyRoleCache;
import com.fr.fs.cache.CustomRoleCache;
import com.fr.fs.cache.EntryTypeAndID;
import com.fr.fs.cache.HomePageCache;
import com.fr.fs.cache.IDLockCreator;
import com.fr.fs.cache.Job;
import com.fr.fs.cache.UserCacheInfo;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.control.dao.tabledata.TableDataCustomRoleDAO;
import com.fr.fs.web.ShowType;
import com.fr.general.ComparatorUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserCache {
    private static final IDLockCreator USERIDLOCKCREATOR = new IDLockCreator();
    private static Map historyMap = new Hashtable();
    private static UserCacheMap<Long, UserCacheInfo> userMap = new UserCacheMap(128);
    private static final HashSet<Long> NO_ROLE_USERS = new HashSet();
    private static List duplicatedUsers;
    private static final Object jobLock;
    private static final Object refreshLock;
    private static final Object refreshJobLock;

    public static void addToHistory(long l, IDText iDText) {
        Long l2 = l;
        ArrayList<IDText> arrayList = (ArrayList<IDText>)historyMap.get(l2);
        if (arrayList == null) {
            arrayList = new ArrayList<IDText>();
            historyMap.put(l2, arrayList);
        }
        if (!arrayList.contains(iDText)) {
            arrayList.add(iDText);
        }
    }

    public static int getHistoryCount(long l) {
        List list = (List)historyMap.get(new Long(l));
        return list == null ? 0 : list.size();
    }

    public static IDText getHistory(long l, int n) {
        List list = (List)historyMap.get(new Long(l));
        if (n < 0 || n > UserCache.getHistoryCount(l) - 1) {
            return null;
        }
        return (IDText)list.get(n);
    }

    public static void removeHistory(long l, IDText iDText) {
        List list = (List)historyMap.get(new Long(l));
        if (list != null) {
            list.remove(iDText);
        }
    }

    public static boolean checkHistory(long l, IDText iDText) {
        List list = (List)historyMap.get(new Long(l));
        if (list == null) {
            return false;
        }
        return list.contains(iDText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cache(long l) throws Exception {
        if (l >= 0L || l == UserControl.getInstance().getSuperManagerID()) {
            Object object = USERIDLOCKCREATOR.getIDLock(l);
            try {
                Object object2 = object;
                synchronized (object2) {
                    block11: {
                        if (!userMap.containsKey(l)) break block11;
                        return;
                    }
                    UserCacheInfo userCacheInfo = UserCache.createUserCacheInfo(l);
                    if (userCacheInfo != null) {
                        userMap.put(l, userCacheInfo);
                        if (userCacheInfo.companyRoleSet.isEmpty() && userCacheInfo.customRoleSet.isEmpty()) {
                            UserCache.addNoRoleUser(l);
                        }
                    }
                }
            }
            finally {
                USERIDLOCKCREATOR.releaseIDLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cacheJob(long l, long l2, long l3) throws Exception {
        if (!UserCache.isValidate(l, l2, l3)) {
            return;
        }
        UserCacheInfo userCacheInfo = userMap.get(l);
        if (userCacheInfo != null) {
            Object object = jobLock;
            synchronized (object) {
                List<CompanyRole> list;
                if (userCacheInfo.jobSet.add(new Job(l2, l3)) && (list = CompanyRoleControl.getInstance().getJRole(l2, l3)) != null) {
                    for (CompanyRole companyRole : list) {
                        userCacheInfo.companyRoleSet.add(companyRole);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean refreshCacheInfo(long l, String string, String string2, String string3, String string4, String string5) throws Exception {
        if (l < 0L) {
            return false;
        }
        UserCacheInfo userCacheInfo = userMap.get(l);
        if (userCacheInfo != null) {
            Object object = refreshLock;
            synchronized (object) {
                try {
                    if (FSConfig.getInstance().getControl().getUserDAO().update(l, string, string2, string3, string4, string5)) {
                        userCacheInfo.getUser().setUsername(string);
                        userCacheInfo.getUser().setPassword(string2);
                        userCacheInfo.getUser().setRealname(string3);
                        userCacheInfo.getUser().setMobile(string4);
                        userCacheInfo.getUser().setEmail(string5);
                        return true;
                    }
                }
                catch (DAOException dAOException) {
                    return false;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshCacheJob(long l) throws Exception {
        if (l < 0L) {
            return;
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(new Long(l));
        if (userCacheInfo != null) {
            Object object = refreshJobLock;
            synchronized (object) {
                userCacheInfo.jobSet.clear();
                userCacheInfo.companyRoleSet.clear();
                Set set = FSConfig.getInstance().getControl().getUserDAO().getJobSet(l);
                for (RelationObject relationObject : set) {
                    long l2 = (Long)relationObject.getValue(Post.class);
                    long l3 = (Long)relationObject.getValue(Department.class);
                    userCacheInfo.jobSet.add(new Job(l3, l2));
                    List<CompanyRole> list = CompanyRoleControl.getInstance().getJRole(l3, l2);
                    if (list == null) continue;
                    for (CompanyRole companyRole : list) {
                        userCacheInfo.companyRoleSet.add(companyRole);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cacheSRole(long l, CustomRole customRole) {
        if (customRole == null) {
            return;
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(new Long(l));
        UserCache.removeNoRoleUser(l);
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                userCacheInfo.customRoleSet.add(customRole.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshAfterAddSRole(long[] lArray, long l) {
        for (long l2 : lArray) {
            UserCacheInfo userCacheInfo = userMap.get(l2);
            UserCache.removeNoRoleUser(l2);
            if (userCacheInfo == null) continue;
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                userCacheInfo.customRoleSet.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshAfterDelSRoleUser(long[] lArray, long l) throws Exception {
        for (long l2 : lArray) {
            UserCacheInfo userCacheInfo = userMap.get(l2);
            UserCache.checkAndAddNoRoleUser(l2);
            if (userCacheInfo == null) continue;
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                userCacheInfo.customRoleSet.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCacheSRole(long l, CustomRole customRole) throws Exception {
        if (customRole == null || customRole.getId() == -999L) {
            return;
        }
        UserCacheInfo userCacheInfo = userMap.get(l);
        UserCache.checkAndAddNoRoleUser(l);
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                userCacheInfo.customRoleSet.remove(customRole.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addNoRoleUser(long l) {
        HashSet<Long> hashSet = NO_ROLE_USERS;
        synchronized (hashSet) {
            NO_ROLE_USERS.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeNoRoleUser(long l) {
        HashSet<Long> hashSet = NO_ROLE_USERS;
        synchronized (hashSet) {
            if (NO_ROLE_USERS.contains(l)) {
                NO_ROLE_USERS.remove(l);
            }
        }
    }

    public static void checkAndAddNoRoleUser(long l) throws Exception {
        UserCacheInfo userCacheInfo = userMap.get(l);
        if (userCacheInfo.companyRoleSet.isEmpty() && userCacheInfo.customRoleSet.isEmpty()) {
            UserCache.addNoRoleUser(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<User> getNoRoleUsers() throws Exception {
        HashSet<User> hashSet = new HashSet<User>();
        HashSet<Long> hashSet2 = NO_ROLE_USERS;
        synchronized (hashSet2) {
            for (Long l : NO_ROLE_USERS) {
                UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(l);
                User user = userCacheInfo.getUser();
                if (user == null) continue;
                hashSet.add(user);
            }
        }
        return hashSet;
    }

    private static UserCacheInfo createUserCacheInfo(long l) throws Exception {
        if (l == UserControl.getInstance().getSuperManagerID()) {
            UserCacheInfo userCacheInfo = new UserCacheInfo();
            userCacheInfo.customRoleSet.add(CustomRoleControl.getInstance().getSuperCustomRoleID());
            return userCacheInfo;
        }
        User user = FSConfig.getInstance().getControl().getUserDAO().findByID(l);
        if (user != null) {
            List<CompanyRole> list;
            UserCacheInfo userCacheInfo = new UserCacheInfo();
            userCacheInfo.setUser(user);
            Set set = FSConfig.getInstance().getControl().getUserDAO().getSRoleSet(user.getId());
            for (RelationObject relationObject : set) {
                userCacheInfo.customRoleSet.add((Long)relationObject.getValue(CustomRole.class));
            }
            set = FSConfig.getInstance().getControl().getUserDAO().getJobSet(user.getId());
            for (RelationObject relationObject : set) {
                long l2 = (Long)relationObject.getValue(Post.class);
                long l3 = (Long)relationObject.getValue(Department.class);
                userCacheInfo.jobSet.add(new Job(l3, l2));
                List<CompanyRole> list2 = CompanyRoleControl.getInstance().getJRole(l3, l2);
                if (list2 == null) continue;
                for (CompanyRole companyRole : list2) {
                    userCacheInfo.companyRoleSet.add(companyRole);
                }
            }
            if (!userCacheInfo.companyRoleSet.isEmpty() && !(list = CompanyRoleControl.getInstance().getJRole(CompanyRoleControl.getInstance().getDepartmentAllID(), CompanyRoleControl.getInstance().getPostAllID())).isEmpty()) {
                userCacheInfo.companyRoleSet.add(list.get(0));
            }
            return userCacheInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAllCache() {
        Serializable serializable = userMap;
        synchronized (serializable) {
            userMap.clear();
        }
        serializable = NO_ROLE_USERS;
        synchronized (serializable) {
            NO_ROLE_USERS.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCache(long l) {
        if (l < 0L && l != UserControl.getInstance().getSuperManagerID()) {
            return;
        }
        Object object = USERIDLOCKCREATOR.getIDLock(l);
        try {
            Object object2 = object;
            synchronized (object2) {
                historyMap.remove(l);
                userMap.remove(new Long(l));
                UserCache.removeNoRoleUser(l);
            }
        }
        finally {
            USERIDLOCKCREATOR.releaseIDLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static User getUserById(long l) throws Exception {
        try {
            UserCache.cache(l);
        }
        catch (Exception exception) {
            FRContext.getLogger().error("User Cached Failed : " + exception.getMessage(), (Throwable)exception);
        }
        UserCacheInfo userCacheInfo = userMap.get(l);
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                return userCacheInfo.getUser();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<CustomRole> getSRoles(long l) throws Exception {
        if (l < 0L && l != UserControl.getInstance().getSuperManagerID()) {
            return null;
        }
        try {
            UserCache.cache(l);
        }
        catch (Exception exception) {
            FRContext.getLogger().error("User Cached Failed : " + exception.getMessage(), (Throwable)exception);
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(new Long(l));
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                HashSet<CustomRole> hashSet = new HashSet<CustomRole>();
                Iterator<Long> iterator = userCacheInfo.customRoleSet.iterator();
                while (iterator.hasNext()) {
                    CustomRole customRole;
                    Long l2 = iterator.next();
                    if (l2.longValue() != CustomRoleControl.getInstance().getSuperCustomRoleID() && !CustomRoleCache.containCache(l2)) {
                        iterator.remove();
                    }
                    if ((customRole = CustomRoleControl.getInstance().getCustomRole(l2)) == null) continue;
                    hashSet.add(customRole);
                }
                return hashSet;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> getAllCompanyRoleIDs(long l) {
        if (l < 0L && l != UserControl.getInstance().getSuperManagerID()) {
            return new HashSet<Long>();
        }
        try {
            UserCache.cache(l);
        }
        catch (Exception exception) {
            FRContext.getLogger().error("User Cached Failed : " + exception.getMessage(), (Throwable)exception);
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(new Long(l));
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                HashSet<Long> hashSet = new HashSet<Long>();
                Iterator<CompanyRole> iterator = userCacheInfo.companyRoleSet.iterator();
                while (iterator.hasNext()) {
                    CompanyRole companyRole = iterator.next();
                    if (!CompanyRoleCache.containCache(companyRole.getId())) {
                        iterator.remove();
                    }
                    hashSet.add(companyRole.getId());
                }
                return hashSet;
            }
        }
        return new HashSet<Long>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getAllCompanyRoleNames(long l) {
        if (l < 0L && l != UserControl.getInstance().getSuperManagerID()) {
            return new HashSet<String>();
        }
        try {
            UserCache.cache(l);
        }
        catch (Exception exception) {
            FRContext.getLogger().error("User Cached Failed : " + exception.getMessage(), (Throwable)exception);
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(new Long(l));
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                HashSet<String> hashSet = new HashSet<String>();
                Iterator<CompanyRole> iterator = userCacheInfo.companyRoleSet.iterator();
                while (iterator.hasNext()) {
                    CompanyRole companyRole = iterator.next();
                    if (!CompanyRoleCache.containCache(companyRole.getId())) {
                        iterator.remove();
                    }
                    hashSet.add(((Object)((Object)companyRole)).toString());
                }
                return hashSet;
            }
        }
        return new HashSet<String>();
    }

    private static boolean examineId(long l) {
        if (l < 0L && l != UserControl.getInstance().getSuperManagerID()) {
            return false;
        }
        try {
            UserCache.cache(l);
        }
        catch (Exception exception) {
            FRContext.getLogger().error("User Cached Failed : " + exception.getMessage(), (Throwable)exception);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<EntryTypeAndID> getAllEntryPrivileges(long l) throws Exception {
        if (!UserCache.examineId(l)) {
            return null;
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(new Long(l));
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                Object object;
                HashSet<EntryTypeAndID> hashSet = new HashSet<EntryTypeAndID>();
                Iterator<Long> iterator = userCacheInfo.customRoleSet.iterator();
                List<EntryTypeAndID> list = new ArrayList<EntryTypeAndID>();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    UserCache.dealWithRoleEntryPrivileges(iterator, (Long)object, list, hashSet);
                }
                object = userCacheInfo.companyRoleSet.iterator();
                while (object.hasNext()) {
                    CompanyRole companyRole = (CompanyRole)((Object)object.next());
                    if (!CompanyRoleCache.containCache(companyRole.getId())) {
                        object.remove();
                    }
                    if ((list = CompanyRoleCache.getAllEntryPrivileges(companyRole.getId())) == null) continue;
                    for (EntryTypeAndID entryTypeAndID : list) {
                        hashSet.add(entryTypeAndID);
                    }
                }
                return hashSet;
            }
        }
        return null;
    }

    private static void dealWithRoleEntryPrivileges(Iterator<Long> iterator, Long l, List<EntryTypeAndID> list, Set<EntryTypeAndID> set) throws Exception {
        if (l.longValue() != CustomRoleControl.getInstance().getSuperCustomRoleID() && !CustomRoleCache.containCache(l)) {
            iterator.remove();
        }
        if (l <= -1000L) {
            String string = CustomRoleControl.getInstance().getCustomRole(l).getRolename();
            Set<RoleEntryPrivilege> set2 = TableDataCustomRoleDAO.getInstance().getEntryPrivileges(string);
            for (RoleEntryPrivilege roleEntryPrivilege : set2) {
                list.add(EntryTypeAndID.getInstance(roleEntryPrivilege.getType(), roleEntryPrivilege.getEntryid(), roleEntryPrivilege.getView(), roleEntryPrivilege.getAuthorized(), roleEntryPrivilege.getEdit()));
            }
        } else {
            list = CustomRoleControl.getInstance().getAllEntryPrivileges4Obj(l);
        }
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                set.add(list.get(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getAllTemplatePrivileges(long l) throws Exception {
        if (!UserCache.examineId(l)) {
            return null;
        }
        UserCacheInfo userCacheInfo = userMap.get(l);
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                int n;
                Object object;
                HashSet<Object> hashSet = new HashSet<Object>();
                Iterator<Object> iterator = userCacheInfo.customRoleSet.iterator();
                List<Object> list = new ArrayList();
                while (iterator.hasNext()) {
                    Long l2 = iterator.next();
                    if (l2.longValue() != CustomRoleControl.getInstance().getSuperCustomRoleID() && !CustomRoleCache.containCache(l2)) {
                        iterator.remove();
                    }
                    if (l2 <= -1000L) {
                        object = CustomRoleControl.getInstance().getCustomRole(l2).getRolename();
                        list.addAll(TableDataCustomRoleDAO.getInstance().getTemplatePrivileges((String)object));
                    } else {
                        list = CustomRoleControl.getInstance().getAllTemplatePrivileges(l2);
                    }
                    if (list == null) continue;
                    n = list.size();
                    for (int i = 0; i < n; ++i) {
                        hashSet.add(list.get(i));
                    }
                }
                iterator = userCacheInfo.companyRoleSet.iterator();
                while (iterator.hasNext()) {
                    object = (CompanyRole)((Object)iterator.next());
                    if (!CompanyRoleCache.containCache(object.getId())) {
                        iterator.remove();
                    }
                    if ((list = CompanyRoleCache.getAllTemplatePrivileges(object.getId())) == null) continue;
                    int n2 = list.size();
                    for (n = 0; n < n2; ++n) {
                        hashSet.add(list.get(n));
                    }
                }
                return hashSet;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<RoleDepAndCRolePrivilege> getAllDepAndCRolePrivileges(long l) throws Exception {
        if (!UserCache.examineId(l)) {
            return null;
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(new Long(l));
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                List<RoleDepAndCRolePrivilege> list;
                HashSet<RoleDepAndCRolePrivilege> hashSet = new HashSet<RoleDepAndCRolePrivilege>();
                Iterator<Long> iterator = userCacheInfo.customRoleSet.iterator();
                while (iterator.hasNext()) {
                    Long l2 = iterator.next();
                    if (l2.longValue() != CustomRoleControl.getInstance().getSuperCustomRoleID() && !CustomRoleCache.containCache(l2)) {
                        iterator.remove();
                    }
                    if ((list = CustomRoleControl.getInstance().getAllDepAndCRolePrivileges(l2)) == null) continue;
                    for (RoleDepAndCRolePrivilege dAOBean : list) {
                        hashSet.add(dAOBean);
                    }
                }
                Iterator<DAOBean> iterator2 = userCacheInfo.companyRoleSet.iterator();
                while (iterator2.hasNext()) {
                    CompanyRole companyRole = iterator2.next();
                    if (!CompanyRoleCache.containCache(companyRole.getId())) {
                        iterator2.remove();
                    }
                    if ((list = CompanyRoleCache.getAllDepAndCRolePrivileges(companyRole.getId())) == null) continue;
                    for (RoleDepAndCRolePrivilege roleDepAndCRolePrivilege : list) {
                        hashSet.add(roleDepAndCRolePrivilege);
                    }
                }
                return hashSet;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<RoleDataConnectionPrivilege> getAllDataConnectionPrivileges(long l) throws Exception {
        if (!UserCache.examineId(l)) {
            return null;
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(new Long(l));
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                Object object;
                HashSet<RoleDataConnectionPrivilege> hashSet = new HashSet<RoleDataConnectionPrivilege>();
                Iterator<Object> iterator = userCacheInfo.customRoleSet.iterator();
                while (iterator.hasNext()) {
                    Long l2 = iterator.next();
                    if (l2.longValue() != CustomRoleControl.getInstance().getSuperCustomRoleID() && !CustomRoleCache.containCache(l2)) {
                        iterator.remove();
                    }
                    if (l2 <= -1000L) {
                        object = CustomRoleControl.getInstance().getCustomRole(l2).getRolename();
                        hashSet.addAll(TableDataCustomRoleDAO.getInstance().getDataConnectionPrivileges((String)object));
                        continue;
                    }
                    hashSet.addAll(CustomRoleControl.getInstance().getAllDataConnectionPrivileges(l2));
                }
                iterator = userCacheInfo.companyRoleSet.iterator();
                while (iterator.hasNext()) {
                    object = (CompanyRole)((Object)iterator.next());
                    if (!CompanyRoleCache.containCache(object.getId())) {
                        iterator.remove();
                    }
                    hashSet.addAll(CompanyRoleCache.getAllDataConnectionPrivileges(object.getId()));
                }
                return hashSet;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<RoleModulePrivilege> getAllModulePrivileges(long l) throws Exception {
        if (!UserCache.examineId(l)) {
            return null;
        }
        UserCacheInfo userCacheInfo = userMap.get(l);
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                Iterator<Object> iterator;
                HashSet<RoleModulePrivilege> hashSet = new HashSet<RoleModulePrivilege>();
                Iterator<Long> iterator2 = userCacheInfo.customRoleSet.iterator();
                List<Object> list = new ArrayList();
                while (iterator2.hasNext()) {
                    Long l2 = iterator2.next();
                    if (l2.longValue() != CustomRoleControl.getInstance().getSuperCustomRoleID() && !CustomRoleCache.containCache(l2)) {
                        iterator2.remove();
                    }
                    if (l2 <= -1000L) {
                        iterator = CustomRoleControl.getInstance().getCustomRole(l2).getRolename();
                        if (list != null) {
                            list.addAll(TableDataCustomRoleDAO.getInstance().getModulePrivileges((String)((Object)iterator)));
                        }
                    } else {
                        list = CustomRoleControl.getInstance().getAllModulePrivileges(l2);
                    }
                    if (list == null) continue;
                    for (RoleModulePrivilege dAOBean : list) {
                        hashSet.add(dAOBean);
                    }
                }
                iterator = userCacheInfo.companyRoleSet.iterator();
                while (iterator.hasNext()) {
                    CompanyRole companyRole = iterator.next();
                    if (!CompanyRoleCache.containCache(companyRole.getId())) {
                        iterator.remove();
                    }
                    if ((list = CompanyRoleCache.getAllModulePrivileges(companyRole.getId())) == null) continue;
                    for (RoleModulePrivilege roleModulePrivilege : list) {
                        hashSet.add(roleModulePrivilege);
                    }
                }
                return hashSet;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containModulePrivilege(long l, long l2) {
        if (l == UserControl.getInstance().getSuperManagerID()) {
            return true;
        }
        if (l < 0L || l2 < 0L) {
            return false;
        }
        try {
            UserCache.cache(l);
        }
        catch (Exception exception) {
            FRContext.getLogger().error("User Cached Failed : " + exception.getMessage(), (Throwable)exception);
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(new Long(l));
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                for (Long l3 : userCacheInfo.customRoleSet) {
                    if (l3 <= -1000L) {
                        try {
                            Object object = CustomRoleControl.getInstance().getCustomRole(l3).getRolename();
                            Set<RoleModulePrivilege> set = TableDataCustomRoleDAO.getInstance().getModulePrivileges((String)object);
                            for (RoleModulePrivilege roleModulePrivilege : set) {
                                if (roleModulePrivilege.getModuleid() != l2) continue;
                                return true;
                            }
                            continue;
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    if (!CustomRoleControl.getInstance().containModulePrivilege(l3, l2)) continue;
                    return true;
                }
                for (Object object : userCacheInfo.companyRoleSet) {
                    if (!CompanyRoleCache.containModulePrivilege(object.getId(), l2)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new RuntimeException("No user exist!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<RoleHomePagePrivilege> getAllHomePagePrivileges(long l) throws Exception {
        if (!UserCache.examineId(l)) {
            return null;
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(new Long(l));
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                Object object;
                Object object2;
                HashSet<RoleHomePagePrivilege> hashSet = new HashSet<RoleHomePagePrivilege>();
                Iterator<Long> iterator = userCacheInfo.customRoleSet.iterator();
                List<Object> list = new ArrayList();
                while (iterator.hasNext()) {
                    object2 = iterator.next();
                    if (((Long)object2).longValue() != CustomRoleControl.getInstance().getSuperCustomRoleID() && !CustomRoleCache.containCache((Long)object2)) {
                        iterator.remove();
                    }
                    if ((Long)object2 <= -1000L) {
                        object = CustomRoleControl.getInstance().getCustomRole((Long)object2).getRolename();
                        list.addAll(TableDataCustomRoleDAO.getInstance().getHomePagePrivileges((String)object));
                    } else {
                        list = CustomRoleControl.getInstance().getAllHomePagePrivileges((Long)object2);
                    }
                    if (list == null) continue;
                    for (RoleHomePagePrivilege object3 : list) {
                        if (!HomePageCache.containCache(object3.getHomePageId())) continue;
                        hashSet.add(object3);
                    }
                }
                object2 = userCacheInfo.companyRoleSet.iterator();
                while (object2.hasNext()) {
                    object = (CompanyRole)((Object)object2.next());
                    if (!CompanyRoleCache.containCache(object.getId())) {
                        object2.remove();
                    }
                    if ((list = CompanyRoleCache.getAllHomePagePrivileges(object.getId())) == null) continue;
                    for (RoleHomePagePrivilege roleHomePagePrivilege : list) {
                        if (!HomePageCache.containCache(roleHomePagePrivilege.getHomePageId())) continue;
                        hashSet.add(roleHomePagePrivilege);
                    }
                }
                return hashSet;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containHomePagePrivilege(long l, long l2) {
        if (l == UserControl.getInstance().getSuperManagerID()) {
            return true;
        }
        if (l < 0L || l2 < 0L) {
            return false;
        }
        try {
            UserCache.cache(l);
        }
        catch (Exception exception) {
            FRContext.getLogger().error("User Cached Failed : " + exception.getMessage(), (Throwable)exception);
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(new Long(l));
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                for (Long object : userCacheInfo.customRoleSet) {
                    if (object <= -1000L) {
                        try {
                            String string = CustomRoleControl.getInstance().getCustomRole(object).getRolename();
                            Set<RoleHomePagePrivilege> set = TableDataCustomRoleDAO.getInstance().getHomePagePrivileges(string);
                            for (RoleHomePagePrivilege roleHomePagePrivilege : set) {
                                if (roleHomePagePrivilege.getHomePageId() != l2) continue;
                                return true;
                            }
                            continue;
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    if (!CustomRoleControl.getInstance().containHomPagePrivilege(object, l2)) continue;
                    return true;
                }
                for (CompanyRole companyRole : userCacheInfo.companyRoleSet) {
                    if (!CompanyRoleCache.containHomePagePrivilege(companyRole.getId(), l2)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new RuntimeException("No user exist!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containPlatePrivilege(long l, long l2, String string) {
        if (l == UserControl.getInstance().getSuperManagerID()) {
            return true;
        }
        if (l < 0L || l2 < 0L) {
            return false;
        }
        try {
            UserCache.cache(l);
        }
        catch (Exception exception) {
            FRContext.getLogger().error("User Cached Failed : " + exception.getMessage(), (Throwable)exception);
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(new Long(l));
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                for (Long l3 : userCacheInfo.customRoleSet) {
                    if (!CustomRoleControl.getInstance().containPlatePrivilege(l3, l2, string)) continue;
                    return true;
                }
                for (CompanyRole companyRole : userCacheInfo.companyRoleSet) {
                    if (!CompanyRoleCache.containPlatePrivilege(companyRole.getId(), l2, string)) continue;
                    return true;
                }
                return false;
            }
        }
        throw new RuntimeException("No user exist!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containEntryPrivilege(long l, int n, long l2) {
        if (l == UserControl.getInstance().getSuperManagerID()) {
            return true;
        }
        if (l < 0L || l2 < -1L) {
            return false;
        }
        try {
            UserCache.cache(l);
        }
        catch (Exception exception) {
            FRContext.getLogger().error("User Cached Failed : " + exception.getMessage(), (Throwable)exception);
        }
        UserCacheInfo userCacheInfo = (UserCacheInfo)userMap.get(new Long(l));
        if (userCacheInfo != null) {
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                return UserCache.containPrivilegeInCache(userCacheInfo, n, l2);
            }
        }
        throw new RuntimeException("No user exist!");
    }

    private static boolean containPrivilegeInCache(UserCacheInfo userCacheInfo, int n, long l) {
        for (Long l2 : userCacheInfo.customRoleSet) {
            if (!CustomRoleControl.getInstance().containEntryPrivilege(l2, n, l)) continue;
            return true;
        }
        for (CompanyRole companyRole : userCacheInfo.companyRoleSet) {
            if (!CompanyRoleCache.containEntryPrivilege(companyRole.getId(), n, l)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshAfterDelDepartment(long l) {
        List list = UserCache.getAllCacheList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            UserCacheInfo userCacheInfo = (UserCacheInfo)list.get(i);
            if (userCacheInfo == null) continue;
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                CompanyRole companyRole;
                Set<Job> set = userCacheInfo.jobSet;
                Iterator<Job> iterator = set.iterator();
                while (iterator.hasNext()) {
                    Job job = iterator.next();
                    if (job.getDepartmentID() != l) continue;
                    iterator.remove();
                }
                Set<CompanyRole> set2 = userCacheInfo.companyRoleSet;
                Iterator<CompanyRole> iterator2 = set2.iterator();
                if (iterator2.hasNext() && (companyRole = iterator2.next()).getDepartmentId() == l) {
                    set2.remove((Object)companyRole);
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshAfterDelPost(long l) {
        List list = UserCache.getAllCacheList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            UserCacheInfo userCacheInfo = (UserCacheInfo)list.get(i);
            if (userCacheInfo == null) continue;
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                CompanyRole companyRole;
                Set<Job> set = userCacheInfo.jobSet;
                Iterator<Job> iterator = set.iterator();
                while (iterator.hasNext()) {
                    Job job = iterator.next();
                    if (job.getPostID() != l) continue;
                    iterator.remove();
                }
                Set<CompanyRole> set2 = userCacheInfo.companyRoleSet;
                Iterator<CompanyRole> iterator2 = set2.iterator();
                if (iterator2.hasNext() && (companyRole = iterator2.next()).getPostId() == l) {
                    set2.remove((Object)companyRole);
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getAllCacheList() {
        UserCacheMap<Long, UserCacheInfo> userCacheMap = userMap;
        synchronized (userCacheMap) {
            ArrayList arrayList = new ArrayList(userMap.size());
            Set set = userMap.entrySet();
            for (Map.Entry entry : set) {
                arrayList.add(entry.getValue());
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshAfterDeleteCompanyRole(long l) {
        if (l < 0L) {
            return;
        }
        CompanyRole companyRole = new CompanyRole(l);
        List list = UserCache.getAllCacheList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            UserCacheInfo userCacheInfo = (UserCacheInfo)list.get(i);
            if (userCacheInfo == null) continue;
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                Set<CompanyRole> set = userCacheInfo.companyRoleSet;
                set.remove((Object)companyRole);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshAfterUpdateJRole(CompanyRole companyRole) {
        if (companyRole == null) {
            return;
        }
        List list = UserCache.getAllCacheList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            UserCacheInfo userCacheInfo = (UserCacheInfo)list.get(i);
            if (userCacheInfo == null) continue;
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                boolean bl = false;
                Set<Job> set = userCacheInfo.jobSet;
                for (Job job : set) {
                    if (!UserCache.isJRoleMatch(companyRole, job)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    userCacheInfo.companyRoleSet.add(companyRole);
                } else {
                    userCacheInfo.companyRoleSet.remove((Object)companyRole);
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshAfterDelSRole(long l) {
        List list = UserCache.getAllCacheList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            UserCacheInfo userCacheInfo = (UserCacheInfo)list.get(i);
            if (userCacheInfo == null) continue;
            UserCacheInfo userCacheInfo2 = userCacheInfo;
            synchronized (userCacheInfo2) {
                userCacheInfo.customRoleSet.remove(new Long(l));
                continue;
            }
        }
    }

    public static List getDuplicatedUsers() {
        return duplicatedUsers;
    }

    public static void setDuplicatedUsers(List list) {
        duplicatedUsers = list;
    }

    private static boolean isValidate(long l, long l2, long l3) {
        return l >= 0L && l2 >= 0L && l3 >= 0L;
    }

    private static boolean isJRoleMatch(CompanyRole companyRole, Job job) {
        return companyRole.getDepartmentId() == 0L && job.getPostID() == companyRole.getPostId() || companyRole.getPostId() == 0L && job.getDepartmentID() == companyRole.getDepartmentId() || job.getDepartmentID() == companyRole.getDepartmentId() && job.getPostID() == companyRole.getPostId() || companyRole.getPostId() == 0L && companyRole.getDepartmentId() == 0L;
    }

    static {
        jobLock = new Object();
        refreshLock = new Object();
        refreshJobLock = new Object();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UserCacheMap<K, V>
    extends ConcurrentHashMap<K, V> {
        public UserCacheMap(int n) {
            super(n);
        }

        public V get(long l) {
            Object v = super.get(l);
            if (v == null) {
                try {
                    UserCache.cache(l);
                }
                catch (Exception exception) {
                    return null;
                }
                v = super.get(l);
            }
            return v;
        }
    }

    public static class IDText {
        private String id;
        private String text;
        private ShowType showType;

        public IDText(String string) {
            this(string, "", ShowType.NONE);
        }

        public IDText(String string, String string2, ShowType showType) {
            this.id = string;
            this.text = string2;
            this.showType = showType;
        }

        public String getId() {
            return this.id;
        }

        public String getText() {
            return this.text;
        }

        public ShowType getShowType() {
            return this.showType;
        }

        public boolean equals(Object object) {
            return object instanceof IDText && ComparatorUtils.equals((Object)((IDText)object).id, (Object)this.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }
}

