/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs.basic;

import com.fr.fs.FSTheme;
import com.fr.fs.web.FSConstants;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemStyle
implements XMLable {
    public static final String XML_TAG = "SystemStyle";
    private int colorScheme = 0;
    private String[] customColors = new String[0];
    private Map<Long, String> folderIconMap = new HashMap<Long, String>();

    public int getColorScheme() {
        return this.colorScheme;
    }

    public void setColorScheme(int n) {
        this.colorScheme = n;
    }

    public JSONObject getFolderIcons() {
        return new JSONObject(this.folderIconMap);
    }

    public String getFolderIconById(long l) throws JSONException {
        String string = this.folderIconMap.get(l);
        if (StringUtils.isEmpty((String)string)) {
            return "e642";
        }
        return string;
    }

    public void setFolderIconById(String string, String string2) throws JSONException {
        this.setFolderIconById(Long.parseLong(string), string2);
    }

    public void setFolderIconById(long l, String string) throws JSONException {
        this.folderIconMap.put(l, string);
    }

    public void setFolderIconByString(String string) throws JSONException {
        JSONObject jSONObject = new JSONObject(string);
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            this.setFolderIconById(string2, jSONObject.optString(string2));
        }
    }

    public void setCustomColors(String string) throws JSONException {
        JSONArray jSONArray = new JSONArray(string);
        int n = jSONArray.length();
        this.customColors = new String[n];
        for (int i = 0; i < n; ++i) {
            this.customColors[i] = jSONArray.optString(i);
        }
    }

    public JSONArray getCustomColors() throws JSONException {
        if (this.customColors == null) {
            return new JSONArray();
        }
        return new JSONArray((Object)this.customColors);
    }

    public void fillAttrToMap(Map<String, Object> map) throws JSONException {
        map.put("ThemeStyle", this.createThemeStyle());
        map.put("folderIcons", this.getFolderIcons());
    }

    private String createThemeStyle() throws JSONException {
        String string;
        String string2;
        String string3;
        String string4;
        if (this.colorScheme != -1) {
            String[] stringArray = FSConstants.COLOR_SCHEMES.SCHEMES[this.colorScheme];
            string4 = stringArray[0];
            string3 = stringArray[1];
            string2 = stringArray[2];
            string = stringArray[3];
        } else {
            string4 = this.customColors[0];
            string3 = this.customColors[1];
            string2 = this.customColors[2];
            string = this.customColors[3];
        }
        return FSTheme.getInstance().importStyle(string2, string, string3, string4);
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals(XML_TAG)) {
            this.colorScheme = xMLableReader.getAttrAsInt("colorScheme", 0);
            String string2 = xMLableReader.getAttrAsString("customColors", null);
            if (string2 != null) {
                this.customColors = string2.split(";");
            }
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    String string;
                    if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("folderIcon")) {
                        SystemStyle.this.folderIconMap.put(xMLableReader.getAttrAsLong("id", 0L), xMLableReader.getAttrAsString("icon", ""));
                    }
                }
            });
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.attr("colorScheme", this.colorScheme);
        if (ArrayUtils.isNotEmpty((Object[])this.customColors)) {
            xMLPrintWriter.attr("customColors", StableUtils.join((Object[])this.customColors, (String)";"));
        }
        if (!this.folderIconMap.isEmpty()) {
            for (long l : this.folderIconMap.keySet()) {
                xMLPrintWriter.startTAG("folderIcon");
                xMLPrintWriter.attr("id", l);
                xMLPrintWriter.attr("icon", this.folderIconMap.get(l));
                xMLPrintWriter.end();
            }
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

