/*
 * Decompiled with CFR 0.152.
 */
package com.fr.fs;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.file.XMLFileManager;
import com.fr.fs.PlateFactory;
import com.fr.fs.auth.AuthenticateObjectType;
import com.fr.fs.auth.AuthorizeAttr;
import com.fr.fs.auth.DefaultAuthenticateObjectType;
import com.fr.fs.base.entity.LoginUser;
import com.fr.fs.base.entity.User;
import com.fr.fs.basic.SystemAttr;
import com.fr.fs.basic.SystemStyle;
import com.fr.fs.basic.Theme;
import com.fr.fs.cache.CompanyRoleCache;
import com.fr.fs.cache.CustomRoleCache;
import com.fr.fs.cache.DepartmentCache;
import com.fr.fs.cache.UserCache;
import com.fr.fs.control.CompanyRoleControl;
import com.fr.fs.control.CustomRoleControl;
import com.fr.fs.control.LoginUserControl;
import com.fr.fs.control.ModuleControl;
import com.fr.fs.control.UserControl;
import com.fr.fs.control.UserDataControl;
import com.fr.fs.control.UserDataControlFactory;
import com.fr.fs.control.dao.hsqldb.HSQLDBDAOControl;
import com.fr.fs.control.dao.tabledata.TableDataDAOControl;
import com.fr.fs.control.systemmanager.SystemManagerFavoriteAndADHOC;
import com.fr.fs.device.DeviceInfo;
import com.fr.fs.device.UserDevice;
import com.fr.general.ComparatorUtils;
import com.fr.general.GeneralContext;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.privilege.PrivilegeManager;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.LicUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.file.XMLFileManagerProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSConfig
extends XMLFileManager {
    private static final String XML_TAG = "fsconfig";
    public static final int DEFAULT_USER_LIMIT = 0;
    public static final int DEFAULT_MOBILE_USER_AUTH_LIMIT = 0;
    private static int userLimit = 0;
    private static int mobileUserAuthLimit = 0;
    private boolean useFS = false;
    private static FSConfig SC = null;
    private UserDataControl control = HSQLDBDAOControl.getInstance();
    private SystemManagerFavoriteAndADHOC sysManagerFvAndAD = SystemManagerFavoriteAndADHOC.getInstance();
    private Theme theme = new Theme("default");
    private SystemAttr systemAttr = new SystemAttr();
    private SystemStyle systemStyle = new SystemStyle();
    private boolean needUpdate = true;
    private AuthenticateObjectType authenticateObjectType = new DefaultAuthenticateObjectType();
    private boolean mobileDeviceBinding = false;
    private Map<String, UserDevice> userDeviceMap = new HashMap<String, UserDevice>();
    private AuthorizeAttr authorizeAttr = new AuthorizeAttr();
    private long xmlVersion;

    public static FSConfig getInstance() {
        if (SC != null) {
            return SC;
        }
        FSConfig.refreshFSConfig();
        return SC;
    }

    public static void release() {
        SC = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refreshFSConfig() {
        Class<FSConfig> clazz = FSConfig.class;
        synchronized (FSConfig.class) {
            if (SC == null) {
                SC = new FSConfig();
            }
            SC.readXMLFile();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private FSConfig() {
    }

    public String fileName() {
        return "fsconfig.xml";
    }

    public SystemAttr getSystemAttr() {
        return this.systemAttr;
    }

    public SystemStyle getSystemStyle() {
        return this.systemStyle;
    }

    public boolean isUseFS() {
        return this.useFS;
    }

    public void setUseFS(boolean bl) {
        this.useFS = bl;
    }

    public UserDataControl getControl() {
        return this.control;
    }

    public boolean setControl(UserDataControl userDataControl) {
        this.control = userDataControl;
        boolean bl = userDataControl.init();
        if (bl) {
            try {
                FRContext.getCurrentEnv().writeResource((XMLFileManagerProvider)FSConfig.getInstance());
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public void clearCache() {
        UserCache.removeAllCache();
        try {
            CustomRoleCache.clearCache();
            CompanyRoleCache.clearCache();
            DepartmentCache.clearCache();
            CompanyRoleControl.getInstance().reset();
            CustomRoleControl.getInstance().reset();
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
    }

    public boolean needUpdate() {
        return true;
    }

    public void setNeedUpdate(boolean bl) {
        this.needUpdate = bl;
    }

    public AuthorizeAttr getAuthorizeAttr() {
        return this.authorizeAttr;
    }

    public <T> T getAuthenticateObjectType(Class<? extends T> clazz) {
        if (StableUtils.classInstanceOf(this.authenticateObjectType.getClass(), clazz)) {
            return (T)this.authenticateObjectType;
        }
        return null;
    }

    public AuthenticateObjectType getAuthenticateObjectType() {
        return this.authenticateObjectType;
    }

    public void setAuthenticateObjectType(AuthenticateObjectType authenticateObjectType) {
        this.authenticateObjectType = authenticateObjectType;
    }

    public boolean isMobileDeviceBinding() {
        return this.mobileDeviceBinding;
    }

    public void setMobileDeviceBinding(boolean bl) {
        this.mobileDeviceBinding = bl;
    }

    public void addUserDevice(String string, DeviceInfo deviceInfo) {
        UserDevice userDevice = this.userDeviceMap.get(string);
        if (userDevice != null) {
            userDevice.addDeviceInfo(deviceInfo);
        } else {
            this.userDeviceMap.put(string, new UserDevice(string, deviceInfo));
        }
    }

    public UserDevice getUserDevice(String string) {
        return this.userDeviceMap.get(string);
    }

    public UserDevice removeUserDevice(String string) {
        return this.userDeviceMap.remove(string);
    }

    public JSONObject getUserDeviceJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (String string : this.userDeviceMap.keySet()) {
            UserDevice userDevice = this.userDeviceMap.get(string);
            jSONObject.put(string, (Object)userDevice.toJSONArray());
        }
        return jSONObject;
    }

    public int getUserLimit() {
        return userLimit;
    }

    public int getMobileUserAuthLimit() {
        return mobileUserAuthLimit;
    }

    public void initLoginUserListByType(int n) {
        int n2;
        List<LoginUser> list;
        if (n == 1) {
            list = LoginUserControl.getFSLoginUserList();
            n2 = this.getUserLimit();
        } else {
            list = LoginUserControl.getMobileLoginUserList();
            n2 = this.getMobileUserAuthLimit();
        }
        if (n2 > 0 && list.isEmpty()) {
            try {
                List list2 = this.getControl().getUserDAO().findAllSortByUserName();
                int n3 = Math.min(list2.size(), n2);
                for (int i = 0; i < n3; ++i) {
                    LoginUser loginUser;
                    String string = ((User)((Object)list2.get(i))).getUsername();
                    if (LoginUserControl.hasLoginUser(string)) {
                        loginUser = LoginUserControl.getLoginUser(string);
                        loginUser.setLoginType(loginUser.getLoginType() | n);
                        LoginUserControl.saveOrUpdateLoginUser(loginUser);
                        continue;
                    }
                    loginUser = new LoginUser(string, n);
                    LoginUserControl.addLoginUser(loginUser);
                }
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
            }
        } else if (n2 > 0 && list.size() > n2) {
            try {
                for (int i = n2; i < list.size(); ++i) {
                    LoginUser loginUser = list.get(i);
                    int n4 = loginUser.getLoginType() ^ 3;
                    n4 = loginUser.getLoginType() & n4;
                    if (n4 > 0) {
                        loginUser.setLoginType(n4);
                        LoginUserControl.saveOrUpdateLoginUser(loginUser);
                        continue;
                    }
                    LoginUserControl.deleteLoginUser(loginUser);
                }
            }
            catch (Exception exception) {
                FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public long getXmlVersion() {
        return this.xmlVersion;
    }

    public void setXmlVersion(long l) {
        this.xmlVersion = l;
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
    }

    public Map<String, Object> getFSParaMap(String string, long l) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("userName", string);
        hashMap.put("isRegiste", !ComparatorUtils.equals((Object)StableUtils.getBytes(), null));
        hashMap.put("hasRegistePrivilege", UserControl.getInstance().hasModulePrivilege(l, 8L));
        hashMap.put("isLicExist", BaseUtils.checkLicExist());
        hashMap.put("authenticateType", this.authenticateObjectType.markType());
        hashMap.put("templatePrivilegeType", PrivilegeManager.getInstance().getPrivilegeFilterType());
        hashMap.put("dataConnectionAuthority", this.authorizeAttr.isDataConnectionAuthority());
        hashMap.put("isAdmin", l == -999L);
        hashMap.put("roots", this.getRootInfo(l).toString());
        hashMap.put("isTableDataUser", this.control.getControlType() == 1);
        hashMap.put("supportModules", new JSONArray((Object)PlateFactory.supportModules()));
        hashMap.put("ismobilebinddev", String.valueOf(this.isMobileDeviceBinding()));
        hashMap.put("departmentAllID", CompanyRoleControl.getInstance().getDepartmentAllID());
        hashMap.put("postAllID", CompanyRoleControl.getInstance().getPostAllID());
        hashMap.put("userLimit", this.getUserLimit());
        hashMap.put("mobileUserAuthLimit", this.getMobileUserAuthLimit());
        hashMap.put("theme", this.theme.createJSONObject());
        if (this.authorizeAttr != null) {
            this.authorizeAttr.fillAttrToMap(hashMap);
        }
        if (this.systemStyle != null) {
            this.systemStyle.fillAttrToMap(hashMap);
        }
        if (this.systemAttr != null) {
            this.systemAttr.fillAttrToMap(hashMap);
        }
        return hashMap;
    }

    public JSONObject getRootInfo(long l) throws Exception {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("modules", (Object)ModuleControl.getInstance().getModuleRootShowInfo(l));
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.userDeviceMap.clear();
            this.readAttr(xMLableReader);
        }
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("UerDataControl".equals(string)) {
                int n = xMLableReader.getAttrAsInt("type", 0);
                this.control = UserDataControlFactory.create(n);
                xMLableReader.readXMLObject((XMLReadable)this.control);
                this.control.init();
            } else if (ComparatorUtils.equals((Object)"systemManagerFavoriteAndADHOCReport", (Object)string)) {
                xMLableReader.readXMLObject((XMLReadable)this.sysManagerFvAndAD);
                this.sysManagerFvAndAD.init();
            } else if ("UserDevice".equals(string)) {
                UserDevice userDevice = new UserDevice();
                userDevice.readXML(xMLableReader);
                this.userDeviceMap.put(userDevice.getUsername(), userDevice);
            } else if ("AuthenticateObjectType".equals(string)) {
                this.authenticateObjectType = (AuthenticateObjectType)GeneralXMLTools.readXMLable((XMLableReader)xMLableReader);
            } else if (string.equals("SystemAttr")) {
                this.systemAttr = new SystemAttr();
                this.systemAttr.readXML(xMLableReader);
            } else if (string.equals("AuthorizeAttr")) {
                this.authorizeAttr = new AuthorizeAttr();
                this.authorizeAttr.readXML(xMLableReader);
            } else if ("fstheme".equals(string)) {
                this.theme = new Theme();
                this.theme.readXML(xMLableReader);
            } else if ("SystemStyle".equals(string)) {
                this.systemStyle = new SystemStyle();
                this.systemStyle.readXML(xMLableReader);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.attr("useFS", this.useFS);
        xMLPrintWriter.attr("mobileDeviceBinding", this.mobileDeviceBinding);
        this.writeSMFavoriteAndADHOCReportXML(xMLPrintWriter);
        xMLPrintWriter.end();
        this.writeMobileUserDevices(xMLPrintWriter);
        this.writeAuthenticateObjectType(xMLPrintWriter);
        this.writeSystemAttr(xMLPrintWriter);
        this.writeAuthorizeAttr(xMLPrintWriter);
        if (this.control != null) {
            xMLPrintWriter.startTAG("UerDataControl");
            xMLPrintWriter.attr("type", this.control.getControlType());
            this.control.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        if (this.theme != null) {
            this.theme.writeXML(xMLPrintWriter);
        }
        if (this.systemStyle != null) {
            this.systemStyle.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    private void readAttr(XMLableReader xMLableReader) {
        this.useFS = xMLableReader.getAttrAsBoolean("useFS", false);
        int n = xMLableReader.getAttrAsInt("controlType", 0);
        this.control = n == 1 ? TableDataDAOControl.getInstance() : HSQLDBDAOControl.getInstance();
        this.setNeedUpdate(xMLableReader.getXMLVersion().needVersionUpdate());
        this.setMobileDeviceBinding(xMLableReader.getAttrAsBoolean("mobileDeviceBinding", false));
        this.setXmlVersion(xMLableReader.getAttrAsLong("xmlVersion", 0L));
    }

    private void writeSystemAttr(XMLPrintWriter xMLPrintWriter) {
        if (this.systemAttr != null) {
            this.systemAttr.writeXML(xMLPrintWriter);
        }
    }

    private void writeAuthorizeAttr(XMLPrintWriter xMLPrintWriter) {
        if (this.authorizeAttr != null) {
            this.authorizeAttr.writeXML(xMLPrintWriter);
        }
    }

    private void writeAuthenticateObjectType(XMLPrintWriter xMLPrintWriter) {
        if (this.authenticateObjectType != null) {
            GeneralXMLTools.writeXMLable((XMLPrintWriter)xMLPrintWriter, (XMLable)this.authenticateObjectType, (String)"AuthenticateObjectType");
        }
    }

    private void writeMobileUserDevices(XMLPrintWriter xMLPrintWriter) {
        for (String string : this.userDeviceMap.keySet()) {
            this.userDeviceMap.get(string).writeXML(xMLPrintWriter);
        }
    }

    private void writeSMFavoriteAndADHOCReportXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("systemManagerFavoriteAndADHOCReport");
        this.sysManagerFvAndAD.writeXML(xMLPrintWriter);
    }

    static {
        GeneralContext.addEnvChangedListener((EnvChangedListener)new EnvChangedListener(){

            public void envChanged() {
                SC = null;
            }
        });
        byte[] byArray = StableUtils.getBytes();
        try {
            if (byArray != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                LicUtils.decode((byte[])byArray, (OutputStream)byteArrayOutputStream);
                String string = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
                JSONObject jSONObject = new JSONObject(string);
                if (jSONObject.getLong("DEADLINE") > Calendar.getInstance().getTimeInMillis()) {
                    userLimit = Math.max(0, jSONObject.optInt("FS_USER"));
                    mobileUserAuthLimit = Math.max(0, jSONObject.optInt("MOBILE_FS_USER"));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

