/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.jpa.table;

import com.force.sdk.jpa.PersistenceUtils;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.InheritanceStrategy;

public final class TableName {
    private static final String NAME_SEPARATOR = "__";
    private final String name;
    private final boolean isCustom;
    private final Type type;
    private final String namespace;

    public static TableName createTableName(String namespace, AbstractClassMetaData acmd) {
        String tableName = null;
        if (acmd.getTable() != null) {
            tableName = acmd.getTable();
        }
        if (tableName == null && acmd.getInheritanceMetaData() != null && acmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUPERCLASS_TABLE) {
            AbstractClassMetaData sacmd;
            while ((sacmd = acmd.getSuperAbstractClassMetaData()) != null) {
                acmd = sacmd;
                if (acmd.getTable() == null) continue;
                tableName = acmd.getTable();
                break;
            }
        }
        if (tableName != null) {
            return new TableName(namespace, tableName, true);
        }
        return new TableName(namespace, PersistenceUtils.getEntityName(acmd), false);
    }

    private TableName(String namespace, String fullName, boolean parseForSuffix) {
        if (parseForSuffix) {
            String[] tokens = fullName.split(NAME_SEPARATOR);
            if (tokens.length > 3) {
                throw new NucleusUserException("Could not parse table: " + fullName);
            }
            switch (tokens.length) {
                case 1: {
                    this.type = Type.Standard;
                    this.name = fullName;
                    this.namespace = namespace;
                    break;
                }
                case 2: {
                    String suffix = tokens[1].toLowerCase();
                    this.type = Type.parse(suffix);
                    this.name = tokens[0];
                    this.namespace = namespace;
                    break;
                }
                default: {
                    String suf = tokens[2].toLowerCase();
                    this.type = Type.parse(suf);
                    this.namespace = tokens[0];
                    this.name = tokens[1];
                    break;
                }
            }
        } else {
            this.type = Type.Custom;
            this.name = fullName;
            this.namespace = namespace;
        }
        this.isCustom = this.type != Type.Standard;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getForceApiName() {
        if (this.isCustom) {
            return PersistenceUtils.prependNamespace(this.namespace, String.format("%s__%s", this.name, this.type.suffix));
        }
        return this.name;
    }

    public boolean isCustom() {
        return this.isCustom;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return this.getName();
    }

    public static enum Type {
        Standard(""),
        Custom("c"),
        CustomRelationship("r"),
        CustomComponent("s"),
        KnowledgeArticle("ka"),
        KnowledgeArticleVersion("kav"),
        Feed("feed");

        private String suffix;

        private Type(String suffix) {
            this.suffix = suffix;
        }

        String getSuffix() {
            return this.suffix;
        }

        static Type parse(String suffix) {
            switch (suffix.length()) {
                case 1: {
                    if (suffix.equals(Type.Custom.suffix)) {
                        return Custom;
                    }
                    if (suffix.equals(Type.CustomRelationship.suffix)) {
                        return CustomRelationship;
                    }
                    if (!suffix.equals(Type.CustomComponent.suffix)) break;
                    return CustomComponent;
                }
                case 2: {
                    if (!suffix.equals(Type.KnowledgeArticle.suffix)) break;
                    return KnowledgeArticle;
                }
                default: {
                    if (suffix.equals(Type.KnowledgeArticleVersion.suffix)) {
                        return KnowledgeArticleVersion;
                    }
                    if (!suffix.equals(Type.Feed.suffix)) break;
                    return Feed;
                }
            }
            throw new NucleusUserException("Unsupported custom object suffix: " + suffix);
        }
    }
}

