/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.jpa.table;

import com.force.sdk.jpa.ForceManagedConnection;
import com.force.sdk.jpa.ForceStoreManager;
import com.force.sdk.jpa.PersistenceUtils;
import com.force.sdk.jpa.table.ColumnImpl;
import com.force.sdk.jpa.table.ForceTableMetaData;
import com.force.sdk.jpa.table.RelationshipImpl;
import com.force.sdk.jpa.table.TableName;
import com.sforce.soap.partner.ChildRelationship;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.Field;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.soap.partner.fault.InvalidSObjectFault;
import com.sforce.ws.ConnectionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Table;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;

public class TableImpl {
    private final Map<String, ColumnImpl> forceApiColumns;
    private final Map<String, ColumnImpl> javaColumns;
    private final List<ColumnImpl> columnList;
    private final TableName tableName;
    private boolean isValid;
    private ColumnImpl externalId;
    private final String defaultNamespace;
    private boolean created;
    private ForceTableMetaData tableMetaData;
    private boolean tableAlreadyExistsInOrg;

    public TableImpl(String defaultNamespace, TableName tableName, DescribeSObjectResult result, ForceManagedConnection mconn) {
        this.defaultNamespace = defaultNamespace;
        this.tableName = tableName;
        this.columnList = new ArrayList<ColumnImpl>();
        this.forceApiColumns = new HashMap<String, ColumnImpl>();
        this.refresh(result, mconn);
        this.javaColumns = new HashMap<String, ColumnImpl>(this.forceApiColumns.size() == 0 ? 4 : this.forceApiColumns.size());
    }

    public TableImpl(TableName tableName, AbstractClassMetaData acmd) {
        this.defaultNamespace = "";
        this.tableName = tableName;
        AbstractMemberMetaData[] ammds = acmd.getManagedMembers();
        this.columnList = new ArrayList<ColumnImpl>(ammds.length);
        this.forceApiColumns = new HashMap<String, ColumnImpl>(ammds.length);
        for (AbstractMemberMetaData ammd : acmd.getManagedMembers()) {
            String fieldName = PersistenceUtils.getFieldNameFromJPAAnnotation(ammd);
            if (fieldName == null) {
                throw new NucleusUserException("All fields in a virtual schema object must specify their name through @Column. Offending field: " + ammd.getName() + " on object " + acmd.getName());
            }
            ColumnImpl col = new ColumnImpl(fieldName, null);
            this.columnList.add(col);
            this.forceApiColumns.put(ammd.getName(), col);
        }
        this.javaColumns = new HashMap<String, ColumnImpl>(this.forceApiColumns.size());
        this.isValid = true;
        this.tableAlreadyExistsInOrg = true;
    }

    TableImpl(String defaultNamespace, TableName tableName, List<ColumnImpl> columnList, Map<String, ColumnImpl> forceApiColumns, ColumnImpl externalId) {
        this.defaultNamespace = defaultNamespace;
        this.tableName = tableName;
        this.columnList = columnList;
        this.forceApiColumns = forceApiColumns;
        this.externalId = externalId;
        this.javaColumns = new HashMap<String, ColumnImpl>(forceApiColumns == null ? 0 : forceApiColumns.size());
        this.isValid = true;
        this.tableAlreadyExistsInOrg = true;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setIsValid(boolean isValid) {
        this.isValid = isValid;
    }

    public boolean exists() {
        return this.tableAlreadyExistsInOrg || this.created;
    }

    public ColumnImpl getExternalIdColumn() {
        return this.externalId;
    }

    public ColumnImpl getColumnByForceApiName(String columnName) {
        ColumnImpl col = this.forceApiColumns.get(columnName.toLowerCase());
        if (col == null) {
            col = this.forceApiColumns.get(PersistenceUtils.prependNamespace(this.defaultNamespace, columnName).toLowerCase());
        }
        return col;
    }

    public ColumnImpl getColumnByJavaName(String columnName) {
        return this.javaColumns.get(columnName.toLowerCase());
    }

    public void registerJavaColumn(String javaFieldName, ColumnImpl column) {
        this.javaColumns.put(javaFieldName.toLowerCase(), column);
    }

    public ColumnImpl getColumnAt(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columnList.size()) {
            throw new NucleusException("Column out of bounds");
        }
        return this.columnList.get(columnIndex);
    }

    public List<ColumnImpl> getListOfColumns() {
        return this.columnList;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public String toString() {
        return this.tableName.toString();
    }

    public List<ColumnImpl> getColumnsFor(AbstractClassMetaData acmd, AbstractMemberMetaData ammd, ForceStoreManager storeManager, List<ColumnImpl> columns) {
        if (ammd.getEmbeddedMetaData() != null) {
            for (AbstractMemberMetaData eammd : ammd.getEmbeddedMetaData().getMemberMetaData()) {
                this.getColumnsFor(acmd, eammd, storeManager, columns);
            }
        } else {
            columns.add(this.getColumnFor(acmd, ammd));
        }
        return columns;
    }

    public ColumnImpl getColumnAt(AbstractClassMetaData acmd, int fieldNumber) {
        return this.getColumnFor(acmd, acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
    }

    public ColumnImpl getColumnFor(AbstractClassMetaData acmd, AbstractMemberMetaData ammd) {
        if (PersistenceUtils.isNonPersistedColumn(ammd)) {
            return null;
        }
        ColumnImpl ret = this.getColumnByJavaName(ammd.getName());
        if (ret != null) {
            return ret;
        }
        try {
            String renamedField;
            Table tab = ammd.getType().getAnnotation(Table.class);
            if (tab != null && (renamedField = tab.name()) != null && renamedField.length() > 0) {
                ret = this.getColumnByForceApiName(renamedField);
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        if (ret == null) {
            throw new NucleusUserException(String.format("Field name: %s not found in Force.com object: %s", ammd.getName(), this.getTableName().getForceApiName()));
        }
        return ret;
    }

    public String getPKFieldName(AbstractClassMetaData acmd) {
        ColumnImpl col = this.getColumnAt(acmd, acmd.getPKMemberPositions()[0]);
        return col != null ? col.getFieldName() : "id";
    }

    public void createTableAndFields(AbstractClassMetaData cmd, ForceStoreManager storeManager, ForceManagedConnection mconn) {
        if (!this.created) {
            this.getMetaData(cmd).createCustomObject(cmd, storeManager, mconn);
        }
        this.createFields(cmd, storeManager);
        this.created = true;
    }

    public void createFields(AbstractClassMetaData cmd, ForceStoreManager storeManager) {
        this.getMetaData(cmd).createCustomFields(cmd, storeManager);
    }

    public void refresh(DescribeSObjectResult result, ForceManagedConnection mconn) {
        boolean valid = result != null;
        try {
            ChildRelationship[] relationships;
            if (!valid) {
                result = ((PartnerConnection)mconn.getConnection()).describeSObject(this.tableName.getForceApiName());
            }
            for (Field field : result.getFields()) {
                String columnName = field.getName().toLowerCase();
                ColumnImpl column = new ColumnImpl(columnName, field);
                this.columnList.add(column);
                this.forceApiColumns.put(columnName, column);
                if (!field.isExternalId()) continue;
                this.externalId = column;
            }
            for (ChildRelationship cr : relationships = result.getChildRelationships()) {
                String relationshipName = cr.getRelationshipName();
                if (relationshipName == null) continue;
                RelationshipImpl column = new RelationshipImpl(relationshipName);
                this.columnList.add(column);
                this.forceApiColumns.put(relationshipName.toLowerCase(), column);
            }
            valid = true;
        }
        catch (InvalidSObjectFault ie) {
            valid = false;
        }
        catch (ConnectionException x) {
            throw new NucleusException(x.getMessage(), (Throwable)x);
        }
        this.isValid = valid;
        this.tableAlreadyExistsInOrg = valid;
    }

    public boolean getTableAlreadyExistsInOrg() {
        return this.tableAlreadyExistsInOrg;
    }

    public ForceTableMetaData getMetaData(AbstractClassMetaData cmd) {
        if (this.tableMetaData == null) {
            this.tableMetaData = new ForceTableMetaData(cmd, this);
        }
        return this.tableMetaData;
    }

    void clearMetaData() {
        this.tableMetaData = null;
    }
}

