/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.jpa.table;

import com.force.sdk.jpa.ForceManagedConnection;
import com.force.sdk.jpa.ForceStoreManager;
import com.force.sdk.jpa.PersistenceUtils;
import com.force.sdk.jpa.schema.ForceSchemaWriter;
import com.force.sdk.jpa.table.ForceColumnMetaData;
import com.force.sdk.jpa.table.ForceMetaData;
import com.force.sdk.jpa.table.TableImpl;
import com.sforce.soap.metadata.CustomField;
import com.sforce.soap.metadata.DeploymentStatus;
import com.sforce.soap.metadata.FieldType;
import com.sforce.soap.metadata.SharingModel;
import java.util.Map;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.MetaData;

public class ForceTableMetaData
extends ForceMetaData {
    public ForceTableMetaData(AbstractClassMetaData cmd, TableImpl tableImpl) {
        super(cmd, tableImpl);
    }

    public void emit(ForceStoreManager storeManager, ForceManagedConnection mconn) {
        try {
            ForceSchemaWriter schemaWriter = storeManager.getSchemaWriter();
            if (this.customObject != null) {
                schemaWriter.addCustomObject(this.customObject, this.cmd, storeManager, this);
                for (CustomField field : this.customObject.getFields()) {
                    schemaWriter.addCustomField(this.customObject, field);
                }
                this.customObject = null;
            }
        }
        catch (Exception x) {
            throw new NucleusException(x.getMessage(), (Throwable)x);
        }
        this.tableImpl.clearMetaData();
    }

    public void createCustomObject(AbstractClassMetaData cmd, ForceStoreManager storeManager, ForceManagedConnection mconn) {
        String shortName = this.removeCustomThingSuffix(this.tableImpl.getTableName().getName());
        if (this.isReadOnlyTable) {
            throw new NucleusUserException("Cannot create readOnlySchema custom object: " + shortName);
        }
        this.createCustomObjectStub();
        this.customObject.setDescription(shortName + ": Persistenceforce created custom object");
        this.customObject.setDeploymentStatus(DeploymentStatus.Deployed);
        this.customObject.setSharingModel(SharingModel.ReadWrite);
        this.customObject.setLabel(shortName);
        this.customObject.setPluralLabel(shortName);
        CustomField nf = new CustomField();
        nf.setType(FieldType.Text);
        nf.setLabel("name");
        nf.setFullName("name");
        nf.setDescription("name");
        this.customObject.setNameField(nf);
        Map<String, String> classExtensions = PersistenceUtils.getForceExtensions((MetaData)cmd);
        String value = classExtensions.get("enableFeeds");
        if (value != null) {
            this.customObject.setEnableFeeds(Boolean.valueOf(value).booleanValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCustomFields(AbstractClassMetaData cmd, ForceStoreManager storeManager) {
        AbstractClassMetaData abstractClassMetaData = cmd;
        synchronized (abstractClassMetaData) {
            try {
                if (cmd.isEmbeddedOnly() || PersistenceUtils.isReadOnlySchema(cmd, false)) {
                    return;
                }
                ForceManagedConnection mconn = storeManager.createConnection();
                try {
                    ForceColumnMetaData cols = new ForceColumnMetaData(cmd, this.tableImpl, storeManager);
                    cols.createFieldSchema(mconn.getNamespace());
                    if (this.customObject == null) {
                        this.createCustomObjectStub();
                    }
                    cols.addFieldsToObject(this.customObject);
                }
                catch (NucleusException ce) {
                    throw ce;
                }
                catch (Exception e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
                finally {
                    mconn.close();
                }
            }
            catch (Exception e) {
                throw new NucleusUserException("Exception during initialisation of metadata for " + cmd.getFullClassName(), (Throwable)e);
            }
        }
    }
}

