/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.jpa.table;

import com.force.sdk.jpa.PersistenceUtils;
import com.force.sdk.jpa.schema.ForceAsyncResultProcessor;
import com.force.sdk.jpa.table.TableImpl;
import com.sforce.soap.metadata.CustomObject;
import com.sforce.soap.metadata.TreatBlanksAs;
import java.util.Map;
import org.datanucleus.metadata.AbstractClassMetaData;

public abstract class ForceMetaData
extends ForceAsyncResultProcessor {
    protected CustomObject customObject;
    protected TableImpl tableImpl;
    protected final AbstractClassMetaData cmd;
    protected final boolean isReadOnlyTable;
    protected final boolean isReadOnlyFields;

    public ForceMetaData(AbstractClassMetaData cmd, TableImpl tableImpl) {
        this.cmd = cmd;
        this.tableImpl = tableImpl;
        this.isReadOnlyFields = PersistenceUtils.isReadOnlySchema(cmd, false);
        this.isReadOnlyTable = this.isReadOnlyFields ? true : PersistenceUtils.isReadOnlySchema(cmd, true);
    }

    protected String removeCustomThingSuffix(String name) {
        return name.toLowerCase().endsWith("__c") ? name.substring(0, name.length() - "__c".length()) : name;
    }

    protected TreatBlanksAs getTreatBlanksAsFromForceAnnotation(Map<String, String> extensions) {
        String value = extensions.get("treatBlanksAs");
        return value != null ? TreatBlanksAs.valueOf((String)value) : null;
    }

    protected Integer getIntegerFromForceAnnotation(Map<String, String> extensions, String key) {
        String value = extensions.get(key);
        return value != null ? Integer.valueOf(value) : null;
    }

    protected boolean getBooleanFromForceAnnotation(Map<String, String> extensions, String key) {
        String value = extensions.get(key);
        return value != null ? Boolean.valueOf(value) : false;
    }

    protected void createCustomObjectStub() {
        String apiName = this.tableImpl.getTableName().getForceApiName();
        this.customObject = new CustomObject();
        this.customObject.setFullName(apiName);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Creating custom object: " + apiName);
        }
    }

    public boolean getIsReadOnlyTable() {
        return this.isReadOnlyTable;
    }

    public TableImpl getTableImpl() {
        return this.tableImpl;
    }
}

