/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.jpa.table;

import com.force.sdk.jpa.ForceStoreManager;
import com.force.sdk.jpa.PersistenceUtils;
import com.force.sdk.jpa.schema.ForceMemberMetaData;
import com.force.sdk.jpa.schema.ForceStoreSchemaHandler;
import com.force.sdk.jpa.table.ForceMetaData;
import com.force.sdk.jpa.table.TableImpl;
import com.force.sdk.jpa.table.TableName;
import com.sforce.soap.metadata.CustomField;
import com.sforce.soap.metadata.CustomObject;
import com.sforce.soap.metadata.FieldType;
import com.sforce.soap.metadata.Picklist;
import com.sforce.soap.metadata.PicklistValue;
import com.sforce.soap.metadata.TreatBlanksAs;
import com.sforce.ws.types.Time;
import java.lang.reflect.AccessibleObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.datanucleus.OMFContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.MetaData;

public class ForceColumnMetaData
extends ForceMetaData {
    private static final Pattern PICK_PATTERN = Pattern.compile(",");
    public static final Set<String> STANDARD_FIELDS = new HashSet<String>(Arrays.asList("id", "name", "ownerid", "isdeleted", "createdbyid", "createddate", "lastmodifiedbyid", "lastmodifieddate", "systemmodstamp"));
    private final List<AbstractMemberMetaData> fieldsToAdd = new ArrayList<AbstractMemberMetaData>();
    private final ForceStoreManager storeManager;
    private final String fieldFormatString;
    private final List<CustomField> fields = new ArrayList<CustomField>();

    public ForceColumnMetaData(AbstractClassMetaData cmd, TableImpl table, ForceStoreManager storeManager) {
        super(cmd, table);
        this.fieldFormatString = this.tableImpl.getTableName().getForceApiName() + ".%s";
        this.storeManager = storeManager;
    }

    public void addFieldsToObject(CustomObject customObject) {
        if (this.fields.size() > 0) {
            Collection<CustomField> mergedResult = this.mergeFields(customObject.getFields(), this.fields);
            customObject.setFields(mergedResult.toArray(new CustomField[mergedResult.size()]));
            this.fields.clear();
        }
    }

    private Collection<CustomField> mergeFields(CustomField[] existing, List<CustomField> toAdd) {
        if (existing == null || existing.length == 0) {
            return toAdd;
        }
        HashMap<String, CustomField> result = new HashMap<String, CustomField>();
        for (CustomField cf : existing) {
            result.put(String.format(this.fieldFormatString, cf.getFullName()), cf);
        }
        for (CustomField cf : toAdd) {
            result.put(String.format(this.fieldFormatString, cf.getFullName()), cf);
        }
        return result.values();
    }

    public void createFieldSchema(String namespace) {
        this.updateListOfMissingFields();
        if (this.fieldsToAdd.size() > 0) {
            if (this.storeManager.isAutoCreateColumns()) {
                List<AbstractClassMetaData> invalidateList = this.createColumns(namespace);
                for (AbstractClassMetaData tcmd : invalidateList) {
                    this.storeManager.getTable(tcmd).setIsValid(false);
                }
            } else {
                StringBuilder msg = new StringBuilder(1024);
                msg.append("Field does not exist in force.com table and datanucleus.autoCreateColumns is false, entity: ").append(this.cmd.getName()).append(" table: ").append(this.tableImpl.getTableName().getForceApiName()).append(" fields: [");
                int count = 0;
                for (AbstractMemberMetaData ammd : this.fieldsToAdd) {
                    if (count++ > 0) {
                        msg.append(", ");
                    }
                    msg.append(ammd.getName());
                }
                msg.append("]");
                if (this.storeManager.isAutoCreateWarnOnError()) {
                    LOGGER.warn(msg.toString());
                } else {
                    throw new NucleusUserException(msg.toString());
                }
            }
        }
    }

    private void validateColumn(AbstractMemberMetaData ammd, OMFContext omf) {
        FieldType type;
        Map<String, String> extensions = PersistenceUtils.getForceExtensions((MetaData)ammd);
        FieldType fieldType = PersistenceUtils.getFieldTypeFromForceAnnotation(extensions);
        AccessibleObject ao = (AccessibleObject)((Object)ammd.getMemberRepresented());
        if (ao.isAnnotationPresent(OneToOne.class)) {
            throw new NucleusUserException("@OneToOne relationship is not supported. Please combine fields into a single object. Offending field: " + ammd.getFullFieldName());
        }
        if (ao.isAnnotationPresent(OneToMany.class)) {
            Basic b;
            if (ammd.getMappedBy() == null) {
                throw new NucleusUserException("@OneToMany relationship requires the 'mappedBy' attribute. Please add a foreign key field on child object and use that field name for mappedBy attribute. Offending field: " + ammd.getFullFieldName());
            }
            if (ao.getAnnotation(OneToMany.class).fetch() == FetchType.EAGER || (b = ao.getAnnotation(Basic.class)) != null && b.fetch() == FetchType.EAGER) {
                throw new NucleusUserException("@OneToMany relationships with FetchType of EAGER are currently not supported.");
            }
        } else if (ao.isAnnotationPresent(ManyToMany.class)) {
            throw new NucleusUserException("@ManyToMany relationship is not supported. Please use a junction object with two @ManyToOne relationships. Offending field: " + ammd.getFullFieldName());
        }
        if (ammd.getJoinMetaData() != null) {
            throw new NucleusUserException("@JoinTable is not supported. Offending field: " + ammd.getFullFieldName());
        }
        if (ammd.getColumnMetaData() != null && ammd.getColumnMetaData().length > 0) {
            for (ColumnMetaData md : ammd.getColumnMetaData()) {
                if (md.getTarget() != null && !md.getTarget().equalsIgnoreCase("id")) {
                    throw new NucleusUserException("Referenced foreign key colum name must be 'ID'. Offending field: " + ammd.getFullFieldName());
                }
                if (!"CLOB".equals(md.getJdbcType())) continue;
                throw new NucleusUserException("@Clob field type is not supported. Offending field: " + ammd.getFullFieldName());
            }
            if (ammd.getTable() != null) {
                throw new NucleusUserException("Table cannot be specified at a column level. Offending field: " + ammd.getFullFieldName());
            }
        }
        if (!(FieldType.Picklist != fieldType && !ao.isAnnotationPresent(Enumerated.class) || ammd.getType().isEnum() || ammd.getType().isArray() && ammd.getType().getComponentType().isEnum())) {
            if (ammd.getType() != String.class && ammd.getType() != String[].class) {
                throw new NucleusUserException("Non-strict picklist can be of type String or String[] only. Offending field: " + ammd.getFullFieldName());
            }
            String allValues = extensions.get("pv.value");
            if (allValues == null) {
                throw new NucleusUserException("Non-strict picklist requires @PicklistValue annotation. Offending field: " + ammd.getFullFieldName());
            }
            if (PersistenceUtils.isOrdinalEnum(ammd)) {
                throw new NucleusUserException("Non-strict picklist does not support EnumType.ORDINAL. Offending field: " + ammd.getFullFieldName());
            }
        }
        if ((ammd.getCollection() != null || ammd.getMap() != null) && (type = PersistenceUtils.getFieldTypeFromForceAnnotation(PersistenceUtils.getForceExtensions((MetaData)ammd.getRelatedMemberMetaData(omf.getClassLoaderResolver(null))[0]))) != null && type == FieldType.MasterDetail) {
            if (ammd.getCollection() != null) {
                ammd.getCollection().setDependentElement(false);
            } else if (ammd.getMap() != null) {
                ammd.getMap().setDependentValue(false);
            }
        }
    }

    private void updateListOfMissingFields() {
        for (AbstractMemberMetaData ammd : this.findAllFields()) {
            this.validateColumn(ammd, this.storeManager.getOMFContext());
            AbstractClassMetaData relatedEntity = this.storeManager.getMetaDataManager().getMetaDataForEntityName(ammd.getType().getSimpleName());
            if (relatedEntity != null && relatedEntity.isEmbeddedOnly()) {
                for (AbstractMemberMetaData eammd : ammd.getEmbeddedMetaData().getMemberMetaData()) {
                    this.addFieldToListIfAbsent(eammd, this.storeManager);
                }
                continue;
            }
            this.addFieldToListIfAbsent(ammd, this.storeManager);
        }
        if (this.cmd.getSuperAbstractClassMetaData() == null && this.cmd.getDiscriminatorMetaData() != null && this.cmd.getDiscriminatorMetaData().getColumnMetaData() != null) {
            ColumnMetaData colmd = this.cmd.getDiscriminatorMetaData().getColumnMetaData();
            this.addFieldToListIfAbsent(new ForceMemberMetaData((MetaData)colmd, colmd.getName()){

                public Class<?> getType() {
                    return String.class;
                }
            }, this.storeManager);
        }
    }

    private List<AbstractMemberMetaData> findAllFields() {
        ArrayList<AbstractMemberMetaData> allFields = new ArrayList<AbstractMemberMetaData>();
        AbstractMemberMetaData[] membersInThisClass = this.cmd.getManagedMembers();
        if (membersInThisClass != null) {
            allFields.addAll(Arrays.asList(membersInThisClass));
        }
        for (AbstractClassMetaData superClassMD = this.cmd.getSuperAbstractClassMetaData(); superClassMD != null && superClassMD.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE; superClassMD = superClassMD.getSuperAbstractClassMetaData()) {
            AbstractMemberMetaData[] membersInSuperClass = superClassMD.getManagedMembers();
            if (membersInSuperClass == null) continue;
            allFields.addAll(Arrays.asList(membersInSuperClass));
        }
        return allFields;
    }

    private void addFieldToListIfAbsent(AbstractMemberMetaData ammd, ForceStoreManager storeMgr) {
        if (PersistenceUtils.isNonPersistedColumn(ammd)) {
            return;
        }
        if (!this.tableImpl.isValid() || this.storeManager.isForDelete() || this.tableImpl.getColumnByForceApiName(PersistenceUtils.getForceApiName(ammd, this.storeManager.getOMFContext())) == null) {
            this.fieldsToAdd.add(ammd);
        }
    }

    private List<AbstractClassMetaData> createColumns(String namespace) {
        ArrayList<AbstractClassMetaData> ret = new ArrayList<AbstractClassMetaData>();
        if (this.fieldsToAdd != null && this.fieldsToAdd.size() > 0) {
            ret.add(this.cmd);
            for (int column = 0; column < this.fieldsToAdd.size(); ++column) {
                TableName columnTypeName;
                AbstractMemberMetaData ammd = this.fieldsToAdd.get(column);
                if (Collection.class.isAssignableFrom(ammd.getType()) || Map.class.isAssignableFrom(ammd.getType())) continue;
                Map<String, String> extensions = PersistenceUtils.getForceExtensions((MetaData)ammd);
                String fieldName = PersistenceUtils.getForceApiName(ammd, this.storeManager.getOMFContext());
                AbstractClassMetaData relatedClass = ammd.getType() != null ? this.storeManager.getMetaDataManager().getMetaDataForClass(ammd.getType(), this.storeManager.getOMFContext().getClassLoaderResolver(null)) : null;
                ColumnMetaData[] colmds = ammd.getColumnMetaData();
                ColumnMetaData colmd = null;
                FieldType type = PersistenceUtils.getFieldTypeFromForceAnnotation(extensions);
                Integer scale = this.getIntegerFromForceAnnotation(extensions, "scale");
                Integer precision = this.getIntegerFromForceAnnotation(extensions, "precision");
                Integer length = this.getIntegerFromForceAnnotation(extensions, "length");
                Integer startValue = this.getIntegerFromForceAnnotation(extensions, "startValue");
                boolean enableFeeds = this.getBooleanFromForceAnnotation(extensions, "enableFeeds");
                boolean externalId = this.getBooleanFromForceAnnotation(extensions, "externalId");
                String childRelationshipName = extensions.get("childRelationshipName");
                String label = extensions.get("label");
                String description = extensions.get("description");
                String formula = extensions.get("formula");
                TreatBlanksAs treatBlanksAs = this.getTreatBlanksAsFromForceAnnotation(extensions);
                boolean allowNulls = true;
                boolean unique = false;
                if (colmds != null && colmds.length > 0) {
                    colmd = colmds[0];
                    if (type == null) {
                        type = this.getFieldType(colmd, ammd);
                    }
                    if (precision == null) {
                        scale = colmd.getScale();
                        precision = colmd.getLength();
                    }
                    if (length == null) {
                        length = colmd.getLength();
                    }
                    if (!(allowNulls = colmd.getAllowsNull().booleanValue())) {
                        Column columnAnnotation = PersistenceUtils.getMemberAnnotation(ammd.getMemberRepresented(), Column.class);
                        allowNulls = columnAnnotation != null ? columnAnnotation.nullable() : true;
                    }
                    unique = colmd.getUnique();
                }
                if (startValue != null && type != FieldType.AutoNumber) {
                    throw new NucleusUserException("startValue attribute is only supported for AutoNumber fields types, field: " + ammd.getName() + " on entity: " + this.tableImpl.getTableName().getName());
                }
                if (type == null && PersistenceUtils.isRelationship(ammd)) {
                    type = FieldType.Lookup;
                }
                if (STANDARD_FIELDS.contains(fieldName.toLowerCase())) continue;
                boolean isLookupToStandardObject = false;
                if (type == FieldType.Lookup || type == FieldType.MasterDetail) {
                    if (relatedClass == null) {
                        throw new NucleusDataStoreException("Undefined entity type for field: " + ammd.getName() + " on entity: " + this.tableImpl.getTableName().getName());
                    }
                    TableImpl table1 = ((ForceStoreSchemaHandler)this.storeManager.getSchemaHandler()).getTable(relatedClass);
                    isLookupToStandardObject = !table1.getTableName().isCustom();
                    ret.add(relatedClass);
                }
                TableName tableName = columnTypeName = relatedClass != null ? TableName.createTableName(namespace, relatedClass) : null;
                if (isLookupToStandardObject) {
                    fieldName = this.removeCustomThingSuffix(fieldName);
                }
                CustomField field = new CustomField();
                if (type != null) {
                    field.setType(type);
                } else {
                    this.setFieldType(field, ammd);
                }
                this.setOtherValues(field, length, precision, scale, ammd, columnTypeName, fieldName, this.tableImpl.getTableName().getName(), childRelationshipName, formula, extensions);
                field.setTrackFeedHistory(enableFeeds);
                field.setExternalId(externalId);
                if (isLookupToStandardObject) {
                    field.setFullName(String.format("%s%s", fieldName, "__c"));
                } else {
                    field.setFullName(fieldName);
                }
                field.setLabel(label != null ? label : fieldName);
                field.setDescription(description != null ? description : field.getLabel());
                if (!allowNulls) {
                    field.setRequired(true);
                }
                if (unique || ammd.isUnique()) {
                    field.setUnique(true);
                }
                if (startValue != null) {
                    field.setStartingNumber(startValue.intValue());
                }
                if (formula != null) {
                    field.setFormula(formula);
                    field.setFormulaTreatBlanksAs(treatBlanksAs);
                }
                this.addField(field);
            }
        }
        return ret;
    }

    private void addField(CustomField field) {
        if (this.isReadOnlyFields) {
            throw new NucleusUserException("Cannot add custom field: " + field.getFullName() + " to readOnlySchema object: " + this.tableImpl.getTableName().getName());
        }
        this.fields.add(field);
    }

    private FieldType getFieldType(ColumnMetaData md, AbstractMemberMetaData ammd) {
        String type;
        if (PersistenceUtils.isRelationship(ammd)) {
            return FieldType.Lookup;
        }
        Class clazzType = ammd.getType();
        if (clazzType.isEnum()) {
            return FieldType.Picklist;
        }
        String string = type = md.getJdbcType() != null ? md.getJdbcType() : md.getSqlType();
        if (type == null) {
            return null;
        }
        if ((type = type.toLowerCase()).equals("varchar")) {
            return FieldType.Text;
        }
        if (type.equals("integer") || type.equals("number") || type.equals("numeric")) {
            return FieldType.Number;
        }
        if (type.equals("date")) {
            return FieldType.Date;
        }
        if (type.equals("timestamp") || type.equals("time")) {
            return FieldType.DateTime;
        }
        if (type.equals("boolean")) {
            return FieldType.Checkbox;
        }
        if (type.equals("clob")) {
            return FieldType.LongTextArea;
        }
        throw new NucleusUserException("Unsupported column type: " + type);
    }

    private void setFieldType(CustomField field, AbstractMemberMetaData ammd) {
        Class type = ammd.getType();
        if (type == String.class) {
            field.setType(FieldType.Text);
        } else if (type == Integer.class || type == Integer.TYPE || type == Long.class || type == Long.TYPE || type == Double.class || type == Double.TYPE || type == Float.class || type == Float.TYPE || type == Short.class || type == Short.TYPE || type == BigInteger.class) {
            field.setType(FieldType.Number);
        } else if (type == Date.class) {
            field.setType(FieldType.Date);
        } else if (type == Calendar.class || type == GregorianCalendar.class || type == Time.class) {
            field.setType(FieldType.DateTime);
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            field.setType(FieldType.Checkbox);
            field.setDefaultValue("false");
        } else if (type == BigDecimal.class) {
            field.setType(FieldType.Currency);
        } else if (type == URL.class) {
            field.setType(FieldType.Url);
        } else if (PersistenceUtils.isMultiPicklist(ammd)) {
            field.setType(FieldType.MultiselectPicklist);
            field.setVisibleLines(3);
        } else if (type == Byte.class || type == Byte.TYPE) {
            field.setType(FieldType.Text);
        } else if (type == Character.class || type == Character.TYPE) {
            field.setType(FieldType.Text);
        } else {
            throw new NucleusUserException("Unsupported column for Java type: " + type + " for entity: " + this.cmd.getName() + " field: " + ammd.getName());
        }
    }

    private void setOtherValues(CustomField field, Integer length, Integer precision, Integer scale, AbstractMemberMetaData ammd, TableName columnTypeName, String fieldName, String tableName, String childRelationshipName, String formula, Map<String, String> extensions) {
        Class type = ammd.getType();
        switch (field.getType()) {
            case Text: {
                if (formula != null) break;
                field.setLength(length != null ? length : 255);
                break;
            }
            case LongTextArea: 
            case Html: {
                field.setLength(length != null ? length : 32000);
                field.setVisibleLines(field.getType() == FieldType.Html ? 25 : 3);
                break;
            }
            case Number: 
            case Currency: 
            case Percent: {
                if (type == Integer.class || type == Integer.TYPE) {
                    field.setPrecision(11);
                    field.setScale(0);
                    break;
                }
                if (type == Long.class || type == Long.TYPE) {
                    field.setPrecision(18);
                    field.setScale(0);
                    break;
                }
                if (type == Double.class || type == Double.TYPE) {
                    field.setPrecision(16);
                    field.setScale(2);
                    break;
                }
                if (type == Float.class || type == Float.TYPE) {
                    field.setPrecision(16);
                    field.setScale(2);
                    break;
                }
                if (type == Short.class || type == Short.TYPE) {
                    field.setPrecision(6);
                    field.setScale(0);
                    break;
                }
                if (type == BigInteger.class) {
                    field.setPrecision(18);
                    field.setScale(0);
                    break;
                }
                if (type != BigDecimal.class) break;
                field.setPrecision(16);
                field.setScale(2);
                break;
            }
            case Picklist: {
                this.setPicklistType(field, type, extensions, PersistenceUtils.isOrdinalEnum(ammd));
                break;
            }
            case MultiselectPicklist: {
                this.setPicklistType(field, type.getComponentType(), extensions, PersistenceUtils.isOrdinalEnum(ammd));
                break;
            }
            case Lookup: 
            case MasterDetail: {
                String relationshipName;
                String fieldNameNoSuffix = fieldName;
                if (fieldName.endsWith("__c")) {
                    fieldNameNoSuffix = fieldName.substring(0, fieldName.lastIndexOf("__c"));
                }
                field.setReferenceTo(columnTypeName.getForceApiName());
                String string = relationshipName = childRelationshipName != null ? childRelationshipName : String.format("%s_%ss", fieldNameNoSuffix, tableName);
                if (relationshipName.length() > 40) {
                    relationshipName = relationshipName.substring(0, 40);
                }
                field.setRelationshipName(relationshipName);
                field.setRelationshipLabel(fieldNameNoSuffix);
                break;
            }
        }
    }

    private void setPicklistType(CustomField field, Class<?> type, Map<String, String> extensions, boolean isOrdinal) {
        String[] values;
        if (type == String.class || type == String[].class) {
            values = PICK_PATTERN.split(extensions.get("pv.value"));
        } else {
            ?[] enumConstants = type.getEnumConstants();
            values = new String[enumConstants.length];
            for (int i = 0; i < enumConstants.length; ++i) {
                values[i] = isOrdinal ? "" + i : ((Enum)enumConstants[i]).name();
            }
        }
        Picklist pick = new Picklist();
        PicklistValue[] picklistValues = new PicklistValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            PicklistValue pv = new PicklistValue();
            pv.setFullName(values[i]);
            picklistValues[i] = pv;
        }
        pick.setPicklistValues(picklistValues);
        field.setPicklist(pick);
    }
}

