/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.jpa.table;

import com.force.sdk.jpa.query.ExpressionBuilderHelper;
import com.sforce.soap.partner.Field;
import com.sforce.soap.partner.FieldType;
import org.datanucleus.metadata.AbstractClassMetaData;

public class ColumnImpl {
    public static final String CUSTOM_RELATIONSHIP_SUFFIX = "__r";
    public static final String CUSTOM_THING_SUFFIX = "__c";
    protected final String fieldName;
    private final Field field;

    public ColumnImpl(String fieldName, Field field) {
        this.fieldName = fieldName;
        this.field = field;
    }

    public String getForceApiName() {
        return this.fieldName;
    }

    public String getForceApiRelationshipName() {
        return this.field != null ? this.field.getRelationshipName() : this.fieldName;
    }

    public String getFieldName() {
        return this.field != null ? this.field.getName() : this.fieldName;
    }

    public FieldType getType() {
        if (this.field == null) {
            return null;
        }
        FieldType type = this.field.getType();
        if (type == FieldType._double && this.field.getScale() == 0) {
            type = FieldType._int;
        }
        return type;
    }

    public Field getField() {
        return this.field;
    }

    public boolean isCustom() {
        return this.field != null && this.field.isCustom();
    }

    protected void appendPrefix(ExpressionBuilderHelper queryHelper, boolean appendComma, String prefix) {
        if (appendComma) {
            queryHelper.getBuilder().append(", ");
        }
        if (prefix != null) {
            queryHelper.getBuilder().append(prefix);
        }
    }

    public boolean appendSelectString(ExpressionBuilderHelper queryHelper, AbstractClassMetaData acmd, int fieldNum, boolean appendComma, String prefix) {
        if (this.field != null && this.field.getType() == FieldType.reference && !queryHelper.isJoinQuery()) {
            if (queryHelper.skipRelationship(acmd, fieldNum)) {
                return false;
            }
            this.appendPrefix(queryHelper, appendComma, null);
            queryHelper.appendRelationship(acmd, fieldNum, this, prefix, false);
        } else {
            this.appendPrefix(queryHelper, appendComma, prefix);
            queryHelper.getBuilder().append(this.getFieldName());
        }
        return true;
    }

    public String getSelectFieldName() {
        return this.field != null && this.field.getType() == FieldType.reference ? this.getForceApiRelationshipName() : this.getFieldName();
    }

    public String toString() {
        return this.getFieldName();
    }
}

