/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.jpa.schema;

import com.sforce.soap.metadata.AsyncResult;
import com.sforce.soap.metadata.MetadataConnection;
import com.sforce.soap.metadata.StatusCode;
import com.sforce.ws.ConnectionException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ForceAsyncResultProcessor {
    private static final int MAX_ITERATION_WAIT_MS = 30000;
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)"com.force.sdk.jpa");

    protected void waitForAsyncResult(MetadataConnection service, AsyncResult[] ar, boolean throwOnErrors, Object metaData) throws RemoteException, InterruptedException {
        ArrayList<AsyncResult> arList = new ArrayList<AsyncResult>(Arrays.asList(ar));
        long waitTimeMilliSecs = 500L;
        while (true) {
            AsyncResult[] results;
            String[] oids = new String[arList.size()];
            for (int i = 0; i < arList.size(); ++i) {
                oids[i] = arList.get(i).getId();
            }
            try {
                results = service.checkStatus(oids);
            }
            catch (ConnectionException x) {
                throw new RuntimeException(x);
            }
            for (int i = results.length - 1; i >= 0; --i) {
                boolean done = results[i].getDone();
                if (!done) continue;
                StatusCode sc = results[i].getStatusCode();
                if (sc != null && throwOnErrors) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Error status code: ").append(sc).append("\n").append("Error message: ").append(results[i].getMessage());
                    sb.append("\nAttempted object(s):");
                    if (metaData.getClass().isArray()) {
                        for (Object o : (Object[])metaData) {
                            sb.append("\n").append(o);
                        }
                    } else {
                        sb.append("\n").append(metaData);
                    }
                    throw new RuntimeException(sb.toString());
                }
                arList.remove(i);
            }
            if (arList.size() == 0) break;
            Thread.sleep(waitTimeMilliSecs);
            if (waitTimeMilliSecs >= 30000L) continue;
            waitTimeMilliSecs = (long)((double)waitTimeMilliSecs * 1.5);
        }
    }
}

