/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.jpa.query.formatter;

import java.util.regex.Pattern;

public class MultiPicklistFormatter {
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private String value;

    public MultiPicklistFormatter(String value) {
        this.value = value;
    }

    public String getFormattedString() {
        if (this.value == null || this.value.length() == 0) {
            return this.value;
        }
        String[] values = COMMA_PATTERN.split(this.value);
        StringBuilder sb = new StringBuilder(this.value.length() + values.length * 4);
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("'").append(values[i]).append("'");
        }
        return sb.toString();
    }

    public String toString() {
        return this.getFormattedString();
    }
}

