/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.jpa.query;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public final class SOQLDateFormatUtil {
    private SOQLDateFormatUtil() {
    }

    public static String getSOQLFormat(Calendar value) {
        TimeZone tz = value.getTimeZone();
        TimeZone localTz = TimeZone.getDefault();
        int offset = tz.getRawOffset();
        int offsetDiffFromLocal = offset - localTz.getRawOffset();
        Date adjustedDateValue = new Date(value.getTimeInMillis() + (long)offsetDiffFromLocal);
        String timezone = String.format("%s%02d:%02d", offset >= 0 ? "+" : "-", Math.abs(offset / 3600000), Math.abs(offset / 60000 % 60));
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(adjustedDateValue) + timezone;
    }

    public static String getSOQLFormat(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }
}

