/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.jpa.query;

import com.force.sdk.jpa.ForceManagedConnection;
import com.force.sdk.jpa.query.ForceQueryUtils;
import com.force.sdk.jpa.query.QueryListener;
import com.force.sdk.jpa.query.QueryNotifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.evaluator.JDOQLEvaluator;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.query.AbstractJDOQLQuery;
import org.datanucleus.store.query.AbstractJavaQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.NucleusLogger;

public class JDOQLQuery
extends AbstractJDOQLQuery
implements QueryNotifier {
    private Map<String, QueryListener> listeners = new HashMap<String, QueryListener>(4);

    public JDOQLQuery(ExecutionContext ec) {
        super(ec, (AbstractJDOQLQuery)null);
    }

    public JDOQLQuery(ExecutionContext ec, AbstractJDOQLQuery q) {
        super(ec, q);
    }

    public JDOQLQuery(ExecutionContext ec, String query) {
        super(ec, query);
    }

    protected Object performExecute(Map parameters) {
        ForceManagedConnection mconn = (ForceManagedConnection)this.ec.getStoreManager().getConnection(this.ec);
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021046", (Object)"JDOQL", (Object)this.getSingleStringQuery(), null));
            }
            Collection<Object> results = null;
            ArrayList candidates = null;
            if (this.candidateCollection != null) {
                candidates = new ArrayList(this.candidateCollection);
            } else if (this.candidateExtent != null) {
                candidates = new ArrayList();
                Iterator iter = this.candidateExtent.iterator();
                while (iter.hasNext()) {
                    candidates.add(iter.next());
                }
            } else {
                List<Object> rawResults = new ForceQueryUtils(this.ec, mconn, (AbstractJavaQuery)this, parameters, this.listeners, this.getExtensions()).getObjectsOfCandidateType(this.compilation.getExprResult());
                if (ForceQueryUtils.getLimitType((Query)this) == ForceQueryUtils.LimitType.Java) {
                    JDOQLEvaluator resultMapper = new JDOQLEvaluator((Query)this, rawResults, this.compilation, parameters, this.ec.getClassLoaderResolver());
                    results = resultMapper.execute(false, false, false, false, true);
                } else {
                    results = rawResults;
                }
            }
            if (candidates != null) {
                JDOQLEvaluator resultMapper = new JDOQLEvaluator((Query)this, candidates, this.compilation, parameters, this.ec.getClassLoaderResolver());
                results = resultMapper.execute(true, true, true, true, true);
            }
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021074", (Object)"JDOQL", (Object)("" + (System.currentTimeMillis() - startTime))));
            }
            List<Object> list = results;
            return list;
        }
        catch (NucleusException ne) {
            throw ne;
        }
        catch (Exception e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    @Override
    public void addListener(String name, QueryListener listener) {
        this.listeners.put(name, listener);
    }

    @Override
    public void removeListener(String name) {
        this.listeners.remove(name);
    }
}

