/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.jpa.query;

import com.force.sdk.jpa.ForceFetchFieldManager;
import com.force.sdk.jpa.ForceManagedConnection;
import com.force.sdk.jpa.ForcePersistenceHandler;
import com.force.sdk.jpa.ForceStoreManager;
import com.force.sdk.jpa.PersistenceUtils;
import com.force.sdk.jpa.annotation.JoinFilter;
import com.force.sdk.jpa.exception.ForceApiExceptionMap;
import com.force.sdk.jpa.query.CollectionParameter;
import com.force.sdk.jpa.query.ExpressionBuilderHelper;
import com.force.sdk.jpa.query.JPQLPartialCompiler;
import com.force.sdk.jpa.query.QueryListener;
import com.force.sdk.jpa.query.ResultMetaDataROF;
import com.force.sdk.jpa.query.SOQLDateFormatUtil;
import com.force.sdk.jpa.query.SOQLQuery;
import com.force.sdk.jpa.query.TupleName;
import com.force.sdk.jpa.query.formatter.MultiPicklistFormatter;
import com.force.sdk.jpa.table.ColumnImpl;
import com.force.sdk.jpa.table.TableImpl;
import com.sforce.soap.partner.DeleteResult;
import com.sforce.soap.partner.EmptyRecycleBinResult;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.soap.partner.QueryResult;
import com.sforce.soap.partner.fault.ApiFault;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.bind.XmlObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jdo.identity.StringIdentity;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FetchGroupMetaData;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.evaluator.JDOQLResultClassMapper;
import org.datanucleus.query.expression.ClassExpression;
import org.datanucleus.query.expression.CreatorExpression;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.JoinExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.OrderExpression;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.expression.SubqueryExpression;
import org.datanucleus.query.expression.VariableExpression;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.FieldValues2;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.Type;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.query.AbstractJavaQuery;
import org.datanucleus.store.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForceQueryUtils {
    static final Logger LOGGER = LoggerFactory.getLogger((String)"com.force.sdk.jpa.query");
    private static final int MAX_EXPRESSION_DEPTH = 100;
    private static final int MAX_DELETE_IDS = 200;
    private static final Set<String> AGGREGATE_METHODS;
    private static final Set<String> UNSUPPORTED_JOINS;
    private ExecutionContext ec;
    private ForceManagedConnection mconn;
    private AbstractJavaQuery query;
    private Map<Object, Object> parameters;
    private Map<String, QueryListener> listeners;
    private Map<String, Object> hints;
    private int currentHint;

    public ForceQueryUtils(ExecutionContext ec, ForceManagedConnection mconn, AbstractJavaQuery query, Map<Object, Object> parameters, Map<String, QueryListener> listeners, Map<String, Object> hints) {
        this.ec = ec;
        this.mconn = mconn;
        this.query = query;
        this.parameters = parameters;
        this.listeners = listeners;
        this.hints = hints;
        this.currentHint = 0;
    }

    public static LimitType getLimitType(Query query) {
        if (query.getRangeFromIncl() > 0L || query.getRangeToExcl() > 0L && query.getRangeToExcl() < Long.MAX_VALUE) {
            if (query.getRangeFromIncl() == 0L) {
                return LimitType.Soql;
            }
            return LimitType.Java;
        }
        return LimitType.None;
    }

    ExecutionContext getExecutionContext() {
        return this.ec;
    }

    ForceManagedConnection getManagedConnection() {
        return this.mconn;
    }

    Object getHints(String hint) {
        return this.hints != null ? this.hints.get(hint) : null;
    }

    Long deleteObjectsOfCandidateType(Object candidateClass) {
        try {
            AbstractClassMetaData acmd;
            AbstractClassMetaData abstractClassMetaData = acmd = candidateClass instanceof String ? this.ec.getMetaDataManager().getMetaDataForEntityName((String)candidateClass) : this.ec.getMetaDataManager().getMetaDataForClass((Class)candidateClass, this.ec.getClassLoaderResolver());
            if (acmd == null) {
                throw new NucleusUserException("Entity not found: " + candidateClass);
            }
            ForceStoreManager storeManager = (ForceStoreManager)this.ec.getStoreManager();
            TableImpl table = storeManager.getTable(acmd);
            PartnerConnection service = (PartnerConnection)this.mconn.getConnection();
            long totalDeleted = 0L;
            boolean done = false;
            while (!done) {
                QueryResult qr = service.query(this.buildQuery(table, acmd, null, this.query.getCompilation(), false, 200L, null, table.getTableName().getForceApiName()));
                if (qr.getSize() == 0) {
                    return totalDeleted;
                }
                String[] idsToDelete = new String[qr.getSize()];
                for (int i = 0; i < idsToDelete.length; ++i) {
                    idsToDelete[i] = qr.getRecords()[i].getId();
                }
                DeleteResult[] deleteResult = service.delete(idsToDelete);
                ForcePersistenceHandler.checkForErrors(deleteResult);
                if (this.hints != null && Boolean.TRUE.equals(this.hints.get("EmptyRecycleBin"))) {
                    EmptyRecycleBinResult[] emptyResult = service.emptyRecycleBin(idsToDelete);
                    ForcePersistenceHandler.checkForRecycleBinErrors(emptyResult);
                }
                totalDeleted += (long)deleteResult.length;
                if (deleteResult.length >= 200) continue;
                return totalDeleted;
            }
            return totalDeleted;
        }
        catch (ApiFault af) {
            throw new NucleusDataStoreException(af.toString(), (Throwable)af);
        }
        catch (Exception e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    List<Object> getObjectsOfCandidateType(Expression[] resultExpr) {
        try {
            int[] fieldsLoaded;
            QueryResult qr;
            ForceStoreManager storeManager = (ForceStoreManager)this.ec.getStoreManager();
            ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
            AbstractClassMetaData acmd = null;
            TableImpl table = null;
            if (this.query.getCandidateClass() != null) {
                AbstractClassMetaData candidateCmd = this.ec.getMetaDataManager().getMetaDataForClass(this.query.getCandidateClass(), clr);
                if (candidateCmd == null) {
                    throw new NucleusUserException("Candidate entity not found: " + this.query.getCandidateClass());
                }
                TableImpl candidateTable = storeManager.getTable(candidateCmd);
                if (this.query.getResultClass() != null && (acmd = this.ec.getMetaDataManager().getMetaDataForClass(this.query.getResultClass(), clr)) != null) {
                    TableImpl resultTable = storeManager.getTable(acmd);
                    if (!resultTable.getTableName().getForceApiName().equals(candidateTable.getTableName().getForceApiName())) {
                        throw new NucleusUserException(String.format("Result class: %s is not compatible with force.com table: %s", this.query.getResultClass().getName(), candidateTable.getTableName().getName()));
                    }
                    table = resultTable;
                }
                if (acmd == null) {
                    acmd = candidateCmd;
                    table = candidateTable;
                }
            } else if (this.query.getResultClass() != null) {
                acmd = this.ec.getMetaDataManager().getMetaDataForClass(this.query.getResultClass(), clr);
            }
            PartnerConnection service = (PartnerConnection)this.mconn.getConnection();
            if (this.query.getCompilation() != null && acmd != null) {
                Set<Integer> fieldsToLoad = this.getFieldsToLoad(acmd, this.query.getFetchPlan());
                String soqlQuery = this.buildQuery(table, acmd, fieldsToLoad, this.query.getCompilation(), false, this.query.getRangeToExcl(), this.query.getFetchPlan(), table.getTableName().getForceApiName());
                if (LOGGER.isDebugEnabled()) {
                    StringBuilder sb = new StringBuilder(soqlQuery.length() * 2);
                    sb.append("Executing JPQL: " + this.query.getSingleStringQuery()).append("\n").append("SOQL: ").append(soqlQuery);
                    LOGGER.debug(sb.toString());
                }
                qr = service.query(soqlQuery);
                fieldsLoaded = new int[fieldsToLoad.size()];
                int i = 0;
                for (int f : fieldsToLoad) {
                    fieldsLoaded[i++] = f;
                }
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Executing Native SOQL: " + this.query.getSingleStringQuery());
                }
                qr = service.query(this.query.getSingleStringQuery());
                fieldsLoaded = acmd != null ? acmd.getDFGMemberPositions() : null;
            }
            return this.getResultFromQueryResult(acmd, fieldsLoaded, qr, resultExpr);
        }
        catch (ApiFault af) {
            throw ForceApiExceptionMap.mapToNucleusException(af, true, ((ForceStoreManager)this.ec.getStoreManager()).isEnableOptimisticTransactions());
        }
        catch (Exception e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    private Set<Integer> getFieldsToLoad(AbstractClassMetaData acmd, FetchPlan fetchPlan) {
        LinkedHashSet<Integer> memberPositions;
        if (fetchPlan != null && fetchPlan.getGroups().size() > 1) {
            memberPositions = new LinkedHashSet(acmd.getMemberCount());
            for (String group : fetchPlan.getGroups()) {
                if ("default".equals(group)) {
                    for (int i : acmd.getDFGMemberPositions()) {
                        memberPositions.add(i);
                    }
                    continue;
                }
                FetchGroupMetaData fgmd = acmd.getFetchGroupMetaData(group);
                if (fgmd == null) {
                    throw new NucleusDataStoreException("Fetch group metadata not found for group: " + group);
                }
                this.addFetchGroupMemberPositions(acmd, memberPositions, fgmd);
            }
        } else {
            memberPositions = new LinkedHashSet<Integer>(acmd.getDFGMemberPositions().length);
            for (int pos : acmd.getDFGMemberPositions()) {
                memberPositions.add(pos);
            }
        }
        return memberPositions;
    }

    private void addFetchGroupMemberPositions(AbstractClassMetaData acmd, Set<Integer> memberPositions, FetchGroupMetaData fm) {
        for (AbstractMemberMetaData abstractMemberMetaData : fm.getMemberMetaData()) {
            memberPositions.add(abstractMemberMetaData.getAbsoluteFieldNumber());
        }
        for (AbstractMemberMetaData abstractMemberMetaData : fm.getFetchGroupMetaData()) {
            this.addFetchGroupMemberPositions(acmd, memberPositions, (FetchGroupMetaData)abstractMemberMetaData);
        }
    }

    private List<Object> getResultFromQueryResult(AbstractClassMetaData acmd, int[] fieldsToLoad, QueryResult qr, Expression[] resultExpr) throws ConnectionException, SQLException {
        ArrayList<Object> results = new ArrayList<Object>();
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        ForceStoreManager storeManager = (ForceStoreManager)this.ec.getStoreManager();
        if (resultExpr != null || acmd == null && this.query.getResultClass() != null) {
            if (qr.getRecords().length > 0) {
                results.addAll(this.readNonEntityObjects(qr.getRecords(), resultExpr, this.query.getResultClass()));
            } else if (resultExpr.length == 1 && resultExpr[0] instanceof InvokeExpression && "COUNT".equals(((InvokeExpression)resultExpr[0]).getOperation())) {
                results.add(qr.getSize());
            }
        } else if (fieldsToLoad == null) {
            if (this.query instanceof SOQLQuery && ((SOQLQuery)this.query).getResultMetaData() != null) {
                ResultMetaDataROF rof = new ResultMetaDataROF(((SOQLQuery)this.query).getResultMetaData());
                for (SObject sobject : qr.getRecords()) {
                    results.add(rof.getObject(this.ec, this.mconn, this.query, sobject));
                }
            } else {
                Collections.addAll(results, qr.getRecords());
            }
        } else {
            for (SObject sobject : qr.getRecords()) {
                results.add(this.ec.findObjectUsingAID(new Type(clr.classForName(acmd.getFullClassName())), ForceQueryUtils.getFieldValues2(acmd, fieldsToLoad, this.mconn, storeManager, (XmlObject)sobject, (Query)this.query), this.query.getIgnoreCache(), true));
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Result raw rows: " + qr.getRecords().length + " processed rows: " + results.size());
        }
        return results;
    }

    public static FieldValues2 getFieldValues2(final AbstractClassMetaData acmd, final int[] fieldsToLoad, final ForceManagedConnection mconn, final ForceStoreManager storeManager, final XmlObject sobject, final Query query) {
        return new FieldValues2(){

            public void fetchFields(ObjectProvider sm) {
                try {
                    sm.replaceFields(acmd.getPKMemberPositions(), (FieldManager)new ForceFetchFieldManager(sm, storeManager, mconn, sobject, query));
                    sm.replaceFields(fieldsToLoad, (FieldManager)new ForceFetchFieldManager(sm, storeManager, mconn, sobject, query));
                }
                catch (Exception e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
            }

            public void fetchNonLoadedFields(ObjectProvider sm) {
                try {
                    sm.replaceNonLoadedFields(acmd.getAllMemberPositions(), (FieldManager)new ForceFetchFieldManager(sm, storeManager, mconn, sobject, query));
                }
                catch (Exception e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        };
    }

    private void getFieldNameList(SObject[] sObjects, boolean createFieldNameExpressions, List<String> fieldNameList, List<Expression> fieldNameExprs) {
        Iterator fieldIter = sObjects[0].getChildren();
        int i = 0;
        while (fieldIter.hasNext()) {
            XmlObject xo = (XmlObject)fieldIter.next();
            String name = xo.getName().getLocalPart();
            if (i >= 2) {
                fieldNameList.add(name);
                if (createFieldNameExpressions) {
                    fieldNameExprs.add((Expression)new PrimaryExpression(Arrays.asList(name)));
                }
            }
            ++i;
        }
    }

    private Collection<Object> readExpressionObjects(SObject[] sObjects, Expression[] exprs, List<String> fieldNameList) throws ConnectionException, SQLException {
        ArrayList<Object> res = new ArrayList<Object>(sObjects.length);
        HashMap<String, ForceFetchFieldManager> ffms = new HashMap<String, ForceFetchFieldManager>();
        for (SObject sObject : sObjects) {
            ffms.clear();
            ArrayList<Object> row = new ArrayList<Object>(exprs.length);
            for (int i = 0; i < exprs.length; ++i) {
                row.add(this.getDataForExpression(ffms, sObject, exprs[i], fieldNameList.get(i), null));
            }
            res.add(row.size() > 1 ? row.toArray() : row.get(0));
        }
        return res;
    }

    private Collection<Object> readCreatorExpressionObjects(Class clazz, SObject[] sObjects, Expression[] exprs, List<String> fieldNameList) throws ConnectionException, SQLException {
        Collection<Object> res = this.readExpressionObjects(sObjects, exprs, fieldNameList);
        return new JDOQLResultClassMapper(clazz).map(res, this.toShortNameExpressions(exprs));
    }

    private Expression[] toShortNameExpressions(Expression[] exprs) {
        if (exprs == null || exprs.length == 0) {
            return exprs;
        }
        Expression[] shortNameExpr = new Expression[exprs.length];
        for (int i = 0; i < exprs.length; ++i) {
            if (exprs[i] instanceof PrimaryExpression) {
                List t = ((PrimaryExpression)exprs[i]).getTuples();
                shortNameExpr[i] = new PrimaryExpression(Arrays.asList((String)t.get(t.size() - 1)));
                continue;
            }
            shortNameExpr[i] = exprs[i];
        }
        return shortNameExpr;
    }

    private ExpressionMetaData getExpressionMetaData(Expression expr) {
        AbstractClassMetaData cmd = null;
        AbstractMemberMetaData mmd = null;
        ExpressionMetaData exprMetaData = null;
        if (expr instanceof PrimaryExpression) {
            exprMetaData = new ExpressionMetaData();
            List ids = ((PrimaryExpression)expr).getTuples();
            String id = null;
            for (int i = 0; i < ids.size(); ++i) {
                id = (String)ids.get(i);
                Symbol symbol = this.query.getCompilation().getSymbolTable().getSymbol(id);
                if (symbol != null) {
                    cmd = this.ec.getMetaDataManager().getMetaDataForClass(symbol.getValueType(), this.ec.getClassLoaderResolver());
                    exprMetaData.setClassMetaData(cmd);
                    continue;
                }
                if (cmd != null) {
                    mmd = cmd.getMetaDataForMember(id);
                    if (mmd == null) {
                        throw new NucleusUserException("Symbol not found, entity: " + cmd.getName() + " symbol: " + id);
                    }
                    exprMetaData.setMemberMetaData(mmd);
                    continue;
                }
                throw new NucleusUserException("Could not find alias for field: " + id);
            }
        }
        return exprMetaData;
    }

    private Object getDataForExpression(Map<String, ForceFetchFieldManager> ffms, SObject sObject, Expression expr, String fieldName, Object valueOverride) throws ConnectionException, SQLException {
        if (expr instanceof PrimaryExpression) {
            ExpressionMetaData exprMetaData = this.getExpressionMetaData(expr);
            if (exprMetaData != null) {
                AbstractMemberMetaData mmd = exprMetaData.getMemberMetaData();
                AbstractClassMetaData cmd = exprMetaData.getClassMetaData();
                if (cmd != null) {
                    ForceFetchFieldManager ffm = ffms.get(cmd.getName());
                    if (ffm == null) {
                        ffm = new ForceFetchFieldManager(this.ec, cmd, (ForceStoreManager)this.ec.getStoreManager(), this.mconn, (XmlObject)sObject, (Query)this.query);
                        ffms.put(cmd.getName(), ffm);
                    }
                    return ffm.fetchObjectField(mmd, valueOverride);
                }
            }
        } else if (expr instanceof InvokeExpression) {
            InvokeExpression ev = (InvokeExpression)expr;
            String oper = ev.getOperation();
            if ("mapKey".equals(oper) || "mapValue".equals(oper) || "mapEntry".equals(oper)) {
                String alias = expr.getLeft().getSymbol().getQualifiedName();
                Map childrenMap = (Map)this.getDataForExpression(ffms, sObject, (Expression)this.getPrimaryExpresionFromJoinAlias(this.query.getCompilation(), alias), fieldName, null);
                if ("mapKey".equals(oper)) {
                    return Collections.unmodifiableList(new ArrayList(childrenMap.keySet()));
                }
                if ("mapValue".equals(oper)) {
                    return Collections.unmodifiableList(new ArrayList(childrenMap.values()));
                }
                return Collections.unmodifiableList(new ArrayList(childrenMap.entrySet()));
            }
            if ("MAX".equals(oper) || "MIN".equals(oper)) {
                Object value = sObject.getField(fieldName);
                if (value == null) {
                    return null;
                }
                if (value instanceof Date || value instanceof Calendar) {
                    return value;
                }
                return this.getDataForExpression(ffms, sObject, (Expression)ev.getArguments().get(0), fieldName, value.toString());
            }
            if ("SUM".equals(oper)) {
                Object value = sObject.getField(fieldName);
                if (value == null) {
                    return value;
                }
                ExpressionMetaData exprMetaData = this.getExpressionMetaData((Expression)ev.getArguments().get(0));
                AbstractMemberMetaData mmd = exprMetaData.getMemberMetaData();
                if (mmd != null) {
                    if (mmd.getType() == Short.TYPE || mmd.getType() == Short.class || mmd.getType() == Integer.TYPE || mmd.getType() == Integer.class || mmd.getType() == Long.TYPE || mmd.getType() == Long.class) {
                        return ((Double)value).longValue();
                    }
                    if (mmd.getType() == BigInteger.class || mmd.getType() == BigDecimal.class) {
                        return this.getDataForExpression(ffms, sObject, (Expression)ev.getArguments().get(0), fieldName, value.toString());
                    }
                }
            }
        }
        return sObject.getField(fieldName);
    }

    private PrimaryExpression getPrimaryExpresionFromJoinAlias(QueryCompilation compilation, String alias) {
        for (Expression fromExpr : compilation.getExprFrom()) {
            for (Expression expr = fromExpr.getRight(); expr != null; expr = expr.getRight()) {
                if (!(expr instanceof JoinExpression) || !alias.equals(expr.getAlias())) continue;
                return ((JoinExpression)expr).getPrimaryExpression();
            }
        }
        return null;
    }

    private List<Object> getResultAsCollection(SObject[] sObjects, List<String> fieldNameList) {
        ArrayList<Object> res = new ArrayList<Object>(sObjects.length);
        for (SObject sObject : sObjects) {
            ArrayList<Object> row = new ArrayList<Object>(fieldNameList.size());
            for (int i = 0; i < fieldNameList.size(); ++i) {
                row.add(sObject.getField(fieldNameList.get(i)));
            }
            res.add(row.toArray());
        }
        return res;
    }

    private Collection<Object> readNonEntityObjects(SObject[] sObjects, Expression[] exprs, Class resultClass) throws ConnectionException, SQLException {
        ArrayList<String> fieldNameList = new ArrayList<String>();
        ArrayList<Expression> fieldNameExprs = new ArrayList<Expression>();
        boolean createFieldNameExpressions = resultClass != null;
        this.getFieldNameList(sObjects, createFieldNameExpressions, fieldNameList, fieldNameExprs);
        if (createFieldNameExpressions) {
            if (exprs != null && exprs.length > 0) {
                return this.readCreatorExpressionObjects(resultClass, sObjects, exprs, fieldNameList);
            }
            return new JDOQLResultClassMapper(resultClass).map(this.getResultAsCollection(sObjects, fieldNameList), fieldNameExprs.toArray(new Expression[fieldNameExprs.size()]));
        }
        if (exprs != null && exprs.length > 0) {
            if (exprs[0] instanceof CreatorExpression) {
                CreatorExpression ce = (CreatorExpression)exprs[0];
                return this.readCreatorExpressionObjects(ce.getSymbol().getValueType(), sObjects, ce.getArguments().toArray(new Expression[ce.getArguments().size()]), fieldNameList);
            }
            return this.readExpressionObjects(sObjects, exprs, fieldNameList);
        }
        return this.getResultAsCollection(sObjects, fieldNameList);
    }

    public String buildQueryWithPK(TableImpl table, AbstractClassMetaData acmd, int[] fieldNumbers, String pkValue, int fetchDepth, Set<String> queriedRelationships) {
        ExpressionBuilderHelper helper = new ExpressionBuilderHelper(this, fieldNumbers.length * 20 + 100, table, acmd, false, null, this.ec.getFetchPlan(), fetchDepth, null, queriedRelationships);
        helper.sb.append("select id");
        ArrayList<ColumnImpl> columns = new ArrayList<ColumnImpl>();
        for (int fieldNum : fieldNumbers) {
            columns.clear();
            List<ColumnImpl> cols = table.getColumnsFor(acmd, acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNum), (ForceStoreManager)this.ec.getStoreManager(), columns);
            for (ColumnImpl col : cols) {
                if ("id".equals(col.getForceApiName())) continue;
                col.appendSelectString(helper, acmd, fieldNum, true, null);
            }
        }
        helper.sb.append(" from ").append(table.getTableName().getForceApiName());
        helper.sb.append(String.format(" where %s='%s'", table.getPKFieldName(acmd), pkValue));
        String ret = helper.sb.toString();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Fetch object: " + table.getTableName().getName() + " id: " + pkValue);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Fetch query: " + ret);
        }
        return helper.sb.toString();
    }

    public String buildQuery(TableImpl table, AbstractClassMetaData acmd, Set<Integer> fieldsToLoad, QueryCompilation compilation, boolean skipId, long maxLimit, FetchPlan fetchPlan, String tableName) {
        return this.buildQuery(table, acmd, fieldsToLoad, compilation, skipId, maxLimit, fetchPlan, 0, tableName, true, false, null, null, null);
    }

    public String buildQuery(TableImpl table, AbstractClassMetaData acmd, Set<Integer> fieldsToLoad, QueryCompilation compilation, boolean skipId, long maxLimit, FetchPlan fetchPlan, int fetchDepth, String tableName, boolean isTopLevel, boolean isJoin, String joinAlias, ExpressionBuilderHelper parentHelper, Set<String> queriedRelationships) {
        ExpressionBuilderHelper helper = new ExpressionBuilderHelper(this, (fieldsToLoad != null ? fieldsToLoad.size() : 3) * 20 + 100, table, acmd, isJoin, compilation, fetchPlan, fetchDepth, parentHelper, queriedRelationships);
        helper.sb.append("select ");
        if (compilation != null && compilation.getResultDistinct()) {
            throw new NucleusException("select distinct not supported by force.com datastore");
        }
        if (compilation != null && compilation.getExprResult() != null) {
            this.appendExpressionList(helper, compilation.getExprResult(), this.ec);
        } else {
            int count = 0;
            if (!skipId) {
                helper.sb.append("id");
                ++count;
            }
            if (fieldsToLoad != null) {
                if (helper.relatedJoinAliases != null) {
                    for (Map.Entry<TupleName, String> ent : helper.relatedJoinAliases.entrySet()) {
                        TupleName fullName = ent.getKey();
                        int pos = acmd.getAbsolutePositionOfMember(fullName.getShortName());
                        if (pos < 0) {
                            throw new NucleusDataStoreException("Cannot locate member metadata for field: " + fullName.getLongName());
                        }
                        fieldsToLoad.add(pos);
                    }
                }
                ArrayList<ColumnImpl> columns = new ArrayList<ColumnImpl>();
                for (int fieldNum : fieldsToLoad) {
                    columns.clear();
                    List<ColumnImpl> cols = table.getColumnsFor(acmd, acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNum), (ForceStoreManager)this.ec.getStoreManager(), columns);
                    for (ColumnImpl col : cols) {
                        if ("id".equals(col.getForceApiName()) || !col.appendSelectString(helper, acmd, fieldNum, count > 0, null)) continue;
                        ++count;
                    }
                }
            }
        }
        helper.sb.append(" from ").append(tableName);
        if (compilation != null) {
            Expression filterExpression;
            String alias;
            String string = alias = isTopLevel ? compilation.getCandidateAlias() : joinAlias;
            if (alias != null) {
                helper.sb.append(String.format(" %s ", alias));
            }
            if ((filterExpression = helper.getFilterExpression(alias)) != null) {
                helper.sb.append(" where (");
                this.appendExpression(helper, filterExpression, this.ec);
                helper.sb.append(")");
            }
            if (isTopLevel && helper.relatedJoinAliases == null) {
                this.processJoin(helper, compilation, fetchPlan, filterExpression != null);
            }
            if (isTopLevel && compilation.getExprGrouping() != null) {
                helper.sb.append(" group by ");
                this.appendExpressionList(helper, compilation.getExprGrouping(), this.ec);
            }
            if (isTopLevel && compilation.getExprHaving() != null) {
                if (compilation.getExprGrouping() == null) {
                    throw new NucleusException("Queries specifying a HAVING clause must also specify a GROUP BY clause");
                }
                Expression expr = compilation.getExprHaving();
                boolean isAggregate = this.isAggregate(expr);
                if (!isAggregate) {
                    throw new NucleusException("HAVING clauses must reference an aggregate function");
                }
                helper.sb.append(" having ");
                this.appendExpression(helper, compilation.getExprHaving(), this.ec);
            }
            if (isTopLevel && compilation.getExprOrdering() != null) {
                helper.sb.append(" order by ");
                this.appendExpressionList(helper, compilation.getExprOrdering(), this.ec);
            }
        }
        if (maxLimit > 0L && maxLimit < Long.MAX_VALUE) {
            helper.sb.append(" limit ");
            helper.sb.append(maxLimit);
        }
        String ret = helper.sb.toString();
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (QueryListener listener : this.listeners.values()) {
                listener.listen(ret);
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Table: " + table.getTableName().getName() + " query: " + ret);
        }
        return ret;
    }

    private void processJoin(ExpressionBuilderHelper h, QueryCompilation compilation, FetchPlan fetchPlan, boolean hasWhere) {
        if (compilation.getExprFrom() == null) {
            return;
        }
        for (Expression fromExpr : compilation.getExprFrom()) {
            if (!(fromExpr instanceof ClassExpression)) {
                throw new NucleusDataStoreException("Unsupported from expression: " + fromExpr);
            }
            for (Expression expr = fromExpr.getRight(); expr != null; expr = expr.getRight()) {
                if (!(expr instanceof JoinExpression)) {
                    throw new NucleusDataStoreException("Unsupported expression found inside a join expression: " + fromExpr.getRight());
                }
                JoinExpression je = (JoinExpression)expr;
                this.processJoinExpression(je.getPrimaryExpression(), je.getAlias(), h, compilation, true, hasWhere, false);
                h.sb.append("))");
                hasWhere = true;
            }
        }
    }

    private void processJoinExpression(PrimaryExpression pe, String alias, ExpressionBuilderHelper h, QueryCompilation compilation, boolean needsWhere, boolean hasWhere, boolean not) {
        AbstractClassMetaData cmd = h.acmd;
        AbstractMemberMetaData mmd = null;
        List ids = pe.getTuples();
        String id = null;
        for (int i = 0; i < ids.size(); ++i) {
            id = (String)ids.get(i);
            Symbol symbol = compilation.getSymbolTable().getSymbol(id);
            if (symbol != null) {
                cmd = this.ec.getMetaDataManager().getMetaDataForClass(symbol.getValueType(), this.ec.getClassLoaderResolver());
                continue;
            }
            mmd = cmd.getMetaDataForMember(id);
            if (mmd == null) {
                throw new NucleusUserException("Symbol not found, entity: " + cmd.getName() + " symbol: " + id);
            }
            cmd = mmd.getCollection() != null || mmd.getMap() != null ? PersistenceUtils.getMemberElementClassMetaData(mmd, this.ec.getClassLoaderResolver(), this.ec.getMetaDataManager()) : this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), this.ec.getClassLoaderResolver());
        }
        TableImpl joinTable = ((ForceStoreManager)this.ec.getStoreManager()).getTable(cmd);
        Set<Integer> joinFieldsToLoad = null;
        String inField = null;
        boolean skipId = true;
        if (mmd.getMappedBy() != null) {
            mmd = cmd.getMetaDataForMember(mmd.getMappedBy());
            joinFieldsToLoad = Collections.singleton(mmd.getAbsoluteFieldNumber());
            inField = "id";
        } else {
            joinFieldsToLoad = Collections.singleton(cmd.getPKMemberPositions()[0]);
            TableImpl joiningTable = ((ForceStoreManager)this.ec.getStoreManager()).getTable(mmd.getAbstractClassMetaData());
            inField = joiningTable.getColumnByJavaName(mmd.getName()).getFieldName();
            skipId = false;
        }
        if (needsWhere) {
            if (hasWhere) {
                h.sb.append(" and (");
            } else {
                h.sb.append(" where (");
            }
        }
        h.sb.append(inField);
        if (not) {
            h.sb.append(" not");
        }
        h.sb.append(" in (").append(this.buildQuery(joinTable, cmd, joinFieldsToLoad, compilation, skipId, 0L, h.fetchPlan, h.fetchDepth, joinTable.getTableName().getForceApiName(), false, true, alias, h, h.queriedRelationships));
    }

    private boolean isAggregate(Expression expr) {
        if (expr == null) {
            return false;
        }
        if (expr instanceof InvokeExpression) {
            String methodName = ((InvokeExpression)expr).getOperation();
            return AGGREGATE_METHODS.contains(methodName);
        }
        return this.isAggregate(expr.getRight()) || this.isAggregate(expr.getLeft());
    }

    private void appendExpressionList(ExpressionBuilderHelper h, Expression[] exprList, ExecutionContext executionContext) {
        for (int i = 0; i < exprList.length; ++i) {
            if (i > 0) {
                h.sb.append(", ");
            }
            this.appendExpression(h, exprList[i], executionContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean appendExpression(ExpressionBuilderHelper h, Expression expr, ExecutionContext executionContext) {
        boolean done;
        block35: {
            if (expr == null) {
                return false;
            }
            done = false;
            if (h.level > 100) {
                throw new NucleusException("Expression too deep. Max depth reached at: " + expr);
            }
            ++h.level;
            try {
                if (expr instanceof DyadicExpression) {
                    if (expr.getOperator() instanceof Expression.MonadicOperator) {
                        if (expr.getLeft() instanceof InvokeExpression) {
                            this.appendInvokeExpression(h, (InvokeExpression)expr.getLeft(), executionContext, expr.getOperator() == Expression.OP_NOT);
                        } else {
                            h.sb.append(expr.getOperator().toString());
                            this.appendExpression(h, expr.getLeft(), executionContext);
                        }
                    } else {
                        boolean lparens = expr.getLeft() instanceof DyadicExpression;
                        if (lparens) {
                            h.sb.append("( ");
                        }
                        boolean skip = this.appendExpression(h, expr.getLeft(), executionContext);
                        if (lparens) {
                            h.sb.append(" )");
                        }
                        if (!skip) {
                            h.sb.append(expr.getOperator().toString());
                            boolean rparens = expr.getRight() instanceof DyadicExpression;
                            if (rparens) {
                                h.sb.append("( ");
                            }
                            this.appendExpression(h, expr.getRight(), executionContext);
                            if (rparens) {
                                h.sb.append(" )");
                            }
                        }
                    }
                    break block35;
                }
                if (expr instanceof PrimaryExpression) {
                    this.appendExpression(h, expr.getLeft(), executionContext);
                    this.appendExpression(h, expr.getRight(), executionContext);
                    List ids = ((PrimaryExpression)expr).getTuples();
                    int pos = 0;
                    TableImpl t = h.table;
                    AbstractClassMetaData cmd = h.acmd;
                    for (String id : ids) {
                        if (pos++ > 0) {
                            h.sb.append(".");
                        }
                        String name = id;
                        if (pos == ids.size()) {
                            ColumnImpl column = t.getColumnByJavaName(id);
                            if (column != null) {
                                name = column.getFieldName();
                            }
                        } else {
                            AbstractMemberMetaData mmd = cmd.getMetaDataForMember(id);
                            if (mmd != null) {
                                ColumnImpl column = t.getColumnByJavaName(mmd.getName());
                                name = column.getForceApiRelationshipName();
                                AbstractClassMetaData tcmd = executionContext.getMetaDataManager().getMetaDataForClass(mmd.getType(), null);
                                if (tcmd != null) {
                                    cmd = tcmd;
                                    t = ((ForceStoreManager)executionContext.getStoreManager()).getTable(cmd);
                                }
                            }
                        }
                        h.sb.append(name);
                    }
                    break block35;
                }
                if (expr instanceof InvokeExpression) {
                    done = this.appendInvokeExpression(h, (InvokeExpression)expr, executionContext, false);
                    break block35;
                }
                if (expr instanceof ParameterExpression) {
                    this.appendValue(h, this.getParameterValue(h, (ParameterExpression)expr, executionContext));
                    break block35;
                }
                if (expr instanceof VariableExpression) {
                    VariableExpression varExpr = (VariableExpression)expr;
                    if (varExpr.getSymbol() != null && varExpr.getSymbol().getQualifiedName() != null) {
                        QueryCompilation subCompilation = h.compilation.getCompilationForSubquery(varExpr.getSymbol().getQualifiedName());
                        if (subCompilation != null) {
                            AbstractClassMetaData cmd = executionContext.getMetaDataManager().getMetaDataForClass(subCompilation.getCandidateClass(), executionContext.getClassLoaderResolver());
                            TableImpl joinTable = ((ForceStoreManager)executionContext.getStoreManager()).getTable(cmd);
                            h.sb.append("(").append(this.buildQuery(joinTable, cmd, null, subCompilation, true, 0L, h.fetchPlan, joinTable.getTableName().getForceApiName())).append(")");
                        }
                        break block35;
                    }
                    throw new NucleusUserException("Unexpected expression type while parsing query.  Are you certain that a field named " + varExpr.getId() + " exists on your object?");
                }
                if (expr instanceof Literal) {
                    Object literal = ((Literal)expr).getLiteral();
                    if (literal == null) {
                        literal = "NULL";
                    }
                    this.appendValue(h, literal);
                    break block35;
                }
                if (expr instanceof OrderExpression) {
                    this.appendExpression(h, expr.getLeft(), executionContext);
                    OrderExpression order = (OrderExpression)expr;
                    h.sb.append(String.format(" %s ", "ascending".equals(order.getSortOrder()) ? "ASC" : "DESC"));
                    break block35;
                }
                if (expr instanceof CreatorExpression) {
                    CreatorExpression ce = (CreatorExpression)expr;
                    this.appendExpressionList(h, ce.getArguments().toArray(new Expression[ce.getArguments().size()]), executionContext);
                    break block35;
                }
                if (expr instanceof SubqueryExpression) {
                    SubqueryExpression subExpr = (SubqueryExpression)expr;
                    if ("EXISTS".equals(subExpr.getKeyword())) {
                        throw new NucleusUserException("EXISTS is not supported in force.com database");
                    }
                    if (UNSUPPORTED_JOINS.contains(subExpr.getKeyword())) {
                        throw new NucleusUserException(subExpr.getKeyword() + " is not supported in force.com database");
                    }
                    throw new NucleusUserException("Unexpected subquery expression: " + subExpr);
                }
                throw new NucleusException("Unexpected expression type while parsing query: " + expr.getClass().getName());
            }
            finally {
                --h.level;
            }
        }
        return done;
    }

    private TupleName getMappedExpression(ExpressionBuilderHelper h, InvokeExpression expr) {
        String alias = expr.getLeft().getSymbol().getQualifiedName();
        TupleName fieldName = null;
        for (Map.Entry<TupleName, String> ent : h.relatedJoinAliases.entrySet()) {
            if (!ent.getValue().equals(alias)) continue;
            fieldName = ent.getKey();
            break;
        }
        if (fieldName == null) {
            throw new NucleusDataStoreException("Cannot find field name for alias: " + alias);
        }
        return fieldName;
    }

    private void appendMappedByExpression(ExpressionBuilderHelper h, InvokeExpression expr) {
        TableImpl joinedTable;
        ColumnImpl col;
        AbstractClassMetaData cmd;
        TupleName fieldName = this.getMappedExpression(h, expr);
        String columnToAdd = "id";
        AbstractClassMetaData acmd = fieldName.getTuple().size() > 1 ? this.ec.getMetaDataManager().getMetaDataForClass(h.compilation.getSymbolTable().getSymbol(fieldName.getShortNamePrefix()).getValueType(), this.ec.getClassLoaderResolver()) : h.acmd;
        AbstractMemberMetaData ammd = acmd.getMetaDataForMember(fieldName.getShortName());
        if (ammd.getKeyMetaData() != null && (cmd = PersistenceUtils.getMemberElementClassMetaData(ammd, this.ec.getClassLoaderResolver(), this.ec.getMetaDataManager())) != null && (col = (joinedTable = ((ForceStoreManager)this.ec.getStoreManager()).getTable(cmd)).getColumnByJavaName(ammd.getKeyMetaData().getMappedBy())) != null) {
            columnToAdd = col.getFieldName();
        }
        h.sb.append(columnToAdd);
    }

    private boolean appendInvokeExpression(ExpressionBuilderHelper h, InvokeExpression invocation, ExecutionContext executionContext, boolean not) {
        boolean done = false;
        String oper = invocation.getOperation();
        if ("matches".equals(oper)) {
            if (not) {
                h.sb.append("NOT ");
            }
            this.appendExpression(h, invocation.getLeft(), executionContext);
            h.sb.append(" like ");
            this.appendExpression(h, (Expression)invocation.getArguments().get(0), executionContext);
        } else if ("toLowerCase".equals(oper)) {
            this.appendExpression(h, invocation.getLeft(), executionContext);
        } else if ("COUNT".equals(oper)) {
            h.sb.append(String.format(" %s()", oper));
        } else if ("CURRENT_DATE".equals(oper)) {
            h.sb.append(String.format(" %s", this.getCurrentDateHint(h)));
        } else {
            if ("CURRENT_TIMESTAMP".equals(oper) || "CURRENT_TIME".equals(oper)) {
                throw new NucleusUserException("CURRENT_TIMESTAMP or CURRENT_TIME is not supported by Force.com datastore");
            }
            if ("mapKey".equals(oper) || "mapValue".equals(oper) || "mapEntry".equals(oper)) {
                if (h.isInSelect) {
                    TupleName fieldName = this.getMappedExpression(h, invocation);
                    ColumnImpl column = h.table.getColumnByJavaName(fieldName.getShortName());
                    if (column != null) {
                        column.appendSelectString(h, h.acmd, h.acmd.getAbsolutePositionOfMember(fieldName.getShortName()), false, null);
                    }
                } else {
                    this.appendMappedByExpression(h, invocation);
                }
            } else if ("contains".equals(oper)) {
                this.appendContainsExpression(h, invocation, not);
            } else if ("size".equals(oper)) {
                boolean isEmpty = invocation.getParent().getOperator() == Expression.OP_EQ;
                this.appendContainsExpression(h, invocation, isEmpty);
                done = true;
            } else {
                if (not) {
                    h.sb.append(" NOT ");
                }
                h.sb.append(String.format(" %s(", oper));
                this.appendExpression(h, invocation.getLeft(), executionContext);
                int pos = 0;
                for (Expression e : invocation.getArguments()) {
                    if (pos++ > 0) {
                        h.sb.append(", ");
                    }
                    this.appendExpression(h, e, executionContext);
                }
                h.sb.append(") ");
                this.appendExpression(h, invocation.getRight(), executionContext);
            }
        }
        return done;
    }

    private void appendContainsExpression(ExpressionBuilderHelper h, InvokeExpression expr, boolean not) {
        PrimaryExpression pe = (PrimaryExpression)expr.getLeft();
        TupleName fieldName = new TupleName(pe.getTuples());
        AbstractMemberMetaData ammd = h.acmd.getMetaDataForMember(fieldName.getShortName());
        if (ammd != null && (ammd.getMap() != null || ammd.getCollection() != null)) {
            this.processJoinExpression(pe, null, h, h.compilation, false, false, not);
            if (expr.getArguments().size() > 0) {
                String name = this.hints != null ? (String)this.hints.get("MEMBER_OF_FIELD") : null;
                h.sb.append(" where ");
                this.appendExpression(h, (Expression)new PrimaryExpression(new TupleName(name != null ? name : "name").getTuple()), this.ec);
                h.sb.append(" = ");
                this.appendExpression(h, (Expression)expr.getArguments().get(0), this.ec);
            }
            h.sb.append(")");
        } else {
            this.appendExpression(h, expr.getLeft(), this.ec);
            if (expr.getArguments().size() > 0) {
                h.sb.append(not ? " excludes(" : " includes(");
                Literal l = (Literal)expr.getArguments().get(0);
                h.sb.append(new MultiPicklistFormatter(l.getLiteral().toString()).getFormattedString());
                h.sb.append(")");
            } else {
                h.sb.append(not ? " = " : " != ").append("null");
            }
        }
    }

    private String getCurrentDateHint(ExpressionBuilderHelper h) {
        String[] hArray;
        Object hint;
        Object object = hint = this.hints != null ? this.hints.get("CURRENT_DATE") : null;
        if (hint instanceof String[] && this.currentHint < (hArray = (String[])hint).length) {
            hint = hArray[this.currentHint++];
        }
        if (hint instanceof String) {
            return (String)hint;
        }
        return "TODAY";
    }

    private void appendValue(ExpressionBuilderHelper h, Object value) {
        Class<?> clazz = value.getClass();
        if (clazz == String.class || clazz == Character.class || clazz == URL.class || clazz == Byte.class || clazz == Byte.TYPE) {
            h.sb.append(String.format("'%s'", value));
        } else if (clazz == Date.class || value instanceof Calendar) {
            if (clazz == Date.class) {
                h.sb.append(SOQLDateFormatUtil.getSOQLFormat((Date)value));
            } else {
                h.sb.append(SOQLDateFormatUtil.getSOQLFormat((Calendar)value));
            }
        } else {
            h.sb.append(value);
        }
    }

    private Object getParameterValue(ExpressionBuilderHelper h, ParameterExpression expr, ExecutionContext executionContext) {
        Object paramValue = this.parameters.get(expr.getId());
        if (paramValue != null) {
            return this.getTransformedValueFromParamValue(paramValue, executionContext);
        }
        try {
            paramValue = this.parameters.get(Integer.parseInt(expr.getId()));
            if (paramValue != null) {
                return this.getTransformedValueFromParamValue(paramValue, executionContext);
            }
            return paramValue;
        }
        catch (NumberFormatException e) {
            return new NucleusException("Cannot find parameter expression: " + expr.toString());
        }
    }

    private Object getTransformedValueFromParamValue(Object paramValue, ExecutionContext executionContext) {
        AbstractClassMetaData acmd = executionContext.getMetaDataManager().getMetaDataForClass(paramValue.getClass(), executionContext.getClassLoaderResolver());
        if (acmd != null && paramValue instanceof PersistenceCapable) {
            return ForceQueryUtils.getIdFromObject((PersistenceCapable)paramValue, acmd).toString();
        }
        if (paramValue instanceof Collection) {
            return new CollectionParameter((Collection)paramValue);
        }
        return paramValue;
    }

    public static Object getIdFromObject(PersistenceCapable entity, AbstractClassMetaData acmd) {
        Object ret = null;
        AbstractMemberMetaData ammd = acmd.getMetaDataForManagedMemberAtAbsolutePosition(acmd.getPKMemberPositions()[0]);
        try {
            ret = PersistenceUtils.getMemberValue(acmd, acmd.getPKMemberPositions()[0], entity);
            if (ret instanceof String) {
                ret = new StringIdentity(ammd.getType(), (String)ret);
            }
            return ret;
        }
        catch (Exception e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    public void appendRelationshipQuery(ExpressionBuilderHelper helper, AbstractMemberMetaData ammd, ColumnImpl col) {
        FetchPlan fetchPlan = this.ec.getFetchPlan();
        Set<Integer> joinFieldsToLoad = this.getFieldsToLoad(helper.acmd, fetchPlan);
        String relName = col.getForceApiRelationshipName();
        helper.getBuilder().append("(").append(this.buildQuery(helper.table, helper.acmd, joinFieldsToLoad, null, false, 0L, fetchPlan, helper.fetchDepth, relName, false, false, null, null, helper.queriedRelationships));
        TupleName name = new TupleName(ammd.getName());
        if (helper.relatedJoinAliases != null && helper.relatedJoinAliases.containsKey(name)) {
            Expression filter = helper.aliasToFilterMappings.get(helper.relatedJoinAliases.get(name));
            if (filter == null) {
                throw new NucleusDataStoreException("Could not locate related filter for alias: " + helper.relatedJoinAliases.get(name));
            }
            helper.getBuilder().append(" ").append(helper.relatedJoinAliases.get(name)).append(" where (");
            boolean oldIsInSelect = helper.isInSelect;
            helper.isInSelect = false;
            this.appendExpression(helper, filter, this.ec);
            helper.isInSelect = oldIsInSelect;
            helper.getBuilder().append(")");
        } else {
            JoinFilter joinFilter = PersistenceUtils.getMemberAnnotation(ammd.getMemberRepresented(), JoinFilter.class);
            if (joinFilter != null) {
                if (joinFilter.alias().length() > 0) {
                    helper.getBuilder().append(String.format(" %s", joinFilter.alias()));
                }
                if (joinFilter.value().length() > 0) {
                    helper.getBuilder().append(" where (").append(joinFilter.value()).append(")");
                }
            }
        }
        if (ammd.getOrderMetaData() != null && ammd.getOrderMetaData().getOrdering() != null && !ammd.getOrderMetaData().getOrdering().equals("#PK")) {
            JPQLPartialCompiler partialCompiler = new JPQLPartialCompiler(this.ec, helper.compilation, null, this.parameters);
            helper.getBuilder().append(" order by ");
            String orderBy = ammd.getOrderMetaData().getOrdering();
            if (orderBy == null || orderBy.length() == 0) {
                orderBy = "id";
            }
            Expression[] exprList = partialCompiler.compileOrdering(orderBy);
            this.appendExpressionList(helper, exprList, this.ec);
        }
        helper.getBuilder().append(")");
    }

    public void appendRelationshipFields(ExpressionBuilderHelper helper, ColumnImpl col, String prefix) {
        ArrayList<ColumnImpl> columns = new ArrayList<ColumnImpl>();
        int count = 0;
        String newPrefix = prefix != null ? prefix + col.getForceApiRelationshipName() + "." : col.getForceApiRelationshipName() + ".";
        for (int num : helper.acmd.getDFGMemberPositions()) {
            columns.clear();
            List<ColumnImpl> cols = helper.table.getColumnsFor(helper.acmd, helper.acmd.getMetaDataForManagedMemberAtAbsolutePosition(num), (ForceStoreManager)this.ec.getStoreManager(), columns);
            for (ColumnImpl c : cols) {
                if (!c.appendSelectString(helper, helper.acmd, num, count > 0, newPrefix)) continue;
                ++count;
            }
        }
    }

    static {
        HashSet<String> am = new HashSet<String>();
        am.add("COUNT");
        am.add("SUM");
        am.add("AVG");
        am.add("MIN");
        am.add("MAX");
        AGGREGATE_METHODS = Collections.unmodifiableSet(am);
        HashSet<String> uj = new HashSet<String>();
        uj.add("ALL");
        uj.add("ANY");
        uj.add("SOME");
        UNSUPPORTED_JOINS = Collections.unmodifiableSet(uj);
    }

    private static final class ExpressionMetaData {
        private AbstractClassMetaData acmd;
        private AbstractMemberMetaData ammd;

        private ExpressionMetaData() {
        }

        private AbstractClassMetaData getClassMetaData() {
            return this.acmd;
        }

        private void setClassMetaData(AbstractClassMetaData classMetaData) {
            this.acmd = classMetaData;
        }

        private AbstractMemberMetaData getMemberMetaData() {
            return this.ammd;
        }

        private void setMemberMetaData(AbstractMemberMetaData memberMetaData) {
            this.ammd = memberMetaData;
        }
    }

    static enum LimitType {
        None,
        Soql,
        Java;

    }
}

