/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.jpa.query;

import com.force.sdk.jpa.ForceStoreManager;
import com.force.sdk.jpa.PersistenceUtils;
import com.force.sdk.jpa.query.ForceQueryUtils;
import com.force.sdk.jpa.query.TupleName;
import com.force.sdk.jpa.table.ColumnImpl;
import com.force.sdk.jpa.table.TableImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.FetchPlan;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.JoinExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.symbol.PropertySymbol;
import org.datanucleus.query.symbol.Symbol;

public class ExpressionBuilderHelper {
    ForceQueryUtils forceQuery;
    StringBuilder sb;
    TableImpl table;
    AbstractClassMetaData acmd;
    int level;
    boolean isJoin;
    QueryCompilation compilation;
    FetchPlan fetchPlan;
    int fetchDepth;
    private final int maxFetchDepth;
    Map<String, Expression> aliasToFilterMappings;
    Map<TupleName, String> relatedJoinAliases;
    boolean isInSelect;
    private final boolean isTopLevel;
    Set<String> queriedRelationships;
    private static final String RELATIONSHIP_SEPARATOR = "->";

    ExpressionBuilderHelper(ForceQueryUtils forceQuery, int length, TableImpl table, AbstractClassMetaData acmd, boolean isJoin, QueryCompilation compilation, FetchPlan fetchPlan, int fetchDepth, ExpressionBuilderHelper parent, Set<String> queriedRelationships) {
        int maxDepth;
        this.forceQuery = forceQuery;
        this.sb = new StringBuilder(length);
        this.table = table;
        this.acmd = acmd;
        this.level = 0;
        this.isJoin = isJoin;
        this.compilation = compilation;
        this.fetchPlan = fetchPlan;
        this.fetchDepth = fetchDepth;
        this.queriedRelationships = queriedRelationships != null ? queriedRelationships : new HashSet();
        Object mfd = forceQuery.getHints("MAX_FETCH_DEPTH");
        int n = mfd != null ? (Integer)mfd : (maxDepth = fetchPlan != null ? fetchPlan.getMaxFetchDepth() : forceQuery.getExecutionContext().getOMFContext().getPersistenceConfiguration().getIntProperty("datanucleus.maxFetchDepth"));
        if (maxDepth > 5) {
            throw new NucleusException("Max fetch depth cannot be greater than 5.");
        }
        int n2 = this.maxFetchDepth = maxDepth >= 0 ? maxDepth : 5;
        if (parent != null) {
            this.aliasToFilterMappings = parent.aliasToFilterMappings;
            this.relatedJoinAliases = parent.relatedJoinAliases;
        } else {
            this.initRelatedAliases(compilation);
        }
        this.isInSelect = true;
        this.isTopLevel = parent == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendRelationship(AbstractClassMetaData colCmd, int fieldNum, ColumnImpl col, String prefix, boolean isQuery) {
        AbstractMemberMetaData ammd = colCmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNum);
        AbstractClassMetaData cmd = PersistenceUtils.getMemberElementClassMetaData(ammd, this.forceQuery.getExecutionContext().getClassLoaderResolver(), this.forceQuery.getExecutionContext().getMetaDataManager());
        if (cmd == null) {
            if (prefix != null) {
                this.sb.append(prefix);
            }
            this.sb.append(col.getFieldName());
            return;
        }
        String relationshipString = colCmd.getEntityName() + RELATIONSHIP_SEPARATOR + ammd.getName();
        this.queriedRelationships.add(relationshipString);
        TableImpl joinTable = ((ForceStoreManager)this.forceQuery.getExecutionContext().getStoreManager()).getTable(cmd);
        TableImpl parentTable = this.table;
        AbstractClassMetaData parentCmd = this.acmd;
        this.table = joinTable;
        this.acmd = cmd;
        ++this.fetchDepth;
        try {
            if (isQuery) {
                this.forceQuery.appendRelationshipQuery(this, ammd, col);
            } else {
                this.forceQuery.appendRelationshipFields(this, col, prefix);
            }
        }
        finally {
            this.table = parentTable;
            this.acmd = parentCmd;
            --this.fetchDepth;
        }
    }

    public StringBuilder getBuilder() {
        return this.sb;
    }

    public boolean isJoinQuery() {
        return this.isJoin;
    }

    public Expression getFilterExpression(String alias) {
        return this.aliasToFilterMappings != null ? this.aliasToFilterMappings.get(alias) : (this.isTopLevel && this.compilation != null ? this.compilation.getExprFilter() : null);
    }

    public boolean skipRelationship(AbstractClassMetaData cmd, int fieldNum) {
        if (this.fetchDepth >= this.maxFetchDepth) {
            return true;
        }
        AbstractMemberMetaData ammd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNum);
        String relationshipString = cmd.getEntityName() + RELATIONSHIP_SEPARATOR + ammd.getName();
        return this.queriedRelationships.contains(relationshipString);
    }

    private void initRelatedAliases(QueryCompilation queryCompilation) {
        if (queryCompilation == null || queryCompilation.getExprFilter() == null) {
            return;
        }
        HashMap<String, Expression> ret = new HashMap<String, Expression>();
        HashSet<String> mappingAliases = new HashSet<String>();
        this.createAliasToFilterMappings(queryCompilation.getExprFilter(), ret, mappingAliases);
        if (ret.size() == 0) {
            return;
        }
        this.aliasToFilterMappings = ret;
        if (mappingAliases.size() == 0) {
            return;
        }
        this.relatedJoinAliases = new HashMap<TupleName, String>();
        for (Expression fromExpr : queryCompilation.getExprFrom()) {
            for (Expression expr = fromExpr.getRight(); expr != null; expr = expr.getRight()) {
                if (!(expr instanceof JoinExpression) || !mappingAliases.contains(expr.getAlias())) continue;
                List t = ((JoinExpression)expr).getPrimaryExpression().getTuples();
                this.relatedJoinAliases.put(new TupleName(t), expr.getAlias());
                AbstractMemberMetaData mmd = this.acmd.getMetaDataForMember((String)t.get(t.size() - 1));
                AbstractClassMetaData cmd = PersistenceUtils.getMemberElementClassMetaData(mmd, this.forceQuery.getExecutionContext().getClassLoaderResolver(), this.forceQuery.getExecutionContext().getMetaDataManager());
                PropertySymbol ps = new PropertySymbol(expr.getAlias(), this.forceQuery.getExecutionContext().getClassLoaderResolver().classForName(cmd.getFullClassName()));
                queryCompilation.getSymbolTable().removeSymbol((Symbol)ps);
                queryCompilation.getSymbolTable().addSymbol((Symbol)ps);
            }
        }
    }

    private String createAliasToFilterMappings(Expression expr, Map<String, Expression> map, Set<String> mappingAliases) {
        String leftAlias = null;
        String rightAlias = null;
        if (expr.getLeft() instanceof DyadicExpression) {
            leftAlias = this.createAliasToFilterMappings(expr.getLeft(), map, mappingAliases);
            rightAlias = expr.getRight() instanceof DyadicExpression ? this.createAliasToFilterMappings(expr.getRight(), map, mappingAliases) : this.getAlias(expr.getRight(), mappingAliases);
        } else {
            leftAlias = expr instanceof DyadicExpression ? this.getAliasFromDyadictExpression(expr, mappingAliases) : this.getAlias(expr, mappingAliases);
        }
        if (leftAlias != null) {
            if (rightAlias == null || leftAlias.equals(rightAlias)) {
                map.put(leftAlias, expr);
                return leftAlias;
            }
            map.put(leftAlias, expr.getLeft());
            map.put(rightAlias, expr.getRight());
            return rightAlias;
        }
        if (rightAlias != null) {
            map.put(rightAlias, expr);
            return rightAlias;
        }
        return null;
    }

    private String getAliasFromDyadictExpression(Expression expr, Set<String> mappingAliases) {
        String leftAlias = this.getAlias(expr.getLeft(), mappingAliases);
        String rightAlias = this.getAlias(expr.getRight(), mappingAliases);
        if (leftAlias != null && rightAlias != null && !leftAlias.equals(rightAlias)) {
            throw new NucleusDataStoreException("There cannot be two different aliases in a leaf DyadictExpression: " + expr);
        }
        return leftAlias != null ? leftAlias : rightAlias;
    }

    private String getAlias(Expression expr, Set<String> mappingAliases) {
        if (expr instanceof PrimaryExpression) {
            List tuples = ((PrimaryExpression)expr).getTuples();
            return tuples.size() > 1 ? (String)tuples.get(0) : null;
        }
        if (expr instanceof InvokeExpression) {
            return this.getAliasIfMapExpression((InvokeExpression)expr, mappingAliases);
        }
        return null;
    }

    private String getAliasIfMapExpression(InvokeExpression expr, Set<String> mappingAliases) {
        if ("mapValue".equals(expr.getOperation()) || "mapKey".equals(expr.getOperation()) || "mapEntry".equals(expr.getOperation())) {
            String alias = expr.getLeft().getSymbol().getQualifiedName();
            mappingAliases.add(alias);
            return alias;
        }
        return this.getAlias(expr.getLeft(), mappingAliases);
    }
}

