/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.jpa.exception;

import com.sforce.soap.partner.fault.ApiFault;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.query.NoQueryResultsException;

public final class ForceApiExceptionMap {
    private ForceApiExceptionMap() {
    }

    public static NucleusException mapToNucleusException(ApiFault af, boolean isQuery, boolean isOptimistic) {
        switch (af.getExceptionCode()) {
            case INVALID_QUERY_FILTER_OPERATOR: {
                if (isQuery) {
                    String exceptionMsg = af.getExceptionMessage();
                    if (exceptionMsg != null && exceptionMsg.contains("invalid ID field")) {
                        return new NoQueryResultsException("invalid ID field");
                    }
                    return new NucleusUserException(af.toString(), (Throwable)af);
                }
                return new NucleusObjectNotFoundException();
            }
            case INVALID_SOAP_HEADER: {
                if (!isOptimistic) break;
                return new NucleusDataStoreException("Your organization does not have the necessary permissions to use optimistic transactions. Please contact salesforce.com to have this permission enabled.");
            }
        }
        return new NucleusDataStoreException(af.toString(), (Throwable)af);
    }
}

