/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.jpa;

import com.force.sdk.connector.ForceConnectorConfig;
import com.force.sdk.connector.ForceConnectorUtils;
import com.force.sdk.jpa.ForceConnectionFactory;
import com.force.sdk.jpa.ForceManagedConnection;
import com.force.sdk.jpa.ForceMetaDataListener;
import com.force.sdk.jpa.ForcePersistenceHandler;
import com.force.sdk.jpa.ForcePluginRegistry;
import com.force.sdk.jpa.NativeConnection;
import com.force.sdk.jpa.schema.ForceSchemaWriter;
import com.force.sdk.jpa.schema.ForceStoreSchemaHandler;
import com.force.sdk.jpa.schema.SchemaDeleteProperty;
import com.force.sdk.jpa.table.TableImpl;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.OMFContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.MetaDataListener;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.plugin.PluginRegistry;
import org.datanucleus.store.AbstractStoreManager;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.NucleusConnection;
import org.datanucleus.store.StoreManager;

public class ForceStoreManager
extends AbstractStoreManager {
    public static final String FORCE_KEY = "force";
    private static final String FORCE_PREFIX = "force://";
    private ForceConnectorConfig config;
    private boolean autoCreateTables = false;
    private boolean autoCreateColumns = false;
    private boolean autoCreateWarnOnError = false;
    private int poolTimeBetweenEvictionRunsMillis;
    private int poolMinEvictableIdleTimeMillis;
    ForceMetaDataListener metadataListener;
    private final boolean enableOptimisticTransactions;
    private ForceSchemaWriter schemaWriter;
    private final boolean forDelete;

    public String getConnectionURL() {
        String connectionUrl = super.getConnectionURL();
        if (ForceConnectorUtils.isInjectable((String)connectionUrl) && ((connectionUrl = ForceConnectorUtils.extractValue((String)connectionUrl)) == null || connectionUrl.equals(""))) {
            throw new IllegalArgumentException("Unable to load ForceConnectorConfig from environment or system property " + super.getConnectionURL());
        }
        return connectionUrl;
    }

    public ForceStoreManager(ClassLoaderResolver clr, OMFContext omfContext) throws NoSuchFieldException, IllegalAccessException {
        super(FORCE_KEY, clr, omfContext);
        Object isEnabled;
        String endpoint = this.getConnectionURL();
        if (endpoint != null) {
            this.config = new ForceConnectorConfig();
            if (endpoint.startsWith(FORCE_PREFIX)) {
                this.config.setConnectionUrl(endpoint);
            } else {
                this.config.setAuthEndpoint(endpoint);
                this.config.setUsername(this.getConnectionUserName());
                this.config.setPassword(this.getConnectionPassword());
            }
        }
        this.setCustomPluginManager();
        this.metadataListener = new ForceMetaDataListener(this);
        omfContext.getMetaDataManager().registerListener((MetaDataListener)this.metadataListener);
        this.persistenceHandler2 = new ForcePersistenceHandler((StoreManager)this);
        this.schemaHandler = new ForceStoreSchemaHandler(this);
        PersistenceConfiguration conf = omfContext.getPersistenceConfiguration();
        boolean autoCreateSchema = conf.getBooleanProperty("datanucleus.autoCreateSchema");
        if (autoCreateSchema) {
            this.autoCreateTables = true;
            this.autoCreateColumns = true;
        } else {
            this.autoCreateTables = conf.getBooleanProperty("datanucleus.autoCreateTables");
            this.autoCreateColumns = conf.getBooleanProperty("datanucleus.autoCreateColumns");
        }
        this.autoCreateWarnOnError = conf.getBooleanProperty("datanucleus.autoCreateWarnOnError");
        this.forDelete = conf.getBooleanProperty("force.deleteSchema");
        boolean purgeOnDelete = conf.getBooleanProperty("force.purgeOnDeleteSchema");
        this.schemaWriter = new ForceSchemaWriter(new SchemaDeleteProperty(this.forDelete, purgeOnDelete));
        this.poolTimeBetweenEvictionRunsMillis = conf.getIntProperty("datanucleus.connectionPool.timeBetweenEvictionRunsMillis");
        if (this.poolTimeBetweenEvictionRunsMillis == 0) {
            this.poolTimeBetweenEvictionRunsMillis = 15000;
        }
        this.poolMinEvictableIdleTimeMillis = conf.getIntProperty("datanucleus.connectionPool.minEvictableIdleTimeMillis");
        if (this.poolMinEvictableIdleTimeMillis == 0) {
            this.poolMinEvictableIdleTimeMillis = 30000;
        }
        this.enableOptimisticTransactions = (isEnabled = omfContext.getPersistenceConfiguration().getProperty("datanucleus.Optimistic")) != null && (isEnabled instanceof Boolean && isEnabled.equals(Boolean.TRUE) || isEnabled instanceof String && "true".equals(isEnabled));
        this.logConfiguration();
    }

    private void setCustomPluginManager() throws NoSuchFieldException, IllegalAccessException {
        PluginManager pluginMgr = this.omfContext.getPluginManager();
        Field registryField = PluginManager.class.getDeclaredField("registry");
        registryField.setAccessible(true);
        registryField.set(pluginMgr, new ForcePluginRegistry((PluginRegistry)registryField.get(pluginMgr)));
    }

    protected void registerConnectionMgr() {
        super.registerConnectionMgr();
        this.connectionMgr.disableConnectionPool();
    }

    public ForceConnectorConfig getConfig() {
        return this.config;
    }

    public void close() {
        this.omfContext.getMetaDataManager().deregisterListener((MetaDataListener)this.metadataListener);
        super.close();
    }

    public NucleusConnection getNucleusConnection(ExecutionContext om) {
        return new NativeConnection(this.getConnection(om));
    }

    public Collection getSupportedOptions() {
        HashSet<String> set = new HashSet<String>();
        set.add("ApplicationIdentity");
        set.add("OptimisticTransaction");
        set.add("TransactionIsolationLevel.read-committed");
        return set;
    }

    public boolean isAutoCreateColumns() {
        return this.autoCreateColumns;
    }

    public boolean isAutoCreateTables() {
        return this.autoCreateTables;
    }

    public boolean isAutoCreateWarnOnError() {
        return this.autoCreateWarnOnError;
    }

    public int getPoolMinEvictableIdleTimeMillis() {
        return this.poolMinEvictableIdleTimeMillis;
    }

    public int getPoolTimeBetweenEvictionRunsMillis() {
        return this.poolTimeBetweenEvictionRunsMillis;
    }

    public TableImpl getTable(AbstractClassMetaData acmd) {
        ForceStoreSchemaHandler sh = (ForceStoreSchemaHandler)this.getSchemaHandler();
        return sh.getTable(acmd);
    }

    public TableImpl addTable(AbstractClassMetaData acmd, ForceManagedConnection mconn) {
        ForceStoreSchemaHandler sh = (ForceStoreSchemaHandler)this.getSchemaHandler();
        return sh.addTable(acmd, mconn);
    }

    public TableImpl addVirtualTable(AbstractClassMetaData acmd) {
        ForceStoreSchemaHandler sh = (ForceStoreSchemaHandler)this.getSchemaHandler();
        return sh.addVirtualTable(acmd);
    }

    public boolean isEnableOptimisticTransactions() {
        return this.enableOptimisticTransactions;
    }

    public ForceMetaDataListener getMetaDataListener() {
        return this.metadataListener;
    }

    public ForceManagedConnection createConnection() {
        ForceConnectionFactory connFactory = (ForceConnectionFactory)this.getConnectionManager().lookupConnectionFactory(FORCE_KEY);
        return (ForceManagedConnection)connFactory.createManagedConnection(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preInitialiseFileMetaData(Collection<AbstractClassMetaData> classes) {
        ForceManagedConnection mconn = this.createConnection();
        try {
            ((ForceStoreSchemaHandler)this.getSchemaHandler()).cacheDescribeSObjects(classes, mconn);
        }
        finally {
            mconn.release();
        }
    }

    void postInitialiseFileMetaData() {
        ((ForceStoreSchemaHandler)this.getSchemaHandler()).clearDescribeSObjects();
    }

    public ForceSchemaWriter getSchemaWriter() {
        return this.schemaWriter;
    }

    public boolean isForDelete() {
        return this.forDelete;
    }
}

