/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.jpa;

import com.force.sdk.jpa.ForceEntityManager;
import com.force.sdk.jpa.ForceFetchFieldManager;
import com.force.sdk.jpa.ForceInsertFieldManager;
import com.force.sdk.jpa.ForceManagedConnection;
import com.force.sdk.jpa.ForceObjectManagerImpl;
import com.force.sdk.jpa.ForceStoreManager;
import com.force.sdk.jpa.exception.ForceApiExceptionMap;
import com.force.sdk.jpa.table.TableImpl;
import com.sforce.soap.partner.ConditionalRequestHeader_element;
import com.sforce.soap.partner.DeleteResult;
import com.sforce.soap.partner.EmptyRecycleBinResult;
import com.sforce.soap.partner.Error;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.soap.partner.QueryResult;
import com.sforce.soap.partner.SaveResult;
import com.sforce.soap.partner.StatusCode;
import com.sforce.soap.partner.fault.ApiFault;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.bind.CalendarCodec;
import com.sforce.ws.bind.XmlObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.state.ObjectProviderImpl;
import org.datanucleus.store.AbstractPersistenceHandler;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.fieldmanager.FieldManager;

public class ForcePersistenceHandler
extends AbstractPersistenceHandler {
    protected final ForceStoreManager storeManager;

    public ForcePersistenceHandler(StoreManager storeManager) {
        this.storeManager = (ForceStoreManager)storeManager;
    }

    public void close() {
    }

    public void deleteObject(ObjectProvider op) {
        this.storeManager.assertReadOnlyForUpdateOfObject(op);
        ForceManagedConnection mconn = (ForceManagedConnection)this.storeManager.getConnection(op.getExecutionContext());
        ObjectManager om = ((ObjectProviderImpl)op).getStateManager().getObjectManager();
        boolean isAllOrNothingMode = om instanceof ForceObjectManagerImpl && ((ForceObjectManagerImpl)om).isInAllOrNothingMode();
        try {
            Object pkValue = op.provideField(op.getClassMetaData().getPKMemberPositions()[0]);
            if (!isAllOrNothingMode) {
                if (ForceEntityManager.LOGGER.isDebugEnabled()) {
                    ForceEntityManager.LOGGER.debug("Deleting object: " + pkValue);
                }
                DeleteResult[] results = ((PartnerConnection)mconn.getConnection()).delete(new String[]{(String)pkValue});
                ForcePersistenceHandler.checkForErrors(results);
            } else {
                if (ForceEntityManager.LOGGER.isDebugEnabled()) {
                    ForceEntityManager.LOGGER.debug("Queuing for A-O-N delete object: " + pkValue);
                }
                ((ForceObjectManagerImpl)om).addToDeleteList((String)pkValue);
            }
        }
        catch (ApiFault af) {
            throw ForceApiExceptionMap.mapToNucleusException(af, false, this.storeManager.isEnableOptimisticTransactions());
        }
        catch (NucleusOptimisticException noe) {
            throw noe;
        }
        catch (ConnectionException x) {
            throw new NucleusDataStoreException(x.getMessage(), (Throwable)x);
        }
        finally {
            mconn.release();
        }
    }

    public void fetchObject(ObjectProvider op, int[] fieldNumbers) {
        ForceManagedConnection mconn = (ForceManagedConnection)this.storeManager.getConnection(op.getExecutionContext());
        try {
            ForceFetchFieldManager fm;
            int pkPosition = op.getClassMetaData().getPKMemberPositions()[0];
            if (fieldNumbers.length == 1 && fieldNumbers[0] == pkPosition) {
                XmlObject sObject = new XmlObject();
                sObject.addField("Id", op.provideField(pkPosition));
                fm = new ForceFetchFieldManager(op, this.storeManager, mconn, sObject, null);
            } else {
                fm = new ForceFetchFieldManager(op, this.storeManager, mconn, op.provideField(pkPosition), fieldNumbers, null);
            }
            op.replaceFields(fieldNumbers, (FieldManager)fm);
        }
        catch (ApiFault af) {
            throw ForceApiExceptionMap.mapToNucleusException(af, false, this.storeManager.isEnableOptimisticTransactions());
        }
        catch (NucleusObjectNotFoundException onf) {
            throw onf;
        }
        catch (Exception x) {
            throw new NucleusDataStoreException(x.getMessage(), (Throwable)x);
        }
        finally {
            mconn.release();
        }
    }

    public Object findObject(ExecutionContext ectx, Object id) {
        return null;
    }

    public void insertObject(ObjectProvider op) {
        this.upsert(op, null);
    }

    public void locateObject(ObjectProvider op) {
        ForceManagedConnection mconn = (ForceManagedConnection)this.storeManager.getConnection(op.getExecutionContext());
        try {
            AbstractClassMetaData acmd = op.getClassMetaData();
            TableImpl table = this.storeManager.getTable(acmd);
            QueryResult qr = ((PartnerConnection)mconn.getConnection()).query("select count() from " + table.getTableName().getForceApiName() + " where id='" + op.provideField(op.getClassMetaData().getPKMemberPositions()[0]) + "'");
            if (qr.getSize() == 0) {
                throw new NucleusObjectNotFoundException();
            }
        }
        catch (ConnectionException x) {
            throw new NucleusDataStoreException(x.getMessage(), (Throwable)x);
        }
        finally {
            mconn.release();
        }
    }

    public void updateObject(ObjectProvider op, int[] fieldNumbers) {
        this.upsert(op, fieldNumbers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createObjects(Collection<SObject> objects, Collection<ObjectProvider> objectProviders, ExecutionContext ec) {
        ForceManagedConnection mconn = (ForceManagedConnection)this.storeManager.getConnection(ec);
        try {
            Object[] toSave = objects.toArray(new SObject[objects.size()]);
            if (ForceEntityManager.LOGGER.isDebugEnabled()) {
                ForceEntityManager.LOGGER.debug("Creating objects: " + ForcePersistenceHandler.toString(toSave, false, null));
            }
            PartnerConnection connection = (PartnerConnection)mconn.getConnection();
            connection.setAllOrNoneHeader(true);
            try {
                Object[] results = connection.create((SObject[])toSave);
                this.checkForErrors((SaveResult[])results);
                int i = 0;
                for (ObjectProvider op : objectProviders) {
                    op.setPostStoreNewObjectId((Object)results[i++].getId());
                }
                if (ForceEntityManager.LOGGER.isDebugEnabled()) {
                    ForceEntityManager.LOGGER.debug("Created objects: " + ForcePersistenceHandler.toString(results, false, null));
                }
            }
            finally {
                connection.setAllOrNoneHeader(false);
            }
        }
        catch (NucleusOptimisticException noe) {
            throw noe;
        }
        catch (NucleusUserException nue) {
            throw nue;
        }
        catch (Exception x) {
            throw new NucleusDataStoreException(x.getMessage(), (Throwable)x);
        }
        finally {
            mconn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObjects(SObject[] objects, Calendar[] versions, ExecutionContext ec) {
        ForceManagedConnection mconn = (ForceManagedConnection)this.storeManager.getConnection(ec);
        try {
            if (ForceEntityManager.LOGGER.isDebugEnabled()) {
                ForceEntityManager.LOGGER.debug("Updating objects: " + ForcePersistenceHandler.toString(objects, true, null));
            }
            PartnerConnection connection = this.getPartnerConnection(mconn, versions);
            connection.setAllOrNoneHeader(true);
            try {
                SaveResult[] results = connection.update(objects);
                this.checkForErrors(results);
            }
            finally {
                try {
                    connection.setAllOrNoneHeader(false);
                }
                finally {
                    connection.clearConditionalRequestHeader();
                }
            }
        }
        catch (ApiFault af) {
            throw ForceApiExceptionMap.mapToNucleusException(af, false, this.storeManager.isEnableOptimisticTransactions());
        }
        catch (NucleusOptimisticException noe) {
            throw noe;
        }
        catch (NucleusUserException nue) {
            throw nue;
        }
        catch (Exception x) {
            throw new NucleusDataStoreException(x.getMessage(), (Throwable)x);
        }
        finally {
            mconn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObjects(String[] objects, ExecutionContext ec) {
        ForceManagedConnection mconn = (ForceManagedConnection)this.storeManager.getConnection(ec);
        try {
            if (ForceEntityManager.LOGGER.isDebugEnabled()) {
                ForceEntityManager.LOGGER.debug("Deleting objects: " + Arrays.toString(objects));
            }
            PartnerConnection connection = (PartnerConnection)mconn.getConnection();
            connection.setAllOrNoneHeader(true);
            try {
                DeleteResult[] results = connection.delete(objects);
                ForcePersistenceHandler.checkForErrors(results);
            }
            finally {
                connection.setAllOrNoneHeader(false);
            }
        }
        catch (ApiFault af) {
            throw ForceApiExceptionMap.mapToNucleusException(af, false, this.storeManager.isEnableOptimisticTransactions());
        }
        catch (NucleusOptimisticException noe) {
            throw noe;
        }
        catch (NucleusUserException nue) {
            throw nue;
        }
        catch (Exception x) {
            throw new NucleusDataStoreException(x.getMessage(), (Throwable)x);
        }
        finally {
            mconn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upsert(ObjectProvider op, int[] fieldNumbers) {
        block25: {
            if (op.getClassMetaData().isEmbeddedOnly()) {
                return;
            }
            this.storeManager.assertReadOnlyForUpdateOfObject(op);
            if (!this.storeManager.managesClass(op.getClassMetaData().getFullClassName())) {
                this.storeManager.addClass(op.getClassMetaData().getFullClassName(), op.getExecutionContext().getClassLoaderResolver());
            }
            ForceManagedConnection mconn = (ForceManagedConnection)this.storeManager.getConnection(op.getExecutionContext());
            try {
                SObject toSave;
                boolean isAllOrNothingMode;
                ForceInsertFieldManager fm = new ForceInsertFieldManager(op, this.storeManager, fieldNumbers != null ? op.provideField(op.getClassMetaData().getPKMemberPositions()[0]) : null);
                op.provideFields(fieldNumbers != null ? fieldNumbers : op.getClassMetaData().getAllMemberPositions(), (FieldManager)fm);
                if (!fm.isDirty()) {
                    return;
                }
                ObjectManager om = ((ObjectProviderImpl)op).getStateManager().getObjectManager();
                boolean bl = isAllOrNothingMode = om instanceof ForceObjectManagerImpl && ((ForceObjectManagerImpl)om).isInAllOrNothingMode();
                if (!isAllOrNothingMode) {
                    PartnerConnection connection = this.getPartnerConnection(mconn, op);
                    try {
                        SObject toSave2 = fm.getSObject(false);
                        if (ForceEntityManager.LOGGER.isDebugEnabled()) {
                            if (fieldNumbers != null) {
                                ForceEntityManager.LOGGER.debug("Updating object: " + toSave2.getType() + " id: " + toSave2.getId());
                            } else {
                                ForceEntityManager.LOGGER.debug("Creating object: " + toSave2.getType());
                            }
                        }
                        SaveResult[] results = fieldNumbers != null ? connection.update(new SObject[]{toSave2}) : ((PartnerConnection)mconn.getConnection()).create(new SObject[]{toSave2});
                        this.checkForErrors(results);
                        if (fieldNumbers == null) {
                            op.setPostStoreNewObjectId((Object)results[0].getId());
                            if (ForceEntityManager.LOGGER.isDebugEnabled()) {
                                ForceEntityManager.LOGGER.debug("Created object id: " + results[0].getId());
                            }
                        }
                        break block25;
                    }
                    finally {
                        connection.clearConditionalRequestHeader();
                    }
                }
                if (fieldNumbers != null) {
                    toSave = fm.getSObject(false);
                    ((ForceObjectManagerImpl)om).addToUpdateList(toSave, op.getVersion() != null ? (Calendar)op.getVersion() : ForcePersistenceHandler.getVersionForUnversioned());
                } else {
                    toSave = fm.getSObject(true);
                    ((ForceObjectManagerImpl)om).addToCreateList(toSave, op);
                }
                if (ForceEntityManager.LOGGER.isDebugEnabled()) {
                    if (fieldNumbers != null) {
                        ForceEntityManager.LOGGER.debug("Queuing for A-O-N update object: " + toSave.getType() + " id: " + toSave.getId());
                    } else {
                        ForceEntityManager.LOGGER.debug("Queuing for A-O-N create object: " + toSave.getType());
                    }
                }
            }
            catch (ApiFault af) {
                throw ForceApiExceptionMap.mapToNucleusException(af, false, this.storeManager.isEnableOptimisticTransactions());
            }
            catch (NucleusException ne) {
                throw ne;
            }
            catch (Exception x) {
                throw new NucleusDataStoreException(x.getMessage(), (Throwable)x);
            }
            finally {
                mconn.release();
            }
        }
    }

    private static Calendar getVersionForUnversioned() {
        long time = System.currentTimeMillis() + 3600000L;
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        return cal;
    }

    private PartnerConnection getPartnerConnection(ForceManagedConnection mconn, ObjectProvider op) {
        PartnerConnection connection = (PartnerConnection)mconn.getConnection();
        if (op.getVersion() != null && this.storeManager.isEnableOptimisticTransactions()) {
            ConditionalRequestHeader_element ch = new ConditionalRequestHeader_element();
            ch.setIfModifiedBefore((Calendar)op.getVersion());
            connection.__setConditionalRequestHeader(ch);
            if (ForceEntityManager.LOGGER.isDebugEnabled()) {
                ForceEntityManager.LOGGER.debug("Conditional header set to: " + new CalendarCodec().getValueAsString((Object)ch.getIfModifiedBefore()));
            }
        }
        return connection;
    }

    private PartnerConnection getPartnerConnection(ForceManagedConnection mconn, Calendar[] versions) {
        PartnerConnection connection = (PartnerConnection)mconn.getConnection();
        if (versions.length > 0 && this.storeManager.isEnableOptimisticTransactions()) {
            ConditionalRequestHeader_element ch = new ConditionalRequestHeader_element();
            ch.setIfModifiedBeforeArray(versions);
            connection.__setConditionalRequestHeader(ch);
            if (ForceEntityManager.LOGGER.isDebugEnabled()) {
                ForceEntityManager.LOGGER.debug("Conditional header set to: " + ForcePersistenceHandler.toString(ch.getIfModifiedBeforeArray(), false, new CalendarCodec()));
            }
        }
        return connection;
    }

    private void checkForErrors(SaveResult[] results) {
        ArrayList<Error> failures = null;
        boolean optimisticFailure = false;
        for (SaveResult sr : results) {
            if (sr.getSuccess()) continue;
            if (failures == null) {
                failures = new ArrayList<Error>();
            }
            optimisticFailure = ForcePersistenceHandler.handleError(failures, sr.getErrors()[0]);
        }
        ForcePersistenceHandler.handleFailures(failures, optimisticFailure);
    }

    private static boolean handleError(List<Error> failures, Error error) {
        failures.add(error);
        return error.getStatusCode() == StatusCode.ENTITY_FAILED_IFLASTMODIFIED_ON_UPDATE;
    }

    private static void handleFailures(List<Error> failures, boolean optimisticFailure) {
        if (failures != null) {
            Iterator<Error> iter = failures.iterator();
            while (iter.hasNext()) {
                Error error = iter.next();
                if (error.getStatusCode() != StatusCode.ALL_OR_NONE_OPERATION_ROLLED_BACK || failures.size() <= 1) continue;
                iter.remove();
            }
            if (optimisticFailure) {
                throw new NucleusOptimisticException(failures.get(0).getMessage(), (Object)(failures.size() == 1 ? failures.get(0) : failures.toArray(new Error[failures.size()])));
            }
            throw new NucleusUserException(failures.get(0).getMessage(), (Object)(failures.size() == 1 ? failures.get(0) : failures.toArray(new Error[failures.size()])));
        }
    }

    public static void checkForErrors(DeleteResult[] results) {
        ArrayList<Error> failures = null;
        boolean optimisticFailure = false;
        for (DeleteResult dr : results) {
            if (dr.getSuccess()) continue;
            if (failures == null) {
                failures = new ArrayList<Error>();
            }
            optimisticFailure = ForcePersistenceHandler.handleError(failures, dr.getErrors()[0]);
        }
        ForcePersistenceHandler.handleFailures(failures, optimisticFailure);
    }

    public static void checkForRecycleBinErrors(EmptyRecycleBinResult[] results) {
        ArrayList<Error> failures = null;
        boolean optimisticFailure = false;
        for (EmptyRecycleBinResult dr : results) {
            if (dr.getSuccess()) continue;
            if (failures == null) {
                failures = new ArrayList<Error>();
            }
            optimisticFailure = ForcePersistenceHandler.handleError(failures, dr.getErrors()[0]);
        }
        ForcePersistenceHandler.handleFailures(failures, optimisticFailure);
    }

    private static String toString(Object[] objects, boolean isUpdate, CalendarCodec cCodec) {
        StringBuilder sb = new StringBuilder(objects.length * 40);
        sb.append("[");
        for (Object obj : objects) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            if (obj instanceof SObject) {
                SObject s = (SObject)obj;
                sb.append("entity: ").append(s.getType());
                if (!isUpdate) continue;
                sb.append(" id: ").append(s.getId());
                continue;
            }
            if (obj instanceof SaveResult) {
                sb.append(((SaveResult)obj).getId());
                continue;
            }
            if (!(obj instanceof Calendar)) continue;
            sb.append(cCodec.getValueAsString(obj));
        }
        sb.append("]");
        return sb.toString();
    }
}

