/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.jpa;

import com.force.sdk.jpa.ForceJPAStateManagerImpl;
import com.force.sdk.jpa.ForcePersistenceHandler;
import com.sforce.soap.partner.sobject.SObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.ObjectManagerImpl;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.store.ObjectProvider;

public class ForceObjectManagerImpl
extends ObjectManagerImpl {
    private final boolean allOrNothingEnabled;
    private boolean inAllOrNothingMode;
    private LinkedHashMap<ObjectProvider, SObject> createObjectList;
    private IdentityHashMap<Object, SObject> pcToSObject;
    private List<SObject> updateObjectList;
    private List<Calendar> versionList;
    private List<String> deleteObjectList;

    public ForceObjectManagerImpl(ObjectManagerFactoryImpl omf, Object owner, String userName, String password) {
        super(omf, owner, userName, password);
        this.allOrNothingEnabled = omf.getOMFContext().getPersistenceConfiguration().getBooleanProperty("force.AllOrNothing");
    }

    public boolean isInAllOrNothingMode() {
        return this.allOrNothingEnabled && this.inAllOrNothingMode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void flushInternal(boolean flushToDatastore) {
        if (flushToDatastore && this.allOrNothingEnabled) {
            this.inAllOrNothingMode = true;
            try {
                super.flushInternal(flushToDatastore);
                if (this.createObjectList != null) {
                    ((ForcePersistenceHandler)this.getStoreManager().getPersistenceHandler()).createObjects(this.createObjectList.values(), this.createObjectList.keySet(), this.getExecutionContext());
                }
                if (this.updateObjectList != null) {
                    ((ForcePersistenceHandler)this.getStoreManager().getPersistenceHandler()).updateObjects(this.updateObjectList.toArray(new SObject[this.updateObjectList.size()]), this.versionList.toArray(new Calendar[this.versionList.size()]), this.getExecutionContext());
                }
                if (this.deleteObjectList == null) return;
                ((ForcePersistenceHandler)this.getStoreManager().getPersistenceHandler()).deleteObjects(this.deleteObjectList.toArray(new String[this.deleteObjectList.size()]), this.getExecutionContext());
                return;
            }
            catch (NucleusOptimisticException noe) {
                throw new NucleusOptimisticException(LOCALISER.msg("010031"), noe.getFailedObject());
            }
            finally {
                this.inAllOrNothingMode = false;
                this.createObjectList = null;
                this.updateObjectList = null;
                this.versionList = null;
                this.deleteObjectList = null;
            }
        } else {
            super.flushInternal(flushToDatastore);
        }
    }

    public synchronized SObject getParentSObject(Object parent) {
        SObject parentSObject;
        if (this.pcToSObject == null || (parentSObject = this.pcToSObject.get(parent)) == null) {
            throw new NucleusDataStoreException("Parent entity has not been saved");
        }
        return parentSObject;
    }

    public synchronized void addToCreateList(SObject object, ObjectProvider op) {
        if (this.createObjectList == null) {
            this.createObjectList = new LinkedHashMap();
            this.pcToSObject = new IdentityHashMap();
        }
        this.createObjectList.put(op, object);
        this.pcToSObject.put(op.getObject(), object);
    }

    public synchronized void addToUpdateList(SObject object, Calendar version) {
        if (this.updateObjectList == null) {
            this.updateObjectList = new ArrayList<SObject>();
            this.versionList = new ArrayList<Calendar>();
        }
        this.updateObjectList.add(object);
        if (version != null) {
            this.versionList.add(version);
        }
    }

    public synchronized void addToDeleteList(String id) {
        if (this.deleteObjectList == null) {
            this.deleteObjectList = new ArrayList<String>();
        }
        this.deleteObjectList.add(id);
    }

    public synchronized void markDirty(StateManager sm, boolean directUpdate) {
        if (!(sm instanceof ForceJPAStateManagerImpl)) {
            super.markDirty(sm, directUpdate);
        }
    }

    public synchronized void postRollback() {
        try {
            super.postRollback();
        }
        catch (NucleusObjectNotFoundException nucleusObjectNotFoundException) {
            // empty catch block
        }
    }

    public synchronized void detachObject(Object obj, FetchPlanState state) {
        StateManager sm = this.findStateManager(obj);
        super.detachObject(obj, state);
        if (sm != null) {
            this.clearDirty(sm);
        }
    }
}

