/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.jpa;

import com.force.sdk.jpa.ForceEntityTransactionImpl;
import com.force.sdk.jpa.ForceJPAStateManagerImpl;
import com.force.sdk.jpa.query.ForceQueryUtils;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.spi.PersistenceCapable;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceException;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.jpa.EntityManagerImpl;
import org.datanucleus.jpa.JPAQuery;
import org.datanucleus.jpa.NucleusJPAHelper;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.QueryResultMetaData;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForceEntityManager
extends EntityManagerImpl {
    private static final String SOQL_LANGUAGE = "SOQL";
    private static final Calendar EPOCH_TIME = new GregorianCalendar(1970, 0, 1, 0, 0, 0);
    static final Logger LOGGER = LoggerFactory.getLogger((String)"com.force.sdk.jpa");

    public ForceEntityManager(EntityManagerFactory emf, PersistenceManagerFactory pmf, PersistenceContextType contextType) {
        super(emf, pmf, contextType);
        if (this.tx != null) {
            this.tx = new ForceEntityTransactionImpl(this.om);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("EntityManager created: " + (Object)((Object)this));
        }
    }

    public void joinTransaction() {
        this.assertIsOpen();
        this.tx = new ForceEntityTransactionImpl(this.om);
    }

    public void close() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("EntityManager close: " + (Object)((Object)this));
        }
        super.close();
    }

    public void clear() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("EntityManager clear: " + (Object)((Object)this));
        }
        super.clear();
    }

    public void injectStateManagerIntoTransient(PersistenceCapable pc) {
        AbstractClassMetaData acmd = this.om.getMetaDataManager().getMetaDataForClass(pc.getClass(), this.om.getClassLoaderResolver());
        ForceJPAStateManagerImpl sm = new ForceJPAStateManagerImpl(this.om, acmd);
        sm.initialiseForHollowPreConstructed(null, pc);
        this.om.putObjectIntoCache((StateManager)sm);
        if (acmd.hasVersionStrategy()) {
            sm.setVersion(EPOCH_TIME);
        }
    }

    public javax.persistence.Query createNativeQuery(String soqlString, Class resultClass) {
        this.assertIsOpen();
        try {
            Query internalQuery = this.om.getOMFContext().getQueryManager().newQuery(SOQL_LANGUAGE, this.om.getExecutionContext(), (Object)soqlString);
            if (resultClass != null) {
                internalQuery.setResultClass(resultClass);
            }
            return new JPAQuery((EntityManager)this, internalQuery, SOQL_LANGUAGE);
        }
        catch (NucleusException ne) {
            throw new IllegalArgumentException(ne.getMessage(), ne);
        }
    }

    public javax.persistence.Query createNativeQuery(String soqlString, String resultSetMapping) {
        this.assertIsOpen();
        try {
            Query internalQuery = this.om.getOMFContext().getQueryManager().newQuery(SOQL_LANGUAGE, this.om.getExecutionContext(), (Object)soqlString);
            QueryResultMetaData qrmd = this.om.getMetaDataManager().getMetaDataForQueryResult(resultSetMapping);
            if (qrmd == null) {
                throw new IllegalArgumentException("ResultSetMapping " + resultSetMapping + " is not found");
            }
            internalQuery.setResultMetaData(qrmd);
            return new JPAQuery((EntityManager)this, internalQuery, SOQL_LANGUAGE);
        }
        catch (NucleusException ne) {
            throw new IllegalArgumentException(ne.getMessage(), ne);
        }
    }

    public void persist(Object entity) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("JPA Persist - entity: " + entity);
        }
        if (entity instanceof PersistenceCapable) {
            StateManager sm;
            PersistenceCapable pc = (PersistenceCapable)entity;
            if (pc.jdoIsDetached()) {
                this.throwException((RuntimeException)new EntityExistsException("Entity already exists. Use merge to save changes."));
            }
            if ((sm = this.om.findStateManager(entity)) != null) {
                if (sm instanceof ForceJPAStateManagerImpl) {
                    this.om.clearDirty(sm);
                    this.om.removeStateManager(sm);
                    pc.jdoReplaceStateManager(null);
                } else {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("JPA Persist - entity already persisted doing nothing for entity: " + entity);
                    }
                    return;
                }
            }
        }
        super.persist(entity);
    }

    public Object merge(Object entity) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("JPA Merge: - entity: " + entity);
        }
        if (entity instanceof PersistenceCapable) {
            AbstractClassMetaData acmd;
            Object id;
            PersistenceCapable pc = (PersistenceCapable)entity;
            if (pc.jdoIsDetached() && pc.jdoGetObjectId() == null) {
                throw new IllegalArgumentException("Detached entity with null id cannot be merged.");
            }
            StateManager sm = this.om.findStateManager(entity);
            if (sm != null && (id = ForceQueryUtils.getIdFromObject(pc, acmd = this.om.getMetaDataManager().getMetaDataForClass(entity.getClass(), this.om.getClassLoaderResolver()))) != null && sm instanceof ForceJPAStateManagerImpl) {
                sm.initialiseForDetached((Object)pc, id, sm.getVersion(pc));
                entity = sm.getObject();
            }
        }
        return super.merge(entity);
    }

    public void remove(Object entity) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("JPA Remove - entity: " + entity);
        }
        try {
            super.remove(entity);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().contains(LOCALISER.msg("EM.EntityIsDetached", (Object)StringUtils.toJVMIDString((Object)entity), (Object)("" + this.om.getApiAdapter().getIdForObject(entity))))) {
                throw new IllegalArgumentException(e.getMessage() + " - It has most likely become detached since the find() operation." + " Either put find() and remove() under same transaction or merge() the object first");
            }
            throw e;
        }
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lock, Map<String, Object> properties) {
        Object fetchDepth;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("JPA Find - entity: " + entityClass.getName() + " id: " + primaryKey + " lock: " + lock);
        }
        Object object = fetchDepth = properties != null ? properties.get("MAX_FETCH_DEPTH") : null;
        if (fetchDepth != null && !(fetchDepth instanceof Integer)) {
            throw new IllegalArgumentException("MAX_FETCH_DEPTH requires Integer value");
        }
        Integer oldFetchDepth = null;
        if (fetchDepth != null) {
            oldFetchDepth = this.om.getFetchPlan().getMaxFetchDepth();
            this.om.getFetchPlan().setMaxFetchDepth(((Integer)fetchDepth).intValue());
        }
        try {
            Object object2 = super.find(entityClass, primaryKey, lock, properties);
            return (T)object2;
        }
        catch (NucleusException ne) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException((NucleusException)ne);
        }
        finally {
            if (oldFetchDepth != null) {
                this.om.getFetchPlan().setMaxFetchDepth(oldFetchDepth.intValue());
            }
        }
    }

    public Object getReference(Class entityClass, Object primaryKey) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("JPA getReference - entity: " + entityClass.getName() + " id: " + primaryKey);
        }
        return super.getReference(entityClass, primaryKey);
    }

    public void refresh(Object entity, LockModeType lock, Map<String, Object> properties) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("JPA Refresh - entity: " + entity + " lock: " + lock);
        }
        super.refresh(entity, lock, properties);
    }

    public void flush() {
        if (this.getTransaction().isActive()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("JPA Flush ignored");
            }
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("JPA Flush");
            }
            super.flush();
        }
    }

    public void lock(Object entity, LockModeType lock, Map<String, Object> properties) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("JPA Lock - entity: " + entity + " lock: " + lock);
        }
        super.lock(entity, lock, properties);
    }

    public void detach(Object entity) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("JPA Detach - entity: " + entity);
        }
        super.detach(entity);
    }

    private void assertIsOpen() {
        if (this.om.isClosed()) {
            throw new IllegalStateException(LOCALISER.msg("EM.IsClosed"));
        }
    }

    private Object throwException(RuntimeException re) {
        PersistenceConfiguration conf;
        boolean markForRollback;
        if (re instanceof PersistenceException && (markForRollback = (conf = this.om.getOMFContext().getPersistenceConfiguration()).getBooleanProperty("datanucleus.jpa.txnMarkForRollbackOnException"))) {
            this.getTransaction().setRollbackOnly();
        }
        throw re;
    }
}

