/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.jpa;

import com.force.sdk.connector.ForceConnectorConfig;
import com.force.sdk.connector.ForceServiceConnector;
import com.force.sdk.jpa.ForceManagedConnection;
import com.force.sdk.jpa.ForceStoreManager;
import java.util.Map;
import org.datanucleus.OMFContext;
import org.datanucleus.store.connection.AbstractConnectionFactory;
import org.datanucleus.store.connection.ManagedConnection;

public class ForceConnectionFactory
extends AbstractConnectionFactory {
    public ForceConnectionFactory(OMFContext omfContext, String resourceType) {
        super(omfContext, resourceType);
    }

    public ManagedConnection createManagedConnection(Object poolKey, Map transactionOptions) {
        ForceStoreManager storeManager = (ForceStoreManager)this.omfContext.getStoreManager();
        ForceServiceConnector connector = new ForceServiceConnector();
        ForceConnectorConfig tlConfig = ForceServiceConnector.getThreadLocalConnectorConfig();
        if (tlConfig != null) {
            connector.setConnectorConfig(tlConfig);
        } else {
            connector.setConnectorConfig(storeManager.getConfig());
        }
        connector.setConnectionName(this.omfContext.getPersistenceConfiguration().getStringProperty("force.ConnectionName"));
        connector.setClientId(ForceServiceConnector.API_USER_AGENT);
        connector.setTimeout(this.omfContext.getPersistenceConfiguration().getIntProperty("datanucleus.datastoreReadTimeout"));
        connector.setSkipCache(this.omfContext.getPersistenceConfiguration().getBooleanProperty("force.skipConfigCache", false));
        return new ForceManagedConnection(connector);
    }
}

