/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.data;

import com.deepoove.poi.data.ChartMultiSeriesRenderData;
import com.deepoove.poi.data.ChartSingleSeriesRenderData;
import com.deepoove.poi.data.RenderDataBuilder;
import com.deepoove.poi.data.SeriesRenderData;
import java.util.ArrayList;
import java.util.List;

public class Charts {
    public static ChartMultis ofBar(String chartTitle, String[] categories) {
        return Charts.ofMultiSeries(chartTitle, categories);
    }

    public static ChartMultis ofLine(String chartTitle, String[] categories) {
        return Charts.ofMultiSeries(chartTitle, categories);
    }

    public static ChartMultis ofArea(String chartTitle, String[] categories) {
        return Charts.ofMultiSeries(chartTitle, categories);
    }

    public static ChartMultis ofBar3D(String chartTitle, String[] categories) {
        return Charts.ofMultiSeries(chartTitle, categories);
    }

    public static ChartMultis ofArea3D(String chartTitle, String[] categories) {
        return Charts.ofMultiSeries(chartTitle, categories);
    }

    public static ChartMultis ofLine3D(String chartTitle, String[] categories) {
        return Charts.ofMultiSeries(chartTitle, categories);
    }

    public static ChartMultis ofRadar(String chartTitle, String[] categories) {
        return Charts.ofMultiSeries(chartTitle, categories);
    }

    public static ChartSingles ofPie(String chartTitle, String[] categories) {
        return Charts.ofSingleSeries(chartTitle, categories);
    }

    public static ChartSingles ofPie3D(String chartTitle, String[] categories) {
        return Charts.ofSingleSeries(chartTitle, categories);
    }

    public static ChartSingles ofDoughnut(String chartTitle, String[] categories) {
        return Charts.ofSingleSeries(chartTitle, categories);
    }

    public static ChartMultis ofMultiSeries(String chartTitle, String[] categories) {
        return new ChartMultis(chartTitle, categories);
    }

    public static ChartCombos ofComboSeries(String chartTitle, String[] categories) {
        return new ChartCombos(chartTitle, categories);
    }

    public static ChartSingles ofSingleSeries(String chartTitle, String[] categories) {
        return new ChartSingles(chartTitle, categories);
    }

    public static class ChartSingles
    extends ChartBuilder
    implements RenderDataBuilder<ChartSingleSeriesRenderData> {
        private SeriesRenderData series;

        private ChartSingles(String chartTitle, String[] categories) {
            super(chartTitle, categories);
        }

        public ChartSingles series(String name, Number[] value) {
            this.checkLengh(value.length);
            this.series = new SeriesRenderData(name, value);
            return this;
        }

        @Override
        public ChartSingleSeriesRenderData create() {
            ChartSingleSeriesRenderData data = new ChartSingleSeriesRenderData();
            data.setChartTitle(this.chartTitle);
            data.setCategories(this.categories);
            data.setSeriesData(this.series);
            return data;
        }
    }

    public static class ChartCombos
    extends ChartBuilder
    implements RenderDataBuilder<ChartMultiSeriesRenderData> {
        private List<SeriesRenderData> seriesDatas = new ArrayList<SeriesRenderData>();

        private ChartCombos(String chartTitle, String[] categories) {
            super(chartTitle, categories);
        }

        public ChartCombos addBarSeries(String name, Number[] value) {
            this.addSeries(SeriesRenderData.ComboType.BAR, name, value);
            return this;
        }

        public ChartCombos addLineSeries(String name, Number[] value) {
            this.addSeries(SeriesRenderData.ComboType.LINE, name, value);
            return this;
        }

        public ChartCombos addAreaSeries(String name, Number[] value) {
            this.addSeries(SeriesRenderData.ComboType.AREA, name, value);
            return this;
        }

        private void addSeries(SeriesRenderData.ComboType type, String name, Number[] value) {
            this.checkLengh(value.length);
            SeriesRenderData seriesRenderData = new SeriesRenderData(name, value);
            seriesRenderData.setComboType(type);
            this.seriesDatas.add(seriesRenderData);
        }

        @Override
        public ChartMultiSeriesRenderData create() {
            ChartMultiSeriesRenderData data = new ChartMultiSeriesRenderData();
            data.setChartTitle(this.chartTitle);
            data.setCategories(this.categories);
            data.setSeriesDatas(this.seriesDatas);
            return data;
        }
    }

    public static class ChartMultis
    extends ChartBuilder
    implements RenderDataBuilder<ChartMultiSeriesRenderData> {
        private List<SeriesRenderData> seriesDatas = new ArrayList<SeriesRenderData>();

        private ChartMultis(String chartTitle, String[] categories) {
            super(chartTitle, categories);
        }

        public ChartMultis addSeries(String name, Number[] value) {
            this.checkLengh(value.length);
            this.seriesDatas.add(new SeriesRenderData(name, value));
            return this;
        }

        @Override
        public ChartMultiSeriesRenderData create() {
            ChartMultiSeriesRenderData data = new ChartMultiSeriesRenderData();
            data.setChartTitle(this.chartTitle);
            data.setCategories(this.categories);
            data.setSeriesDatas(this.seriesDatas);
            return data;
        }
    }

    public static abstract class ChartBuilder {
        protected String chartTitle;
        protected String[] categories;

        protected ChartBuilder(String chartTitle, String[] categories) {
            this.chartTitle = chartTitle;
            this.categories = categories;
        }

        protected void checkLengh(int length) {
            if (this.categories.length != length) {
                throw new IllegalArgumentException("The length of categories and series values in chart must be the same!");
            }
        }
    }
}

