/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.NumberingWrapper;
import org.apache.poi.xwpf.usermodel.XWPFAbstractNum;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFNum;
import org.apache.poi.xwpf.usermodel.XWPFNumbering;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.apache.poi.xwpf.usermodel.XWPFStyles;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlToken;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTInline;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTAbstractNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBody;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblBorders;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblGrid;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblGridCol;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblWidth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NiceXWPFDocument
extends XWPFDocument {
    private static Logger logger = LoggerFactory.getLogger(NiceXWPFDocument.class);

    public NiceXWPFDocument() {
    }

    public NiceXWPFDocument(InputStream in) throws IOException {
        super(in);
    }

    public static void mergeCellsHorizonal(XWPFTable table, int row, int fromCol, int toCol) {
        if (toCol <= fromCol) {
            return;
        }
        XWPFTableCell cell = table.getRow(row).getCell(fromCol);
        CTTcPr tcPr = cell.getCTTc().getTcPr();
        if (null == tcPr) {
            tcPr = cell.getCTTc().addNewTcPr();
        }
        XWPFTableRow rowTable = table.getRow(row);
        for (int colIndex = fromCol + 1; colIndex <= toCol; ++colIndex) {
            rowTable.getCtRow().removeTc(colIndex);
            rowTable.removeCell(colIndex);
        }
        NiceXWPFDocument.spanCellsAcrossRow(table, row, fromCol, toCol - fromCol + 1);
    }

    public static void mergeCellsVertically(XWPFTable table, int col, int fromRow, int toRow) {
        for (int rowIndex = fromRow; rowIndex <= toRow; ++rowIndex) {
            XWPFTableCell cell = table.getRow(rowIndex).getCell(col);
            CTTcPr tcPr = cell.getCTTc().getTcPr();
            if (null == tcPr) {
                tcPr = cell.getCTTc().addNewTcPr();
            }
            CTVMerge vMerge = tcPr.addNewVMerge();
            if (rowIndex == fromRow) {
                vMerge.setVal(STMerge.RESTART);
                continue;
            }
            vMerge.setVal(STMerge.CONTINUE);
        }
    }

    private static void spanCellsAcrossRow(XWPFTable table, int rowNum, int colNum, int span) {
        XWPFTableCell cell = table.getRow(rowNum).getCell(colNum);
        cell.getCTTc().getTcPr().addNewGridSpan();
        cell.getCTTc().getTcPr().getGridSpan().setVal(BigInteger.valueOf(span));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XWPFTable insertNewTable(XWPFRun run, int row, int col) {
        XmlCursor cursor = ((XWPFParagraph)run.getParent()).getCTP().newCursor();
        if (this.isCursorInBody(cursor)) {
            String uri = CTTbl.type.getName().getNamespaceURI();
            String localPart = "tbl";
            cursor.beginElement(localPart, uri);
            cursor.toParent();
            CTTbl t = (CTTbl)cursor.getObject();
            XWPFTable newT = new XWPFTable(t, (IBody)this, row, col);
            XmlObject o = null;
            while (!(o instanceof CTTbl) && cursor.toPrevSibling()) {
                o = cursor.getObject();
            }
            if (!(o instanceof CTTbl)) {
                this.tables.add(0, newT);
            } else {
                int pos = this.tables.indexOf(this.getTable((CTTbl)o)) + 1;
                this.tables.add(pos, newT);
            }
            int i = 0;
            XmlCursor tableCursor = t.newCursor();
            try {
                cursor.toCursor(tableCursor);
                while (cursor.toPrevSibling()) {
                    o = cursor.getObject();
                    if (!(o instanceof CTP) && !(o instanceof CTTbl)) continue;
                    ++i;
                }
                this.bodyElements.add(i > this.bodyElements.size() ? this.bodyElements.size() : i, newT);
                cursor.toCursor(tableCursor);
                cursor.toEndToken();
                XWPFTable xWPFTable = newT;
                return xWPFTable;
            }
            finally {
                tableCursor.dispose();
            }
        }
        return null;
    }

    public void widthTable(XWPFTable table, float widthCM, int rows, int cols) {
        int width = (int)((double)widthCM / 2.54 * 1440.0);
        CTTblPr tblPr = table.getCTTbl().getTblPr();
        if (null == tblPr) {
            tblPr = table.getCTTbl().addNewTblPr();
        }
        CTTblWidth tblW = tblPr.isSetTblW() ? tblPr.getTblW() : tblPr.addNewTblW();
        tblW.setType(0 == width ? STTblWidth.AUTO : STTblWidth.DXA);
        tblW.setW(BigInteger.valueOf(width));
        if (0 != width) {
            CTTblGrid tblGrid = table.getCTTbl().getTblGrid();
            if (null == tblGrid) {
                tblGrid = table.getCTTbl().addNewTblGrid();
            }
            for (int j = 0; j < cols; ++j) {
                CTTblGridCol addNewGridCol = tblGrid.addNewGridCol();
                addNewGridCol.setW(BigInteger.valueOf(width / cols));
            }
        }
        CTTblBorders tblBorders = tblPr.getTblBorders();
        tblBorders.getBottom().setSz(BigInteger.valueOf(4L));
        tblBorders.getLeft().setSz(BigInteger.valueOf(4L));
        tblBorders.getTop().setSz(BigInteger.valueOf(4L));
        tblBorders.getRight().setSz(BigInteger.valueOf(4L));
        tblBorders.getInsideH().setSz(BigInteger.valueOf(4L));
        tblBorders.getInsideV().setSz(BigInteger.valueOf(4L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XWPFParagraph insertNewParagraph(XWPFRun run) {
        XmlCursor cursor = ((XWPFParagraph)run.getParent()).getCTP().newCursor();
        if (this.isCursorInBody(cursor)) {
            String uri = CTP.type.getName().getNamespaceURI();
            String localPart = "p";
            cursor.beginElement(localPart, uri);
            cursor.toParent();
            CTP p = (CTP)cursor.getObject();
            XWPFParagraph newP = new XWPFParagraph(p, (IBody)this);
            XmlObject o = null;
            while (!(o instanceof CTP) && cursor.toPrevSibling()) {
                o = cursor.getObject();
            }
            if (!(o instanceof CTP) || (CTP)o == p) {
                this.paragraphs.add(0, newP);
            } else {
                int pos = this.paragraphs.indexOf(this.getParagraph((CTP)o)) + 1;
                this.paragraphs.add(pos, newP);
            }
            XmlCursor newParaPos = p.newCursor();
            try {
                int i = 0;
                cursor.toCursor(newParaPos);
                while (cursor.toPrevSibling()) {
                    o = cursor.getObject();
                    if (!(o instanceof CTP) && !(o instanceof CTTbl)) continue;
                    ++i;
                }
                this.bodyElements.add(i > this.bodyElements.size() ? this.bodyElements.size() : i, newP);
                cursor.toCursor(newParaPos);
                cursor.toEndToken();
                XWPFParagraph xWPFParagraph = newP;
                return xWPFParagraph;
            }
            finally {
                newParaPos.dispose();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCursorInBody(XmlCursor cursor) {
        XmlCursor verify = cursor.newCursor();
        verify.toParent();
        try {
            boolean bl = true;
            return bl;
        }
        finally {
            verify.dispose();
        }
    }

    public void createPicture(String blipId, int id, int width, int height) {
        this.addPicture(blipId, id, width, height, this.createParagraph().createRun());
    }

    public void addPicture(String blipId, int id, int width, int height, XWPFRun run) {
        int EMU = 9525;
        CTInline inline = run.getCTR().addNewDrawing().addNewInline();
        String picXml = "<a:graphic xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\">   <a:graphicData uri=\"http://schemas.openxmlformats.org/drawingml/2006/picture\">      <pic:pic xmlns:pic=\"http://schemas.openxmlformats.org/drawingml/2006/picture\">         <pic:nvPicPr>            <pic:cNvPr id=\"" + id + "\" name=\"Generated\"/>            <pic:cNvPicPr/>         </pic:nvPicPr>         <pic:blipFill>            <a:blip r:embed=\"" + blipId + "\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\"/>            <a:stretch>               <a:fillRect/>            </a:stretch>         </pic:blipFill>         <pic:spPr>            <a:xfrm>               <a:off x=\"0\" y=\"0\"/>               <a:ext cx=\"" + (width *= 9525) + "\" cy=\"" + (height *= 9525) + "\"/>            </a:xfrm>            <a:prstGeom prst=\"rect\">               <a:avLst/>            </a:prstGeom>         </pic:spPr>      </pic:pic>   </a:graphicData></a:graphic>";
        XmlToken xmlToken = null;
        try {
            xmlToken = XmlToken.Factory.parse((String)picXml);
        }
        catch (XmlException xe) {
            xe.printStackTrace();
        }
        inline.set((XmlObject)xmlToken);
        inline.setDistT(0L);
        inline.setDistB(0L);
        inline.setDistL(0L);
        inline.setDistR(0L);
        CTPositiveSize2D extent = inline.addNewExtent();
        extent.setCx((long)width);
        extent.setCy((long)height);
        CTNonVisualDrawingProps docPr = inline.addNewDocPr();
        docPr.setId((long)id);
        docPr.setName("Picture " + id);
        docPr.setDescr("Generated");
    }

    public NiceXWPFDocument generate() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.write(byteArrayOutputStream);
        this.close();
        return new NiceXWPFDocument(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
    }

    public NiceXWPFDocument merge(List<NiceXWPFDocument> docMerges, XWPFRun run) throws Exception {
        if (null == docMerges || docMerges.isEmpty() || null == run) {
            return this;
        }
        XWPFParagraph paragraph = this.insertNewParagraph(run);
        CTP ctp = paragraph.getCTP();
        CTBody body = this.getDocument().getBody();
        String srcString = body.xmlText();
        String prefix = srcString.substring(0, srcString.indexOf(">") + 1);
        String sufix = srcString.substring(srcString.lastIndexOf("<"));
        ArrayList<String> addParts = new ArrayList<String>();
        for (NiceXWPFDocument docMerge : docMerges) {
            addParts.add(this.extractMergePart(docMerge));
        }
        CTP makeBody = CTP.Factory.parse((String)(prefix + StringUtils.join(addParts, (String)"") + sufix));
        ctp.set((XmlObject)makeBody);
        String xmlText = body.xmlText();
        xmlText = xmlText.replaceAll("<w:p><w:p>", "<w:p>").replaceAll("<w:p><w:p\\s", "<w:p ").replaceAll("<w:p><w:tbl>", "<w:tbl>").replaceAll("<w:p><w:tbl\\s", "<w:tbl ");
        xmlText = xmlText.replaceAll("</w:sectPr></w:p>", "</w:sectPr>").replaceAll("</w:p></w:p>", "</w:p>").replaceAll("</w:tbl></w:p>", "</w:tbl>").replaceAll("<w:p(\\s[A-Za-z0-9:\\s=\"]*)?/></w:p>", "");
        body.set((XmlObject)CTBody.Factory.parse((String)xmlText));
        return this.generate();
    }

    public NiceXWPFDocument merge(NiceXWPFDocument docMerge) throws Exception {
        if (null == docMerge) {
            return this;
        }
        CTBody body = this.getDocument().getBody();
        String srcString = body.xmlText();
        String prefix = srcString.substring(0, srcString.indexOf(">") + 1);
        String mainPart = srcString.substring(srcString.indexOf(">") + 1, srcString.lastIndexOf("<"));
        String sufix = srcString.substring(srcString.lastIndexOf("<"));
        String addPart = this.extractMergePart(docMerge);
        CTBody makeBody = CTBody.Factory.parse((String)(prefix + mainPart + addPart + sufix));
        body.set((XmlObject)makeBody);
        return this.generate();
    }

    private String extractMergePart(NiceXWPFDocument docMerge) throws InvalidFormatException {
        CTBody bodyMerge = docMerge.getDocument().getBody();
        Map<String, String> styleIdsMap = this.mergeStyles(docMerge);
        Map<BigInteger, BigInteger> numIdsMap = this.mergeNumbering(docMerge);
        Map<String, String> blipIdsMap = this.mergePicture(docMerge);
        XmlOptions optionsOuter = new XmlOptions();
        optionsOuter.setSaveOuter();
        String appendString = bodyMerge.xmlText(optionsOuter);
        String addPart = this.ridSectPr(appendString);
        for (String styleId : styleIdsMap.keySet()) {
            addPart = addPart.replaceAll("<w:pStyle\\sw:val=\"" + styleId + "\"", "<w:pStyle w:val=\"" + styleIdsMap.get(styleId) + "\"").replaceAll("<w:tblStyle\\sw:val=\"" + styleId + "\"", "<w:tblStyle w:val=\"" + styleIdsMap.get(styleId) + "\"").replaceAll("<w:rStyle\\sw:val=\"" + styleId + "\"", "<w:rStyle w:val=\"" + styleIdsMap.get(styleId) + "\"");
        }
        for (String relaId : blipIdsMap.keySet()) {
            addPart = addPart.replaceAll("r:embed=\"" + relaId + "\"", "r:embed=\"" + blipIdsMap.get(relaId) + "\"");
        }
        for (BigInteger numId : numIdsMap.keySet()) {
            addPart = addPart.replaceAll("<w:numId\\sw:val=\"" + numId + "\"", "<w:numId w:val=\"" + numIdsMap.get(numId) + "\"");
        }
        try {
            docMerge.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return addPart;
    }

    private String ridSectPr(String appendString) {
        int lastIndexOf = appendString.lastIndexOf("<w:sectPr");
        String addPart = null;
        if (-1 != lastIndexOf) {
            String prefix = appendString.substring(appendString.indexOf(">") + 1, appendString.lastIndexOf("<w:sectPr"));
            String sufix = appendString.substring(appendString.lastIndexOf("</w:sectPr>") + 11, appendString.lastIndexOf("<"));
            return prefix + sufix;
        }
        addPart = appendString.substring(appendString.indexOf(">") + 1, appendString.lastIndexOf("<"));
        return addPart;
    }

    private Map<String, String> mergePicture(NiceXWPFDocument docMerge) throws InvalidFormatException {
        HashMap<String, String> blipIdsMap = new HashMap<String, String>();
        List allPictures = docMerge.getAllPictures();
        for (XWPFPictureData xwpfPictureData : allPictures) {
            String relationId = docMerge.getRelationId((POIXMLDocumentPart)xwpfPictureData);
            String blidId = this.addPictureData(xwpfPictureData.getData(), xwpfPictureData.getPictureType());
            blipIdsMap.put(relationId, blidId);
        }
        return blipIdsMap;
    }

    private Map<BigInteger, BigInteger> mergeNumbering(NiceXWPFDocument docMerge) {
        HashMap<BigInteger, BigInteger> numIdsMap = new HashMap<BigInteger, BigInteger>();
        XWPFNumbering numberingMerge = docMerge.getNumbering();
        if (null == numberingMerge) {
            return numIdsMap;
        }
        NumberingWrapper wrapperMerge = new NumberingWrapper(numberingMerge);
        List<XWPFNum> nums = wrapperMerge.getNums();
        if (null == nums) {
            return numIdsMap;
        }
        XWPFNumbering numbering = this.getNumbering();
        if (null == numbering) {
            numbering = this.createNumbering();
        }
        NumberingWrapper wrapper = new NumberingWrapper(numbering);
        for (XWPFNum xwpfNum : nums) {
            BigInteger mergeNumId = xwpfNum.getCTNum().getNumId();
            XWPFAbstractNum xwpfAbstractNum = numberingMerge.getAbstractNum(xwpfNum.getCTNum().getAbstractNumId().getVal());
            CTAbstractNum cTAbstractNum = xwpfAbstractNum.getCTAbstractNum();
            cTAbstractNum.setAbstractNumId(BigInteger.valueOf(wrapper.getAbstractNumsSize() + 10));
            BigInteger numID = numbering.addNum(numbering.addAbstractNum(new XWPFAbstractNum(cTAbstractNum)));
            numIdsMap.put(mergeNumId, numID);
        }
        return numIdsMap;
    }

    private Map<String, String> mergeStyles(NiceXWPFDocument docMerge) {
        HashMap<String, String> styleIdsMap = new HashMap<String, String>();
        XWPFStyles styles = this.getStyles();
        XWPFStyles stylesMerge = docMerge.getStyles();
        try {
            Field listStyleField = XWPFStyles.class.getDeclaredField("listStyle");
            listStyleField.setAccessible(true);
            List lists = (List)listStyleField.get(stylesMerge);
            for (XWPFStyle xwpfStyle : lists) {
                if (styles.styleExist(xwpfStyle.getStyleId())) {
                    String id = xwpfStyle.getStyleId();
                    xwpfStyle.setStyleId(UUID.randomUUID().toString());
                    styleIdsMap.put(id, xwpfStyle.getStyleId());
                }
                styles.addStyle(xwpfStyle);
            }
        }
        catch (Exception e) {
            logger.error("merge style error", (Throwable)e);
        }
        return styleIdsMap;
    }
}

