/*
 * Decompiled with CFR 0.152.
 */
package com.ctlok.springframework.web.servlet.view.rythm.tag;

import com.ctlok.springframework.web.servlet.view.rythm.Helper;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.lang3.LocaleUtils;
import org.rythmengine.template.ITag;
import org.rythmengine.template.JavaTagBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.NoSuchMessageException;
import org.springframework.web.servlet.LocaleResolver;

public class Message
extends JavaTagBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(Message.class);
    private final ApplicationContext applicationContext;
    private LocaleResolver localeResolver;
    private Locale defaultLocale;

    public Message(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        try {
            this.localeResolver = (LocaleResolver)applicationContext.getBean(LocaleResolver.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            LOGGER.warn("LocaleResolver not found. Default locale set to [{}]", (Object)Locale.ENGLISH);
        }
    }

    public String __getName() {
        return "message";
    }

    protected void call(ITag.__ParameterList params, ITag.__Body body) {
        String code = (String)(params.getByName("code") == null ? params.getDefault() : params.getByName("code"));
        String defaultMessage = (String)params.getByName("default");
        String localeString = (String)params.getByName("locale");
        Locale locale = this.getCurrentLocale(localeString);
        Object[] args = this.getMessageArgument(params);
        String message = null;
        try {
            message = defaultMessage == null ? this.applicationContext.getMessage(code, args, locale) : this.applicationContext.getMessage(code, args, defaultMessage, locale);
        }
        catch (NoSuchMessageException e) {
            LOGGER.warn("Message code [{}] not found. Default output message code.", (Object)code);
            message = code;
        }
        this.p(message);
    }

    protected Locale getCurrentLocale(String localeString) {
        try {
            if (localeString == null) {
                return this.getDefaultLocale();
            }
            return LocaleUtils.toLocale((String)localeString);
        }
        catch (IllegalArgumentException e) {
            Locale locale = this.getDefaultLocale();
            LOGGER.warn("Invalid locale string: [{}]. Set locale to [{}]", (Object)localeString, (Object)locale);
            return locale;
        }
    }

    protected Locale getDefaultLocale() {
        Locale result = null;
        result = this.localeResolver == null || Helper.getCurrentRequest() == null ? this.defaultLocale : this.localeResolver.resolveLocale(Helper.getCurrentRequest());
        return result;
    }

    protected Object[] getMessageArgument(ITag.__ParameterList params) {
        ArrayList<Object> args = new ArrayList<Object>();
        int i = 0;
        for (ITag.__Parameter parameter : params) {
            if (i > 0 && parameter.name == null) {
                args.add(parameter.value);
            }
            ++i;
        }
        return args.toArray();
    }
}

