/*
 * Decompiled with CFR 0.152.
 */
package com.ctlok.springframework.web.servlet.view.rythm.tag;

import com.ctlok.springframework.web.servlet.view.rythm.Helper;
import com.ctlok.springframework.web.servlet.view.rythm.tag.FileBasedTag;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.rythmengine.Rythm;
import org.rythmengine.template.ITag;
import org.rythmengine.template.ITemplate;
import org.rythmengine.template.JavaTagBase;
import org.rythmengine.template.TagBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.Resource;

public class FileBasedTagProxy
extends JavaTagBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileBasedTagProxy.class);
    private final boolean disableFileWrite;
    private final File file;
    private final String templateString;
    private final String tagName;
    private final Method templateSetBodyMethod;

    public FileBasedTagProxy(FileBasedTag fileBasedTag, String tempDirectoryPath, boolean disableFileWrite) throws IOException {
        this.disableFileWrite = disableFileWrite;
        if (disableFileWrite) {
            this.templateString = Helper.inputStreamToString(fileBasedTag.getResource().getInputStream());
            this.file = null;
            LOGGER.debug("Disable file write. Load template file as String: [{}]", (Object)this.templateString);
        } else {
            this.file = Helper.copyResourceToTempDirectory(tempDirectoryPath, fileBasedTag.getResource());
            this.templateString = null;
            LOGGER.debug("Enable file write. Copy template file to: [{}]", (Object)this.file.getAbsolutePath());
        }
        this.tagName = fileBasedTag.getTagName() == null ? this.getDefaultTagName(fileBasedTag.getResource()) : fileBasedTag.getTagName();
        this.templateSetBodyMethod = this.findTagBaseSetBodyMethod();
    }

    private String getDefaultTagName(Resource resource) {
        String templateFileName = resource.getFilename();
        int indexOfExt = templateFileName.lastIndexOf(".");
        return indexOfExt == -1 ? templateFileName : templateFileName.substring(0, indexOfExt);
    }

    private Method findTagBaseSetBodyMethod() {
        Method method = BeanUtils.findDeclaredMethod(TagBase.class, (String)"setBody", (Class[])new Class[]{ITag.__Body.class});
        method.setAccessible(true);
        return method;
    }

    public String __getName() {
        return this.tagName;
    }

    protected void call(ITag.__ParameterList params, ITag.__Body body) {
        ITemplate template = this.createTemplate();
        if (params.asMap().isEmpty()) {
            ArrayList<Object> templateArguments = new ArrayList<Object>();
            for (ITag.__Parameter param : params) {
                templateArguments.add(param.value);
            }
            template.__setRenderArgs(templateArguments.toArray());
        } else {
            template.__setRenderArgs(params.asMap());
        }
        if (body != null) {
            try {
                this.templateSetBodyMethod.invoke((Object)template, body);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        this.p(template.render());
    }

    protected ITemplate createTemplate() {
        ITemplate template = null;
        template = this.disableFileWrite ? Rythm.engine().getTemplate(this.templateString, new Object[0]) : Rythm.engine().getTemplate(this.file, new Object[0]);
        return template;
    }
}

