/*
 * Decompiled with CFR 0.152.
 */
package com.ctlok.springframework.web.servlet.view.rythm.interceptor;

import com.ctlok.springframework.web.servlet.view.rythm.form.CsrfTokenValidationSelector;
import com.ctlok.springframework.web.servlet.view.rythm.form.DefaultCsrfTokenValidationSelector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class CsrfTokenInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CsrfTokenInterceptor.class);
    private final String csrfTokenSessionName;
    private final String csrfTokenRequestName;
    private CsrfTokenValidationSelector csrfTokenValidationSelector = new DefaultCsrfTokenValidationSelector();

    public CsrfTokenInterceptor() {
        this.csrfTokenSessionName = "__csrfToken";
        this.csrfTokenRequestName = "_t";
    }

    public CsrfTokenInterceptor(String csrfTokenSessionName, String csrfTokenRequestName) {
        this.csrfTokenSessionName = csrfTokenSessionName;
        this.csrfTokenRequestName = csrfTokenRequestName;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        boolean validToken = true;
        if (this.csrfTokenValidationSelector.isRequireToValidate(request)) {
            HttpSession session = request.getSession(true);
            String sessionToken = (String)session.getAttribute(this.csrfTokenSessionName);
            String requestToken = request.getParameter(this.csrfTokenRequestName);
            LOGGER.debug("Session CSRF Token: [{}], Request CSRF Token: [{}]", (Object)sessionToken, (Object)requestToken);
            validToken = StringUtils.isNotEmpty((CharSequence)sessionToken) && StringUtils.isNotEmpty((CharSequence)requestToken) ? sessionToken.equals(requestToken) : false;
            LOGGER.debug("Is valid CSRF Token: [{}]", (Object)validToken);
        }
        if (!validToken) {
            response.sendError(403, "Bad or missing CSRF token");
        }
        return validToken;
    }

    public CsrfTokenValidationSelector getCsrfTokenValidationSelector() {
        return this.csrfTokenValidationSelector;
    }

    public void setCsrfTokenValidationSelector(CsrfTokenValidationSelector csrfTokenValidationSelector) {
        this.csrfTokenValidationSelector = csrfTokenValidationSelector;
    }
}

