/*
 * Decompiled with CFR 0.152.
 */
package com.ctlok.springframework.web.servlet.view.rythm.form;

import com.ctlok.springframework.web.servlet.view.rythm.form.Form;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.hibernate.validator.constraints.Length;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.context.MessageSource;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.validation.Validator;

public class SimpleForm<T>
implements Form<T> {
    private Class<T> wrappedInstanceClass;
    private T wrappedInstance;
    private BeanWrapper beanWrapper;
    private List<Validator> validators;
    private BindingResult bindingResult;
    private MessageSource messageSource;
    private Locale locale;
    private boolean actionSuccess;

    @Override
    public void init() {
        if (this.wrappedInstance == null) {
            this.beanWrapper = new BeanWrapperImpl(this.wrappedInstanceClass);
        } else {
            this.beanWrapper = new BeanWrapperImpl(this.wrappedInstance);
            if (this.bindingResult != null && this.validators != null) {
                for (Validator validator : this.validators) {
                    validator.validate(this.wrappedInstance, (Errors)this.bindingResult);
                }
            }
        }
    }

    @Override
    public Object get(String propertyName) {
        return this.beanWrapper.getPropertyValue(propertyName);
    }

    @Override
    public String getValue(String propertyName) {
        Object obj = this.get(propertyName);
        String result = null;
        if (obj != null) {
            result = obj.toString();
        }
        return result;
    }

    @Override
    public boolean isChecked(String propertyName) {
        Class<?> type = this.beanWrapper.getPropertyDescriptor(propertyName).getPropertyType();
        boolean checked = false;
        if (Boolean.class != type && Boolean.TYPE != type) {
            throw new IllegalStateException("Property: " + propertyName + " is not boolean type. Property type: " + type.getName());
        }
        checked = (Boolean)this.get(propertyName);
        return checked;
    }

    @Override
    public boolean isActionSuccess() {
        return this.actionSuccess;
    }

    @Override
    public void setActionSuccess(boolean actionSuccess) {
        this.actionSuccess = actionSuccess;
    }

    @Override
    public boolean hasGlobalErrors() {
        boolean result = false;
        if (this.bindingResult != null) {
            result = this.bindingResult.hasGlobalErrors();
        }
        return result;
    }

    @Override
    public String getGlobalErrorMessage() {
        String message = null;
        if (this.bindingResult != null && this.bindingResult.getGlobalError() != null) {
            ObjectError error = this.bindingResult.getGlobalError();
            message = error.getDefaultMessage();
        }
        return message;
    }

    @Override
    public List<String> getGlobalErrorMessages() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.bindingResult != null && this.bindingResult.getGlobalError() != null) {
            for (ObjectError error : this.bindingResult.getGlobalErrors()) {
                messages.add(error.getDefaultMessage());
            }
        }
        return messages;
    }

    @Override
    public boolean hasErrors() {
        boolean result = false;
        if (this.bindingResult != null) {
            result = this.bindingResult.hasErrors();
        }
        return result;
    }

    @Override
    public boolean hasError(String propertyName) {
        return this.getFieldError(propertyName) != null;
    }

    @Override
    public String getErrorMessage(String propertyName) {
        FieldError error = this.getFieldError(propertyName);
        String message = null;
        if (error != null) {
            message = this.getFieldErrorMessage(error);
        }
        return message;
    }

    @Override
    public boolean hasMaxLength(String propertyName) {
        return this.getPropertyLengthAnnotation(propertyName) != null;
    }

    @Override
    public int getMaxLength(String propertyName) {
        Length maxLength = this.getPropertyLengthAnnotation(propertyName);
        return maxLength == null ? -1 : maxLength.max();
    }

    @Override
    public void setWrappedInstanceClass(Class<T> wrappedInstanceClass) {
        this.wrappedInstanceClass = wrappedInstanceClass;
    }

    @Override
    public void setWrappedInstance(T wrappedInstance) {
        this.wrappedInstance = wrappedInstance;
    }

    @Override
    public T getWrappedInstance() {
        return (T)this.beanWrapper.getWrappedInstance();
    }

    @Override
    public List<Validator> getValidators() {
        return this.validators;
    }

    @Override
    public void setValidators(List<Validator> validators) {
        this.validators = validators;
    }

    @Override
    public BindingResult getBindingResult() {
        return this.bindingResult;
    }

    @Override
    public void setBindingResult(BindingResult bindingResult) {
        this.bindingResult = bindingResult;
    }

    @Override
    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    @Override
    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    protected FieldError getFieldError(String propertyName) {
        FieldError error = null;
        if (this.bindingResult != null) {
            error = this.bindingResult.getFieldError(propertyName);
        }
        return error;
    }

    protected String getFieldErrorMessage(FieldError fieldError) {
        String message = null;
        message = fieldError.isBindingFailure() ? this.messageSource.getMessage("form.error.binding", null, "Invalid Value", this.locale) : fieldError.getDefaultMessage();
        return message;
    }

    protected String buildErrorMessage(String code, Object ... params) {
        return this.messageSource.getMessage(code, params, code, this.locale);
    }

    protected Length getPropertyLengthAnnotation(String propertyName) {
        Length length = this.getGetterLengthAnnotation(propertyName);
        if (length == null) {
            length = this.getFieldLengthAnnotation(propertyName);
        }
        return length;
    }

    protected Length getGetterLengthAnnotation(String propertyName) {
        PropertyDescriptor descriptor = this.beanWrapper.getPropertyDescriptor(propertyName);
        Method getter = descriptor.getReadMethod();
        return getter.getAnnotation(Length.class);
    }

    protected Length getFieldLengthAnnotation(String propertyName) {
        try {
            Field field = this.beanWrapper.getWrappedClass().getDeclaredField(propertyName);
            field.setAccessible(true);
            return field.getAnnotation(Length.class);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    protected BeanWrapper getBeanWrapper() {
        return this.beanWrapper;
    }

    protected void setBeanWrapper(BeanWrapper beanWrapper) {
        this.beanWrapper = beanWrapper;
    }
}

