/*
 * Decompiled with CFR 0.152.
 */
package com.ctlok.springframework.web.servlet.view.rythm.form;

import com.ctlok.springframework.web.servlet.view.rythm.Helper;
import com.ctlok.springframework.web.servlet.view.rythm.constant.DefaultApplicationVariable;
import com.ctlok.springframework.web.servlet.view.rythm.form.Form;
import com.ctlok.springframework.web.servlet.view.rythm.form.FormFactory;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.web.servlet.LocaleResolver;

public abstract class AbstractFormFactory<T>
implements FormFactory<T> {
    private final ApplicationContext applicationContext;
    private final Class<T> formObjectClass;
    private List<Validator> validators;

    public AbstractFormFactory(ApplicationContext applicationContext, Class<T> formObjectClass) {
        this.applicationContext = applicationContext;
        this.formObjectClass = formObjectClass;
    }

    protected abstract Form<T> createSimpleForm();

    @Override
    public Form<T> createBlankForm() {
        Form<T> form = this.createSimpleForm();
        this.assignMessageSourceAndLocale(form);
        form.setWrappedInstanceClass(this.formObjectClass);
        form.init();
        return form;
    }

    @Override
    public Form<T> createForm(T formObject) {
        return this.createForm(formObject, null);
    }

    @Override
    public Form<T> createForm(T formObject, BindingResult bindingResult) {
        Form<T> form = this.createSimpleForm();
        this.assignMessageSourceAndLocale(form);
        form.setWrappedInstance(formObject);
        form.setBindingResult(bindingResult);
        form.setValidators(this.validators);
        form.init();
        return form;
    }

    @Override
    public List<Validator> getValidators() {
        return this.validators;
    }

    @Override
    public void setValidators(List<Validator> validators) {
        this.validators = validators;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Class<T> getFormObjectClass() {
        return this.formObjectClass;
    }

    protected void assignMessageSourceAndLocale(Form<T> form) {
        LocaleResolver localeResolver = (LocaleResolver)this.getApplicationContext().getBean(LocaleResolver.class);
        form.setMessageSource((MessageSource)this.getApplicationContext());
        if (localeResolver == null) {
            form.setLocale(DefaultApplicationVariable.LOCALE);
        } else {
            form.setLocale(localeResolver.resolveLocale(Helper.getCurrentRequest()));
        }
    }
}

