/*
 * Decompiled with CFR 0.152.
 */
package com.ctlok.springframework.web.servlet.view.rythm.cache;

import java.io.Serializable;
import org.rythmengine.extension.ICacheService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;

public class SpringRythmCache
implements ICacheService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringRythmCache.class);
    private final Cache cache;
    private int defaultTtl;

    public SpringRythmCache(Cache cache) {
        this.cache = cache;
    }

    public void put(String key, Serializable value, int ttl) {
        LOGGER.debug("Put cache with key: [{}] and TTL: [{}]", (Object)key, (Object)ttl);
        this.cache.put((Object)key, (Object)new CacheWrapper(ttl, value));
    }

    public void put(String key, Serializable value) {
        LOGGER.debug("Put cache with key: [{}] and TTL: [{}]", (Object)key, (Object)this.defaultTtl);
        this.cache.put((Object)key, (Object)new CacheWrapper(this.defaultTtl, value));
    }

    public Serializable remove(String key) {
        LOGGER.debug("Remove cache with key: [{}]", (Object)key);
        Serializable value = this.get(key);
        this.cache.evict((Object)key);
        return value;
    }

    public Serializable get(String key) {
        LOGGER.debug("Get cache with key: [{}]", (Object)key);
        Cache.ValueWrapper valueWrapper = this.cache.get((Object)key);
        Serializable value = null;
        if (valueWrapper != null) {
            CacheWrapper cacheWrapper = (CacheWrapper)valueWrapper.get();
            if (cacheWrapper.isExpire()) {
                this.cache.evict((Object)key);
            } else {
                value = cacheWrapper.getValue();
            }
        }
        return value;
    }

    public boolean contains(String key) {
        LOGGER.debug("Is contains cache with key: [{}]", (Object)key);
        return this.get(key) != null;
    }

    public void setDefaultTTL(int ttl) {
        LOGGER.debug("Default TTL: [{}]", (Object)ttl);
        this.defaultTtl = ttl;
    }

    public void clear() {
        LOGGER.debug("clear cache");
        this.cache.clear();
    }

    public void startup() {
    }

    public void shutdown() {
    }

    class CacheWrapper
    implements Serializable {
        private static final long serialVersionUID = 8422330991415116904L;
        private final long createTime = System.currentTimeMillis() / 1000L;
        private final int ttl;
        private final Serializable value;

        CacheWrapper(int ttl, Serializable value) {
            this.ttl = ttl;
            this.value = value;
        }

        public long getCreateTime() {
            return this.createTime;
        }

        public int getTtl() {
            return this.ttl;
        }

        public Serializable getValue() {
            return this.value;
        }

        public boolean isExpire() {
            long currentTime = System.currentTimeMillis() / 1000L;
            return currentTime - this.createTime > (long)this.ttl;
        }
    }
}

