/*
 * Decompiled with CFR 0.152.
 */
package com.ctlok.springframework.web.servlet.view.rythm;

import com.ctlok.springframework.web.servlet.view.rythm.Helper;
import com.ctlok.springframework.web.servlet.view.rythm.RythmConfigurator;
import com.ctlok.springframework.web.servlet.view.rythm.RythmView;
import com.ctlok.springframework.web.servlet.view.rythm.constant.DefaultApplicationVariable;
import com.ctlok.springframework.web.servlet.view.rythm.constant.DefaultRequestParameterName;
import com.ctlok.springframework.web.servlet.view.rythm.constant.DefaultSessionAttributeName;
import com.ctlok.springframework.web.servlet.view.rythm.form.Form;
import com.ctlok.springframework.web.servlet.view.rythm.tag.CookieValue;
import com.ctlok.springframework.web.servlet.view.rythm.tag.CsrfToken;
import com.ctlok.springframework.web.servlet.view.rythm.tag.DateFormat;
import com.ctlok.springframework.web.servlet.view.rythm.tag.FileBasedTag;
import com.ctlok.springframework.web.servlet.view.rythm.tag.FileBasedTagProxy;
import com.ctlok.springframework.web.servlet.view.rythm.tag.FullUrl;
import com.ctlok.springframework.web.servlet.view.rythm.tag.Message;
import com.ctlok.springframework.web.servlet.view.rythm.tag.Secured;
import com.ctlok.springframework.web.servlet.view.rythm.tag.Url;
import com.ctlok.springframework.web.servlet.view.rythm.tag.helper.SpringRythmFormHelper;
import com.ctlok.springframework.web.servlet.view.rythm.variable.HttpServletRequestVariable;
import com.ctlok.springframework.web.servlet.view.rythm.variable.ImplicitVariable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.rythmengine.Rythm;
import org.rythmengine.template.ITemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.view.AbstractTemplateViewResolver;

public class RythmViewResolver
extends AbstractTemplateViewResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(RythmViewResolver.class);
    protected static final String BUILD_IN_FILE_BASED_TAG_LOCATION = "classpath:com/ctlok/springframework/web/servlet/view/rythm/tag/template/";
    private final RythmConfigurator configurator;

    public RythmViewResolver(RythmConfigurator configurator) {
        this.configurator = configurator;
        this.setViewClass(this.requiredViewClass());
        this.setContentType("text/html");
    }

    protected Class<?> requiredViewClass() {
        return RythmView.class;
    }

    protected void initServletContext(ServletContext servletContext) {
        super.initServletContext(servletContext);
        this.setupSpringRythmConfig();
        this.initRythm();
    }

    protected void initRythm() {
        Map<String, Object> config = this.configurator.generateConfig();
        LOGGER.debug("Rythm config: [{}]", config);
        Rythm.init(config);
        if (this.configurator.getTags() != null) {
            for (ITemplate tag : this.configurator.getTags()) {
                LOGGER.debug("Register tag: [{}]", (Object)tag.__getName());
                Rythm.engine().registerTemplate(tag);
            }
        }
        if (this.configurator.getFileBasedTags() != null) {
            try {
                boolean disableFileWrite = Rythm.engine().conf().disableFileWrite();
                String fileBasedTagTempDirectory = this.configurator.getFileBasedTagTempDirectory();
                if (fileBasedTagTempDirectory == null) {
                    fileBasedTagTempDirectory = Helper.TEMP_DIR;
                }
                for (FileBasedTag fileBasedTag : this.configurator.getFileBasedTags()) {
                    FileBasedTagProxy tag = new FileBasedTagProxy(fileBasedTag, fileBasedTagTempDirectory, disableFileWrite);
                    LOGGER.debug("Register file based tag: [{}]", (Object)tag.__getName());
                    Rythm.engine().registerTemplate((ITemplate)tag);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        LOGGER.info("Rythm version [{}] setup success.", (Object)Rythm.engine().version());
    }

    protected void setupSpringRythmConfig() {
        this.setupBuildInImplicitVariables();
        this.setupBuildInImplicitPackage();
        this.setupBuiltInTag();
        this.setupBuiltInFileBasedTag();
    }

    protected void setupBuildInImplicitVariables() {
        if (this.configurator.getImplicitVariables() == null) {
            this.configurator.setImplicitVariables(new ArrayList<ImplicitVariable>());
        }
        this.configurator.getImplicitVariables().add(new HttpServletRequestVariable());
    }

    protected void setupBuildInImplicitPackage() {
        if (this.configurator.getImplicitPackages() == null) {
            this.configurator.setImplicitPackages(new ArrayList<String>());
        }
        this.configurator.getImplicitPackages().add(DefaultApplicationVariable.class.getName());
        this.configurator.getImplicitPackages().add(DefaultRequestParameterName.class.getName());
        this.configurator.getImplicitPackages().add(DefaultSessionAttributeName.class.getName());
        this.configurator.getImplicitPackages().add(Form.class.getName());
        this.configurator.getImplicitPackages().add(SpringRythmFormHelper.class.getName());
    }

    protected void setupBuiltInTag() {
        if (this.configurator.getTags() == null) {
            this.configurator.setTags(new ArrayList<ITemplate>());
        }
        for (ITemplate tag : this.createBuiltInTags()) {
            this.configurator.getTags().add(tag);
        }
    }

    protected void setupBuiltInFileBasedTag() {
        if (this.configurator.getFileBasedTags() == null) {
            this.configurator.setFileBasedTags(new ArrayList<FileBasedTag>());
        }
        for (FileBasedTag fileBasedTag : this.createBuiltInFileBasedTags()) {
            this.configurator.getFileBasedTags().add(fileBasedTag);
        }
    }

    protected List<ITemplate> createBuiltInTags() {
        ArrayList<ITemplate> tags = new ArrayList<ITemplate>();
        tags.add((ITemplate)new Url());
        tags.add((ITemplate)new FullUrl());
        tags.add((ITemplate)new Message(this.getApplicationContext()));
        tags.add((ITemplate)new Secured());
        tags.add((ITemplate)new DateFormat());
        tags.add((ITemplate)new CookieValue());
        tags.add((ITemplate)new CsrfToken(this.configurator.getCsrfTokenGenerator(), this.configurator.getCsrfTokenSessionName()));
        return tags;
    }

    protected List<FileBasedTag> createBuiltInFileBasedTags() {
        ArrayList<FileBasedTag> fileBasedTags = new ArrayList<FileBasedTag>();
        fileBasedTags.add(this.createFileBasedTag("hiddenCsrfToken.html", "hiddenCsrfToken"));
        fileBasedTags.add(this.createFileBasedTag("htmlForm.html", "htmlForm"));
        fileBasedTags.add(this.createFileBasedTag("inputHidden.html", "inputHidden"));
        fileBasedTags.add(this.createFileBasedTag("inputCheckbox.html", "inputCheckbox"));
        fileBasedTags.add(this.createFileBasedTag("inputOption.html", "inputOption"));
        fileBasedTags.add(this.createFileBasedTag("inputRadio.html", "inputRadio"));
        fileBasedTags.add(this.createFileBasedTag("inputSelect.html", "inputSelect"));
        fileBasedTags.add(this.createFileBasedTag("inputText.html", "inputText"));
        fileBasedTags.add(this.createFileBasedTag("inputTextarea.html", "inputTextarea"));
        return fileBasedTags;
    }

    protected Resource createTagResource(String fileName) {
        return this.getApplicationContext().getResource(BUILD_IN_FILE_BASED_TAG_LOCATION + fileName);
    }

    protected List<File> findTemplateFile(File root) {
        ArrayList<File> templateFiles = new ArrayList<File>();
        if (root.isDirectory()) {
            for (File file : root.listFiles()) {
                if (file.isFile()) {
                    templateFiles.add(file);
                    continue;
                }
                templateFiles.addAll(this.findTemplateFile(file));
            }
        }
        return templateFiles;
    }

    protected FileBasedTag createFileBasedTag(String templateName, String tagName) {
        return new FileBasedTag(this.createTagResource(templateName), tagName);
    }
}

