/*
 * Decompiled with CFR 0.152.
 */
package com.ctlok.springframework.web.servlet.view.rythm;

import com.ctlok.springframework.web.servlet.view.rythm.cache.SpringRythmCache;
import com.ctlok.springframework.web.servlet.view.rythm.form.CsrfTokenGenerator;
import com.ctlok.springframework.web.servlet.view.rythm.form.UUIDCsrfTokenGenerator;
import com.ctlok.springframework.web.servlet.view.rythm.log.RythmLoggerFactory;
import com.ctlok.springframework.web.servlet.view.rythm.tag.FileBasedTag;
import com.ctlok.springframework.web.servlet.view.rythm.variable.ImplicitVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rythmengine.Rythm;
import org.rythmengine.extension.IByteCodeHelper;
import org.rythmengine.extension.ICacheService;
import org.rythmengine.extension.IDurationParser;
import org.rythmengine.extension.ILoggerFactory;
import org.rythmengine.extension.ISourceCodeEnhancer;
import org.rythmengine.extension.ITemplateResourceLoader;
import org.rythmengine.template.ITemplate;
import org.springframework.cache.CacheManager;
import org.springframework.web.context.support.WebApplicationObjectSupport;

public class RythmConfigurator
extends WebApplicationObjectSupport {
    private Boolean cacheInProductionModeOnly;
    private Boolean compactOutput;
    private Boolean enableJavaExtensions;
    private Boolean loadPreCompiled;
    private Boolean logRenderTime;
    private Boolean noFileWrite;
    private Boolean preCompile;
    private String mode;
    private String rootDirectory;
    private String tempDirectory;
    private String preCompiledDirectory;
    private String fileBasedTagTempDirectory;
    private Integer cacheDefaultTTL;
    private List<String> implicitPackages;
    private List<ImplicitVariable> implicitVariables;
    private List<ITemplate> tags;
    private List<FileBasedTag> fileBasedTags;
    private ICacheService cacheService;
    private ClassLoader classLoader;
    private IDurationParser durationParser;
    private ILoggerFactory loggerFactory;
    private ITemplateResourceLoader resourceLoader;
    private IByteCodeHelper byteCodeHelper;
    private CacheManager cacheManager;
    private String springCacheName = "RYTHM_TEMPLATE_CACHE";
    private String csrfTokenSessionName = "__csrfToken";
    private CsrfTokenGenerator csrfTokenGenerator = new UUIDCsrfTokenGenerator();

    public Map<String, Object> generateConfig() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.setConfig(map, "cache.prod_only.enabled", this.cacheInProductionModeOnly);
        this.setConfig(map, "codegen.compact.enabled", this.compactOutput);
        this.setConfig(map, "feature.transformer.enabled", this.enableJavaExtensions);
        this.setConfig(map, "engine.load_precompiled.enabled", this.loadPreCompiled);
        this.setConfig(map, "log.time.render.enabled", this.logRenderTime);
        this.setConfig(map, "engine.file_write.enabled", this.noFileWrite == null ? null : Boolean.valueOf(this.noFileWrite == false));
        this.setConfig(map, "engine.precompile_mode.enabled", this.preCompile);
        this.modeConfig(map);
        this.rootDirectoryConfig(map);
        this.preCompiledDirectoryConfig(map);
        this.setConfig(map, "home.tmp", this.tempDirectory);
        this.setConfig(map, "default.cache_ttl", this.cacheDefaultTTL);
        this.implicitConfig(map);
        this.cacheServiceConfig(map);
        this.setConfig(map, "engine.class_loader.parent.impl", this.classLoader);
        this.setConfig(map, "cache.duration_parser.impl", this.durationParser);
        this.loggerFactoryConfig(map);
        this.setConfig(map, "resource.loader.impl", this.resourceLoader);
        this.setConfig(map, "engine.class_loader.bytecode_helper.impl", this.byteCodeHelper);
        return map;
    }

    protected void setConfig(Map<String, Object> map, String key, Object value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    protected void implicitConfig(Map<String, Object> map) {
        if (this.implicitVariables != null || this.implicitPackages != null) {
            map.put("codegen.source_code_enhancer.impl", new ISourceCodeEnhancer(){

                public List<String> imports() {
                    ArrayList<String> packages = new ArrayList<String>();
                    if (RythmConfigurator.this.implicitPackages != null) {
                        packages.addAll(RythmConfigurator.this.implicitPackages);
                    }
                    return packages;
                }

                public Map<String, ?> getRenderArgDescriptions() {
                    HashMap<String, String> descriptions = new HashMap<String, String>();
                    if (RythmConfigurator.this.implicitVariables != null) {
                        for (ImplicitVariable implicitVariable : RythmConfigurator.this.implicitVariables) {
                            descriptions.put(implicitVariable.getName(), implicitVariable.getType());
                        }
                    }
                    return descriptions;
                }

                public void setRenderArgs(ITemplate template) {
                    if (RythmConfigurator.this.implicitVariables != null) {
                        for (ImplicitVariable implicitVariable : RythmConfigurator.this.implicitVariables) {
                            template.__setRenderArg(implicitVariable.getName(), implicitVariable.getValue());
                        }
                    }
                }

                public String sourceCode() {
                    return null;
                }
            });
        }
    }

    protected void loggerFactoryConfig(Map<String, Object> map) {
        if (this.loggerFactory == null) {
            this.loggerFactory = new RythmLoggerFactory();
        }
        map.put("log.factory.impl", this.loggerFactory);
    }

    protected void modeConfig(Map<String, Object> map) {
        if (this.mode != null) {
            if (Rythm.Mode.prod.name().equalsIgnoreCase(this.mode)) {
                map.put("engine.mode", Rythm.Mode.prod);
            } else if (Rythm.Mode.dev.name().equalsIgnoreCase(this.mode)) {
                map.put("engine.mode", Rythm.Mode.dev);
            }
        }
    }

    protected void rootDirectoryConfig(Map<String, Object> map) {
        if (this.rootDirectory != null) {
            map.put("home.template", this.getServletContext().getRealPath(this.rootDirectory));
        }
    }

    protected void preCompiledDirectoryConfig(Map<String, Object> map) {
        if (this.preCompiledDirectory != null) {
            map.put("home.precompiled.dir", this.getServletContext().getRealPath(this.preCompiledDirectory));
        }
    }

    protected void cacheServiceConfig(Map<String, Object> map) {
        if (this.cacheManager == null) {
            this.setConfig(map, "cache.service.impl", this.cacheService);
        } else {
            SpringRythmCache springRythmCache = new SpringRythmCache(this.cacheManager.getCache(this.springCacheName));
            this.setConfig(map, "cache.service.impl", springRythmCache);
        }
    }

    public Boolean isCacheInProductionModeOnly() {
        return this.cacheInProductionModeOnly;
    }

    public void setCacheInProductionModeOnly(Boolean cacheInProductionModeOnly) {
        this.cacheInProductionModeOnly = cacheInProductionModeOnly;
    }

    public Boolean isCompactOutput() {
        return this.compactOutput;
    }

    public void setCompactOutput(Boolean compactOutput) {
        this.compactOutput = compactOutput;
    }

    public Boolean isEnableJavaExtensions() {
        return this.enableJavaExtensions;
    }

    public void setEnableJavaExtensions(Boolean enableJavaExtensions) {
        this.enableJavaExtensions = enableJavaExtensions;
    }

    public Boolean isLoadPreCompiled() {
        return this.loadPreCompiled;
    }

    public void setLoadPreCompiled(Boolean loadPreCompiled) {
        this.loadPreCompiled = loadPreCompiled;
    }

    public Boolean isNoFileWrite() {
        return this.noFileWrite;
    }

    public void setNoFileWrite(Boolean noFileWrite) {
        this.noFileWrite = noFileWrite;
    }

    public Boolean isLogRenderTime() {
        return this.logRenderTime;
    }

    public void setLogRenderTime(Boolean logRenderTime) {
        this.logRenderTime = logRenderTime;
    }

    public Boolean isPreCompile() {
        return this.preCompile;
    }

    public void setPreCompile(Boolean preCompile) {
        this.preCompile = preCompile;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getRootDirectory() {
        return this.rootDirectory;
    }

    public void setRootDirectory(String rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public String getTempDirectory() {
        return this.tempDirectory;
    }

    public void setTempDirectory(String tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    public Integer getCacheDefaultTTL() {
        return this.cacheDefaultTTL;
    }

    public void setCacheDefaultTTL(Integer cacheDefaultTTL) {
        this.cacheDefaultTTL = cacheDefaultTTL;
    }

    public List<String> getImplicitPackages() {
        return this.implicitPackages;
    }

    public void setImplicitPackages(List<String> implicitPackages) {
        this.implicitPackages = implicitPackages;
    }

    public List<ImplicitVariable> getImplicitVariables() {
        return this.implicitVariables;
    }

    public void setImplicitVariables(List<ImplicitVariable> implicitVariables) {
        this.implicitVariables = implicitVariables;
    }

    public List<ITemplate> getTags() {
        return this.tags;
    }

    public void setTags(List<ITemplate> tags) {
        this.tags = tags;
    }

    public ICacheService getCacheService() {
        return this.cacheService;
    }

    public void setCacheService(ICacheService cacheService) {
        this.cacheService = cacheService;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public IDurationParser getDurationParser() {
        return this.durationParser;
    }

    public void setDurationParser(IDurationParser durationParser) {
        this.durationParser = durationParser;
    }

    public ILoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public void setLoggerFactory(ILoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
    }

    public ITemplateResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ITemplateResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public IByteCodeHelper getByteCodeHelper() {
        return this.byteCodeHelper;
    }

    public void setByteCodeHelper(IByteCodeHelper byteCodeHelper) {
        this.byteCodeHelper = byteCodeHelper;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public String getSpringCacheName() {
        return this.springCacheName;
    }

    public void setSpringCacheName(String springCacheName) {
        this.springCacheName = springCacheName;
    }

    public List<FileBasedTag> getFileBasedTags() {
        return this.fileBasedTags;
    }

    public void setFileBasedTags(List<FileBasedTag> fileBasedTags) {
        this.fileBasedTags = fileBasedTags;
    }

    public String getCsrfTokenSessionName() {
        return this.csrfTokenSessionName;
    }

    public void setCsrfTokenSessionName(String csrfTokenSessionName) {
        this.csrfTokenSessionName = csrfTokenSessionName;
    }

    public CsrfTokenGenerator getCsrfTokenGenerator() {
        return this.csrfTokenGenerator;
    }

    public void setCsrfTokenGenerator(CsrfTokenGenerator csrfTokenGenerator) {
        this.csrfTokenGenerator = csrfTokenGenerator;
    }

    public String getPreCompiledDirectory() {
        return this.preCompiledDirectory;
    }

    public void setPreCompiledDirectory(String preCompiledDirectory) {
        this.preCompiledDirectory = preCompiledDirectory;
    }

    public String getFileBasedTagTempDirectory() {
        return this.fileBasedTagTempDirectory;
    }

    public void setFileBasedTagTempDirectory(String fileBasedTagTempDirectory) {
        this.fileBasedTagTempDirectory = fileBasedTagTempDirectory;
    }
}

