/*
 * Decompiled with CFR 0.152.
 */
package com.ctlok.springframework.web.servlet.view.rythm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.io.Resource;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class Helper {
    public static final String TEMP_DIR = System.getProperty("java.io.tmpdir") + "/spring-webmvc-rythm";

    public static HttpServletRequest getCurrentRequest() {
        try {
            ServletRequestAttributes attr = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
            return attr.getRequest();
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    public static String inputStreamToString(InputStream inputStream) {
        StringBuilder builder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String line = bufferedReader.readLine();
            while (line != null) {
                builder.append(line);
                builder.append('\n');
                line = bufferedReader.readLine();
            }
            bufferedReader.close();
            String string = builder.toString();
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static void inputStreamToOutputStream(InputStream inputStream, OutputStream outputStream) {
        try {
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static File copyResourceToTempDirectory(Resource resource) {
        return Helper.copyResourceToTempDirectory(TEMP_DIR, resource);
    }

    public static File copyResourceToTempDirectory(String tempDirectoryPath, Resource resource) {
        File file = Helper.createTempFile(tempDirectoryPath, resource.getFilename());
        InputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            inputStream = resource.getInputStream();
            outputStream = new FileOutputStream(file);
            Helper.inputStreamToOutputStream(inputStream, outputStream);
            File file2 = file;
            return file2;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            if (outputStream != null) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    private static File createTempFile(String tempDirPath, String fileName) {
        File tempDir = new File(tempDirPath);
        File file = new File(tempDirPath + "/" + fileName);
        tempDir.mkdirs();
        return file;
    }
}

