/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.spi.message;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum LCNCmdType {
    notifyUnit("notify-unit", "notifyUnit"),
    createGroup("create-group", "createGroup"),
    joinGroup("join-group", "joinGroup"),
    notifyGroup("notify-group", "notifyGroup"),
    askTransactionState("ask-transaction-state", "askTransactionState"),
    writeCompensation("write-compensation", "writeException"),
    notifyConnect("notify-connect", "newTxManager"),
    initClient("init-client", "initClient"),
    getAspectLog("get-aspect-log", "getAspectLog");

    private static final Logger log;
    private String code;
    private String name;

    private LCNCmdType(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static LCNCmdType parserCmd(String cmd) {
        log.debug("parsed cmd: {}", (Object)cmd);
        switch (cmd) {
            case "createGroup": {
                return createGroup;
            }
            case "notifyGroup": {
                return notifyGroup;
            }
            case "notifyUnit": {
                return notifyUnit;
            }
            case "joinGroup": {
                return joinGroup;
            }
            case "askTransactionState": {
                return askTransactionState;
            }
            case "writeException": {
                return writeCompensation;
            }
            case "newTxManager": {
                return notifyConnect;
            }
            case "getAspectLog": {
                return getAspectLog;
            }
            case "initClient": {
                return initClient;
            }
        }
        throw new IllegalStateException("unsupported cmd.");
    }

    static {
        log = LoggerFactory.getLogger(LCNCmdType.class);
    }
}

