/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.upload;

import com.cloudbees.utils.ZipHelper;
import com.thoughtworks.xstream.XStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JarUtils {
    private static final String META_INF = "META-INF";
    private static final String JAR_FILE = "CB-JAR.xml";
    private static final int STREAM_BUFFER_LENGTH = 1024;
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();

    private JarUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static Map<String, String> getJarHashes(File warFile) throws IOException {
        HashMap<String, String> hashes = new HashMap<String, String>();
        ZipFile zipFile = new ZipFile(warFile.getAbsolutePath());
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            String name = entry.getName();
            if (!name.endsWith(".jar")) continue;
            hashes.put(name, JarUtils.sha256(zipFile.getInputStream(entry)));
        }
        zipFile.close();
        return hashes;
    }

    public static File createDeltaWarFile(Map<String, String> existingArchiveJars, File warFile, String tmp) throws IOException {
        HashMap<String, String> hashes = new HashMap<String, String>();
        String tmpDir = JarUtils.makeTmpDir(warFile, tmp);
        ZipFile zipFile = new ZipFile(warFile.getAbsolutePath());
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            String name = entry.getName();
            String hash = existingArchiveJars.get(name);
            String entrySha = JarUtils.sha256(zipFile.getInputStream(entry));
            if (hash != null && hash.equals(entrySha)) {
                hashes.put(name, entrySha);
                continue;
            }
            JarUtils.unArchiveZipEntry(tmpDir, zipFile, entry);
        }
        zipFile.close();
        File metaInfDir = new File(tmpDir + META_INF);
        metaInfDir.mkdirs();
        File deltaFile = new File(metaInfDir, JAR_FILE);
        XStream xstream = new XStream();
        FileOutputStream fos = new FileOutputStream(deltaFile);
        xstream.toXML(hashes, (OutputStream)fos);
        fos.close();
        String deltaDir = warFile.getParent() == null ? "." : warFile.getParent();
        String deltaArchiveFile = deltaDir + "/JAR-" + warFile.getName();
        JarUtils.archiveDirectory(tmpDir, deltaArchiveFile);
        JarUtils.deleteAll(new File(tmpDir));
        return new File(deltaArchiveFile);
    }

    private static void unArchiveZipEntry(String destinationDirectory, ZipFile zipfile, ZipEntry entry) throws IOException {
        File file = ZipHelper.unzipEntryToFolder(entry, zipfile.getInputStream(entry), new File(destinationDirectory));
        if (entry.getTime() > -1L) {
            file.setLastModified(entry.getTime());
        }
    }

    private static void archiveDirectory(String directory, String archiveFile) throws IOException {
        File archive = new File(archiveFile);
        archive.createNewFile();
        FileOutputStream fileOutputStream = new FileOutputStream(archive);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
        ZipHelper.addDirectoryToZip(new File(directory), new File(directory), null, zipOutputStream);
        zipOutputStream.close();
    }

    private static String makeTmpDir(File file, String tmp) {
        String fileName;
        int idx;
        if (tmp == null) {
            tmp = ".";
        }
        if ((idx = (fileName = file.getName()).lastIndexOf(46)) > -1) {
            fileName = fileName.substring(0, idx);
        }
        if (!tmp.endsWith(File.separator)) {
            tmp = tmp + File.separator;
        }
        tmp = tmp + "tmp" + fileName + File.separator;
        File dir = new File(tmp);
        JarUtils.deleteAll(dir);
        dir.mkdirs();
        return tmp;
    }

    private static void deleteAll(File dir) {
        if (dir.exists()) {
            File[] files;
            if (dir.isDirectory() && (files = dir.listFiles()) != null) {
                for (File f : files) {
                    if (f.isDirectory()) {
                        JarUtils.deleteAll(f);
                        continue;
                    }
                    f.delete();
                }
            }
            dir.delete();
        }
    }

    static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private static String sha256(InputStream data) throws IOException {
        MessageDigest digest = JarUtils.getDigest("SHA-256");
        byte[] buffer = new byte[1024];
        int read = data.read(buffer, 0, 1024);
        while (read > -1) {
            digest.update(buffer, 0, read);
            read = data.read(buffer, 0, 1024);
        }
        return JarUtils.asHex(digest.digest());
    }

    private static String asHex(byte[] buf) {
        char[] chars = new char[2 * buf.length];
        for (int i = 0; i < buf.length; ++i) {
            chars[2 * i] = HEX_CHARS[(buf[i] & 0xF0) >>> 4];
            chars[2 * i + 1] = HEX_CHARS[buf[i] & 0xF];
        }
        return new String(chars);
    }
}

