/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.api.oauth;

import com.cloudbees.api.cr.Capability;
import com.cloudbees.api.cr.CloudResource;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.jackson.annotate.JsonProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenRequest {
    private String accountName;
    private String note;
    private String noteUrl;
    private final List<String> scopes = new ArrayList<String>();
    private String refreshToken;
    private String accessType = "online";

    public TokenRequest(String note, String noteUrl, String refreshToken, String accountName, String ... scopes) {
        this.note = note;
        this.noteUrl = noteUrl;
        this.accountName = accountName;
        this.refreshToken = refreshToken;
        for (String scope : scopes) {
            this.withScope(scope);
        }
    }

    public TokenRequest() {
    }

    @JsonProperty(value="note")
    public String getNote() {
        return this.note;
    }

    @JsonProperty(value="note_url")
    public String getNoteUrl() {
        return this.noteUrl;
    }

    public TokenRequest withNote(String note) {
        return this.withNote(note, null);
    }

    public TokenRequest withNote(String note, String noteUrl) {
        this.note = note;
        this.note = noteUrl;
        return this;
    }

    @JsonProperty(value="scopes")
    public List<String> getScopes() {
        return Collections.unmodifiableList(this.scopes);
    }

    public TokenRequest withScope(String scope) {
        if (scope != null) {
            try {
                new URI(scope);
                this.scopes.add(scope);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Scope must be a valid URI: " + scope, e);
            }
        }
        return this;
    }

    public TokenRequest withScopes(String ... scopes) {
        for (String scope : scopes) {
            this.withScope(scope);
        }
        return this;
    }

    public TokenRequest withScope(CloudResource res, Capability capability) {
        return this.withScope(capability.to(res));
    }

    public TokenRequest withScope(URL cloudResource, Capability capability) {
        return this.withScope(capability.to(cloudResource));
    }

    @JsonProperty(value="refresh_token")
    public String getRefreshToken() {
        return this.refreshToken;
    }

    public TokenRequest withRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    @JsonProperty(value="account_name")
    public String getAccountName() {
        return this.accountName;
    }

    public TokenRequest withAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @JsonProperty(value="access_type")
    public String getAccessType() {
        return this.accessType;
    }

    public TokenRequest withGenerateRequestToken(boolean b) {
        this.accessType = b ? "offline" : "online";
        return this;
    }

    public String toString() {
        return super.toString() + "[accountName=" + this.accountName + ",scopes=" + this.scopes + ",accessType=" + this.accessType + "]";
    }
}

