/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.api.cr;

import com.cloudbees.api.cr.Capability;
import com.cloudbees.api.cr.CloudResourceFacet;
import com.cloudbees.api.cr.CloudResourceJacksonModule;
import com.cloudbees.api.cr.CloudResourceType;
import com.cloudbees.api.cr.Credential;
import com.cloudbees.api.oauth.OauthToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudResource {
    private final URL url;
    private final Credential credential;
    private volatile Set<String> types;
    private volatile ObjectNode payload;
    public static final ObjectMapper MAPPER = new ObjectMapper();
    public static final String CONTENT_TYPE = "application/vnd.cloudbees.resource+json";
    public static final String CONTENT_TYPE_UTF8 = "application/vnd.cloudbees.resource+json;charset=UTF-8";
    public static Capability READ_CAPABILITY;
    public static PrintStream DEBUG;

    public CloudResource(URL url, Credential credential) {
        String e = url.toExternalForm();
        if (!e.endsWith("/")) {
            try {
                url = new URL(e + '/');
            }
            catch (MalformedURLException x) {
                throw new Error(x);
            }
        }
        this.url = url;
        this.credential = credential;
    }

    public static CloudResource fromOAuthToken(URL url, String oauthAccessToken) {
        return new CloudResource(url, Credential.oauth(oauthAccessToken));
    }

    public static CloudResource fromOAuthToken(URL url, OauthToken token) {
        return CloudResource.fromOAuthToken(url, token.accessToken);
    }

    public URL getUrl() {
        return this.url;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public <T extends CloudResourceFacet> T as(Class<T> facet) throws IOException {
        if (this.hasType(facet)) {
            return this.coerce(facet);
        }
        throw new ClassCastException(String.format("%s is not of type: %s. Valid types are %s", this.url, facet, this.types));
    }

    public <T extends CloudResourceFacet> T coerce(Class<T> facet) throws IOException {
        try {
            return (T)((CloudResourceFacet)facet.cast(facet.getConstructor(CloudResource.class).newInstance(this)));
        }
        catch (InstantiationException e) {
            throw new Error(e);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        catch (InvocationTargetException e) {
            throw new Error(e);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
    }

    public <T extends CloudResourceFacet> boolean hasType(Class<T> facet) throws IOException {
        CloudResourceType a = facet.getAnnotation(CloudResourceType.class);
        if (a == null) {
            throw new IllegalArgumentException(facet + " isn't annotated with @CloudResourceType");
        }
        return this.hasType(a.value());
    }

    public boolean hasType(String fullyQualifiedTypeName) throws IOException {
        if (this.types == null) {
            this.retrieve();
        }
        return this.types.contains(fullyQualifiedTypeName);
    }

    public void setTypes(Collection<String> types) {
        this.types = new HashSet<String>(types);
    }

    public ObjectNode retrieve(boolean force) throws IOException {
        if (force || this.payload == null) {
            HttpURLConnection con = this.connect();
            this.payload = (ObjectNode)MAPPER.readTree(this.decorateResponseStream(con.getInputStream()));
        }
        return this.payload;
    }

    public ObjectNode retrieve() throws IOException {
        return this.retrieve(false);
    }

    public <T> T retrieve(Class<T> type, boolean force) throws IOException {
        return (T)MAPPER.readValue((JsonNode)this.retrieve(force), type);
    }

    public <T> T retrieve(Class<T> type) throws IOException {
        return this.retrieve(type, false);
    }

    public <T> T post(String path, Object request, Class<T> responseType) throws IOException {
        HttpURLConnection con = (HttpURLConnection)new URL(this.url, path).openConnection();
        this.credential.authorizeRequest(con);
        this.sendRequest(request, con);
        if (responseType != null) {
            return (T)MAPPER.readValue(this.decorateResponseStream(con.getInputStream()), responseType);
        }
        con.getInputStream().close();
        return null;
    }

    public CloudResource create(String path, Object request) throws IOException {
        URL ep = new URL(this.url, path);
        HttpURLConnection con = (HttpURLConnection)ep.openConnection();
        this.credential.authorizeRequest(con);
        this.sendRequest(request, con);
        this.decorateResponseStream(con.getInputStream());
        if (con.getResponseCode() == 201) {
            String location = con.getHeaderField("Location");
            if (location == null) {
                throw new IllegalStateException(ep + " reported 201 but there's no location header");
            }
            return new CloudResource(new URL(location), this.credential);
        }
        throw new IllegalStateException(ep + " reported success " + con.getResponseCode() + " but expecting 201");
    }

    private void sendRequest(Object request, HttpURLConnection con) throws IOException {
        con.setRequestMethod("POST");
        con.setRequestProperty("Accept", CONTENT_TYPE);
        con.setRequestProperty("Content-Type", CONTENT_TYPE_UTF8);
        con.setDoOutput(true);
        for (String t : CloudResource.typesOf(request.getClass())) {
            con.addRequestProperty("X-Cloud-Resource-Type", t);
        }
        this.dumpRequestHeaders(con);
        MAPPER.writeValue(this.decorateRequestStream(con.getOutputStream()), request);
        con.getOutputStream().close();
        this.checkError(con);
    }

    public HttpURLConnection connect() throws IOException {
        HttpURLConnection con = (HttpURLConnection)this.url.openConnection();
        this.credential.authorizeRequest(con);
        con.setRequestProperty("Accept", CONTENT_TYPE);
        this.dumpRequestHeaders(con);
        this.checkError(con);
        List<String> v = con.getHeaderFields().get("X-Cloud-Resource-Type");
        if (v == null) {
            throw new IOException(this.url + " is not a cloud resource. It reported no X-Cloud-Resource-Type header");
        }
        this.types = new HashSet<String>(v);
        String ct = con.getHeaderField("Content-Type");
        if (ct == null) {
            throw new IOException(this.url + " is not a cloud resource. It reported no Content-Type");
        }
        if (!ct.startsWith(CONTENT_TYPE)) {
            throw new IOException(this.url + " is not a cloud resource. It reported Content-Type=" + ct + " while we expected " + CONTENT_TYPE);
        }
        return con;
    }

    private void checkError(HttpURLConnection con) throws IOException {
        this.dumpResponseHeaders(con);
        if (con.getResponseCode() / 100 != 2) {
            String msg = "Failed to retrieve " + this.url;
            InputStream er = con.getErrorStream();
            if (er != null) {
                msg = msg + ": " + IOUtils.toString((InputStream)er);
            }
            throw new IOException(msg);
        }
    }

    private void dumpRequestHeaders(HttpURLConnection con) {
        if (DEBUG == null) {
            return;
        }
        DEBUG.println();
        DEBUG.printf("> %s %s\n", con.getRequestMethod(), con.getURL());
        for (Map.Entry<String, List<String>> e : con.getRequestProperties().entrySet()) {
            String header = e.getKey();
            for (String v : e.getValue()) {
                DEBUG.printf("> %s: %s\n", header, v);
            }
        }
    }

    private OutputStream decorateRequestStream(final OutputStream os) {
        if (DEBUG == null) {
            return os;
        }
        return new OutputStream(){

            public void write(int b) throws IOException {
                DEBUG.write(b);
                os.write(b);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                DEBUG.write(b, off, len);
                os.write(b, off, len);
            }

            public void flush() throws IOException {
                os.flush();
            }

            public void close() throws IOException {
                os.close();
            }
        };
    }

    private InputStream decorateResponseStream(InputStream is) throws IOException {
        if (DEBUG == null || is == null) {
            return is;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)is, (OutputStream)baos);
        DEBUG.println(baos.toString());
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private void dumpResponseHeaders(HttpURLConnection con) throws IOException {
        if (DEBUG == null) {
            return;
        }
        DEBUG.println();
        DEBUG.printf("< %s %s\n", con.getResponseCode(), con.getResponseMessage());
        for (Map.Entry<String, List<String>> e : con.getHeaderFields().entrySet()) {
            String header = e.getKey();
            if (header == null) continue;
            for (String v : e.getValue()) {
                DEBUG.printf("< %s: %s\n", header, v);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudResource that = (CloudResource)o;
        return this.url.equals(that.url);
    }

    public int hashCode() {
        return this.url != null ? this.url.hashCode() : 0;
    }

    public String toString() {
        return this.url.toString();
    }

    public static Set<String> typesOf(Class<?> bean) {
        HashSet<String> r = new HashSet<String>();
        CloudResource.typesOf(bean, r);
        return r;
    }

    private static void typesOf(Class<?> t, Set<String> r) {
        if (t == null) {
            return;
        }
        CloudResourceType a = t.getAnnotation(CloudResourceType.class);
        if (a != null) {
            r.add(a.value());
        }
        for (Class<?> i : t.getInterfaces()) {
            CloudResource.typesOf(i, r);
        }
        CloudResource.typesOf(t.getSuperclass(), r);
    }

    static {
        MAPPER.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.configure(DeserializationConfig.Feature.AUTO_DETECT_FIELDS, false);
        MAPPER.configure(DeserializationConfig.Feature.AUTO_DETECT_SETTERS, false);
        MAPPER.registerModule((Module)new CloudResourceJacksonModule());
        READ_CAPABILITY = new Capability("https://types.cloudbees.com/resource/read");
        DEBUG = null;
    }
}

